/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * ListVpcAssociationAuthorizationsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListVpcAssociationAuthorizationsResponseUnmarshaller implements
        Unmarshaller<ListVpcAssociationAuthorizationsResponse, StaxUnmarshallerContext> {

    public ListVpcAssociationAuthorizationsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListVpcAssociationAuthorizationsResponse.Builder listVpcAssociationAuthorizationsResponse = ListVpcAssociationAuthorizationsResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<VPC> vpCs = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listVpcAssociationAuthorizationsResponse.vpCs(vpCs);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("HostedZoneId", targetDepth)) {
                    listVpcAssociationAuthorizationsResponse.hostedZoneId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextToken", targetDepth)) {
                    listVpcAssociationAuthorizationsResponse.nextToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("VPCs", targetDepth)) {
                    vpCs = new ArrayList<VPC>();
                    continue;
                }

                if (context.testExpression("VPCs/VPC", targetDepth)) {
                    vpCs.add(VPCUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listVpcAssociationAuthorizationsResponse.vpCs(vpCs);
                    break;
                }
            }
        }
        return listVpcAssociationAuthorizationsResponse.build();
    }

    private static final ListVpcAssociationAuthorizationsResponseUnmarshaller INSTANCE = new ListVpcAssociationAuthorizationsResponseUnmarshaller();

    public static ListVpcAssociationAuthorizationsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
