/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringConversion;

/**
 * TestDnsAnswerRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class TestDnsAnswerRequestMarshaller implements Marshaller<Request<TestDnsAnswerRequest>, TestDnsAnswerRequest> {

    public Request<TestDnsAnswerRequest> marshall(TestDnsAnswerRequest testDnsAnswerRequest) {

        if (testDnsAnswerRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<TestDnsAnswerRequest> request = new DefaultRequest<TestDnsAnswerRequest>(testDnsAnswerRequest, "Route53Client");

        request.setHttpMethod(HttpMethodName.GET);

        String uriResourcePath = "/2013-04-01/testdnsanswer";

        request.setResourcePath(uriResourcePath);

        if (testDnsAnswerRequest.hostedZoneId() != null) {
            request.addParameter("hostedzoneid", StringConversion.fromString(testDnsAnswerRequest.hostedZoneId()));
        }

        if (testDnsAnswerRequest.recordName() != null) {
            request.addParameter("recordname", StringConversion.fromString(testDnsAnswerRequest.recordName()));
        }

        if (testDnsAnswerRequest.recordTypeAsString() != null) {
            request.addParameter("recordtype", StringConversion.fromString(testDnsAnswerRequest.recordTypeAsString()));
        }

        if (testDnsAnswerRequest.resolverIP() != null) {
            request.addParameter("resolverip", StringConversion.fromString(testDnsAnswerRequest.resolverIP()));
        }

        if (testDnsAnswerRequest.edns0ClientSubnetIP() != null) {
            request.addParameter("edns0clientsubnetip", StringConversion.fromString(testDnsAnswerRequest.edns0ClientSubnetIP()));
        }

        if (testDnsAnswerRequest.edns0ClientSubnetMask() != null) {
            request.addParameter("edns0clientsubnetmask",
                    StringConversion.fromString(testDnsAnswerRequest.edns0ClientSubnetMask()));
        }

        return request;
    }

}