/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import static java.nio.charset.StandardCharsets.UTF_8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.utils.StringInputStream;

import software.amazon.awssdk.core.util.xml.XmlWriter;

/**
 * UpdateHealthCheckRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateHealthCheckRequestMarshaller implements
        Marshaller<Request<UpdateHealthCheckRequest>, UpdateHealthCheckRequest> {

    public Request<UpdateHealthCheckRequest> marshall(UpdateHealthCheckRequest updateHealthCheckRequest) {

        if (updateHealthCheckRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<UpdateHealthCheckRequest> request = new DefaultRequest<UpdateHealthCheckRequest>(updateHealthCheckRequest,
                "Route53Client");

        request.setHttpMethod(HttpMethodName.POST);

        String uriResourcePath = "/2013-04-01/healthcheck/{HealthCheckId}";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshaller.NON_GREEDY.marshall(uriResourcePath,
                "HealthCheckId", updateHealthCheckRequest.healthCheckId());
        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter(stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");

            xmlWriter.startElement("UpdateHealthCheckRequest");

            if (updateHealthCheckRequest.healthCheckVersion() != null) {
                xmlWriter.startElement("HealthCheckVersion").value(updateHealthCheckRequest.healthCheckVersion()).endElement();
            }

            if (updateHealthCheckRequest.ipAddress() != null) {
                xmlWriter.startElement("IPAddress").value(updateHealthCheckRequest.ipAddress()).endElement();
            }

            if (updateHealthCheckRequest.port() != null) {
                xmlWriter.startElement("Port").value(updateHealthCheckRequest.port()).endElement();
            }

            if (updateHealthCheckRequest.resourcePath() != null) {
                xmlWriter.startElement("ResourcePath").value(updateHealthCheckRequest.resourcePath()).endElement();
            }

            if (updateHealthCheckRequest.fullyQualifiedDomainName() != null) {
                xmlWriter.startElement("FullyQualifiedDomainName").value(updateHealthCheckRequest.fullyQualifiedDomainName())
                        .endElement();
            }

            if (updateHealthCheckRequest.searchString() != null) {
                xmlWriter.startElement("SearchString").value(updateHealthCheckRequest.searchString()).endElement();
            }

            if (updateHealthCheckRequest.failureThreshold() != null) {
                xmlWriter.startElement("FailureThreshold").value(updateHealthCheckRequest.failureThreshold()).endElement();
            }

            if (updateHealthCheckRequest.inverted() != null) {
                xmlWriter.startElement("Inverted").value(updateHealthCheckRequest.inverted()).endElement();
            }

            if (updateHealthCheckRequest.healthThreshold() != null) {
                xmlWriter.startElement("HealthThreshold").value(updateHealthCheckRequest.healthThreshold()).endElement();
            }

            java.util.List<String> updateHealthCheckRequestChildHealthChecksList = updateHealthCheckRequest.childHealthChecks();
            if (!updateHealthCheckRequestChildHealthChecksList.isEmpty()
                    || !(updateHealthCheckRequestChildHealthChecksList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                xmlWriter.startElement("ChildHealthChecks");

                for (String updateHealthCheckRequestChildHealthChecksListValue : updateHealthCheckRequestChildHealthChecksList) {
                    xmlWriter.startElement("ChildHealthCheck");
                    xmlWriter.value(updateHealthCheckRequestChildHealthChecksListValue);
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            if (updateHealthCheckRequest.enableSNI() != null) {
                xmlWriter.startElement("EnableSNI").value(updateHealthCheckRequest.enableSNI()).endElement();
            }

            java.util.List<String> updateHealthCheckRequestRegionsList = updateHealthCheckRequest.regionsAsStrings();
            if (!updateHealthCheckRequestRegionsList.isEmpty()
                    || !(updateHealthCheckRequestRegionsList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                xmlWriter.startElement("Regions");

                for (String updateHealthCheckRequestRegionsListValue : updateHealthCheckRequestRegionsList) {
                    xmlWriter.startElement("Region");
                    xmlWriter.value(updateHealthCheckRequestRegionsListValue);
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            AlarmIdentifier alarmIdentifier = updateHealthCheckRequest.alarmIdentifier();
            if (alarmIdentifier != null) {
                xmlWriter.startElement("AlarmIdentifier");

                if (alarmIdentifier.regionAsString() != null) {
                    xmlWriter.startElement("Region").value(alarmIdentifier.regionAsString()).endElement();
                }

                if (alarmIdentifier.name() != null) {
                    xmlWriter.startElement("Name").value(alarmIdentifier.name()).endElement();
                }
                xmlWriter.endElement();
            }

            if (updateHealthCheckRequest.insufficientDataHealthStatusAsString() != null) {
                xmlWriter.startElement("InsufficientDataHealthStatus")
                        .value(updateHealthCheckRequest.insufficientDataHealthStatusAsString()).endElement();
            }

            java.util.List<String> updateHealthCheckRequestResetElementsList = updateHealthCheckRequest.resetElementsAsStrings();
            if (!updateHealthCheckRequestResetElementsList.isEmpty()
                    || !(updateHealthCheckRequestResetElementsList instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                xmlWriter.startElement("ResetElements");

                for (String updateHealthCheckRequestResetElementsListValue : updateHealthCheckRequestResetElementsList) {
                    xmlWriter.startElement("ResettableElementName");
                    xmlWriter.value(updateHealthCheckRequestResetElementsListValue);
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();

            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF_8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }

        return request;
    }

}