/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the request to create a hosted zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccountLimitRequest extends Route53Request implements
        ToCopyableBuilder<GetAccountLimitRequest.Builder, GetAccountLimitRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(GetAccountLimitRequest::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Type").unmarshallLocationName("Type")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD));

    private final String type;

    private GetAccountLimitRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
    }

    /**
     * <p>
     * The limit that you want to get. Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>MAX_HEALTH_CHECKS_BY_OWNER</b>: The maximum number of health checks that you can create using the current
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MAX_HOSTED_ZONES_BY_OWNER</b>: The maximum number of hosted zones that you can create using the current
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MAX_REUSABLE_DELEGATION_SETS_BY_OWNER</b>: The maximum number of reusable delegation sets that you can create
     * using the current account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MAX_TRAFFIC_POLICIES_BY_OWNER</b>: The maximum number of traffic policies that you can create using the
     * current account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER</b>: The maximum number of traffic policy instances that you can create
     * using the current account. (Traffic policy instances are referred to as traffic flow policy records in the Amazon
     * Route 53 console.)
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AccountLimitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The limit that you want to get. Valid values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>MAX_HEALTH_CHECKS_BY_OWNER</b>: The maximum number of health checks that you can create using the
     *         current account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MAX_HOSTED_ZONES_BY_OWNER</b>: The maximum number of hosted zones that you can create using the
     *         current account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MAX_REUSABLE_DELEGATION_SETS_BY_OWNER</b>: The maximum number of reusable delegation sets that you can
     *         create using the current account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MAX_TRAFFIC_POLICIES_BY_OWNER</b>: The maximum number of traffic policies that you can create using
     *         the current account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER</b>: The maximum number of traffic policy instances that you can
     *         create using the current account. (Traffic policy instances are referred to as traffic flow policy
     *         records in the Amazon Route 53 console.)
     *         </p>
     *         </li>
     * @see AccountLimitType
     */
    public AccountLimitType type() {
        return AccountLimitType.fromValue(type);
    }

    /**
     * <p>
     * The limit that you want to get. Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>MAX_HEALTH_CHECKS_BY_OWNER</b>: The maximum number of health checks that you can create using the current
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MAX_HOSTED_ZONES_BY_OWNER</b>: The maximum number of hosted zones that you can create using the current
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MAX_REUSABLE_DELEGATION_SETS_BY_OWNER</b>: The maximum number of reusable delegation sets that you can create
     * using the current account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MAX_TRAFFIC_POLICIES_BY_OWNER</b>: The maximum number of traffic policies that you can create using the
     * current account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER</b>: The maximum number of traffic policy instances that you can create
     * using the current account. (Traffic policy instances are referred to as traffic flow policy records in the Amazon
     * Route 53 console.)
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AccountLimitType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The limit that you want to get. Valid values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>MAX_HEALTH_CHECKS_BY_OWNER</b>: The maximum number of health checks that you can create using the
     *         current account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MAX_HOSTED_ZONES_BY_OWNER</b>: The maximum number of hosted zones that you can create using the
     *         current account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MAX_REUSABLE_DELEGATION_SETS_BY_OWNER</b>: The maximum number of reusable delegation sets that you can
     *         create using the current account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MAX_TRAFFIC_POLICIES_BY_OWNER</b>: The maximum number of traffic policies that you can create using
     *         the current account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER</b>: The maximum number of traffic policy instances that you can
     *         create using the current account. (Traffic policy instances are referred to as traffic flow policy
     *         records in the Amazon Route 53 console.)
     *         </p>
     *         </li>
     * @see AccountLimitType
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountLimitRequest)) {
            return false;
        }
        GetAccountLimitRequest other = (GetAccountLimitRequest) obj;
        return Objects.equals(typeAsString(), other.typeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("GetAccountLimitRequest").add("Type", typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccountLimitRequest, T> g) {
        return obj -> g.apply((GetAccountLimitRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Request.Builder, SdkPojo, CopyableBuilder<Builder, GetAccountLimitRequest> {
        /**
         * <p>
         * The limit that you want to get. Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>MAX_HEALTH_CHECKS_BY_OWNER</b>: The maximum number of health checks that you can create using the current
         * account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MAX_HOSTED_ZONES_BY_OWNER</b>: The maximum number of hosted zones that you can create using the current
         * account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MAX_REUSABLE_DELEGATION_SETS_BY_OWNER</b>: The maximum number of reusable delegation sets that you can
         * create using the current account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MAX_TRAFFIC_POLICIES_BY_OWNER</b>: The maximum number of traffic policies that you can create using the
         * current account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER</b>: The maximum number of traffic policy instances that you can
         * create using the current account. (Traffic policy instances are referred to as traffic flow policy records in
         * the Amazon Route 53 console.)
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The limit that you want to get. Valid values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>MAX_HEALTH_CHECKS_BY_OWNER</b>: The maximum number of health checks that you can create using the
         *        current account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MAX_HOSTED_ZONES_BY_OWNER</b>: The maximum number of hosted zones that you can create using the
         *        current account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MAX_REUSABLE_DELEGATION_SETS_BY_OWNER</b>: The maximum number of reusable delegation sets that you
         *        can create using the current account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MAX_TRAFFIC_POLICIES_BY_OWNER</b>: The maximum number of traffic policies that you can create using
         *        the current account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER</b>: The maximum number of traffic policy instances that you
         *        can create using the current account. (Traffic policy instances are referred to as traffic flow policy
         *        records in the Amazon Route 53 console.)
         *        </p>
         *        </li>
         * @see AccountLimitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountLimitType
         */
        Builder type(String type);

        /**
         * <p>
         * The limit that you want to get. Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>MAX_HEALTH_CHECKS_BY_OWNER</b>: The maximum number of health checks that you can create using the current
         * account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MAX_HOSTED_ZONES_BY_OWNER</b>: The maximum number of hosted zones that you can create using the current
         * account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MAX_REUSABLE_DELEGATION_SETS_BY_OWNER</b>: The maximum number of reusable delegation sets that you can
         * create using the current account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MAX_TRAFFIC_POLICIES_BY_OWNER</b>: The maximum number of traffic policies that you can create using the
         * current account.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER</b>: The maximum number of traffic policy instances that you can
         * create using the current account. (Traffic policy instances are referred to as traffic flow policy records in
         * the Amazon Route 53 console.)
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The limit that you want to get. Valid values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>MAX_HEALTH_CHECKS_BY_OWNER</b>: The maximum number of health checks that you can create using the
         *        current account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MAX_HOSTED_ZONES_BY_OWNER</b>: The maximum number of hosted zones that you can create using the
         *        current account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MAX_REUSABLE_DELEGATION_SETS_BY_OWNER</b>: The maximum number of reusable delegation sets that you
         *        can create using the current account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MAX_TRAFFIC_POLICIES_BY_OWNER</b>: The maximum number of traffic policies that you can create using
         *        the current account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER</b>: The maximum number of traffic policy instances that you
         *        can create using the current account. (Traffic policy instances are referred to as traffic flow policy
         *        records in the Amazon Route 53 console.)
         *        </p>
         *        </li>
         * @see AccountLimitType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountLimitType
         */
        Builder type(AccountLimitType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53Request.BuilderImpl implements Builder {
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountLimitRequest model) {
            super(model);
            type(model.type);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AccountLimitType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAccountLimitRequest build() {
            return new GetAccountLimitRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
