/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the requested limit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetHostedZoneLimitResponse extends Route53Response implements
        ToCopyableBuilder<GetHostedZoneLimitResponse.Builder, GetHostedZoneLimitResponse> {
    private static final SdkField<HostedZoneLimit> LIMIT_FIELD = SdkField
            .<HostedZoneLimit> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetHostedZoneLimitResponse::limit))
            .setter(setter(Builder::limit))
            .constructor(HostedZoneLimit::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit")
                    .unmarshallLocationName("Limit").build()).build();

    private static final SdkField<Long> COUNT_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(GetHostedZoneLimitResponse::count))
            .setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count")
                    .unmarshallLocationName("Count").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD, COUNT_FIELD));

    private final HostedZoneLimit limit;

    private final Long count;

    private GetHostedZoneLimitResponse(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.count = builder.count;
    }

    /**
     * <p>
     * The current setting for the specified limit. For example, if you specified <code>MAX_RRSETS_BY_ZONE</code> for
     * the value of <code>Type</code> in the request, the value of <code>Limit</code> is the maximum number of records
     * that you can create in the specified hosted zone.
     * </p>
     * 
     * @return The current setting for the specified limit. For example, if you specified
     *         <code>MAX_RRSETS_BY_ZONE</code> for the value of <code>Type</code> in the request, the value of
     *         <code>Limit</code> is the maximum number of records that you can create in the specified hosted zone.
     */
    public HostedZoneLimit limit() {
        return limit;
    }

    /**
     * <p>
     * The current number of entities that you have created of the specified type. For example, if you specified
     * <code>MAX_RRSETS_BY_ZONE</code> for the value of <code>Type</code> in the request, the value of
     * <code>Count</code> is the current number of records that you have created in the specified hosted zone.
     * </p>
     * 
     * @return The current number of entities that you have created of the specified type. For example, if you specified
     *         <code>MAX_RRSETS_BY_ZONE</code> for the value of <code>Type</code> in the request, the value of
     *         <code>Count</code> is the current number of records that you have created in the specified hosted zone.
     */
    public Long count() {
        return count;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostedZoneLimitResponse)) {
            return false;
        }
        GetHostedZoneLimitResponse other = (GetHostedZoneLimitResponse) obj;
        return Objects.equals(limit(), other.limit()) && Objects.equals(count(), other.count());
    }

    @Override
    public String toString() {
        return ToString.builder("GetHostedZoneLimitResponse").add("Limit", limit()).add("Count", count()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetHostedZoneLimitResponse, T> g) {
        return obj -> g.apply((GetHostedZoneLimitResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo, CopyableBuilder<Builder, GetHostedZoneLimitResponse> {
        /**
         * <p>
         * The current setting for the specified limit. For example, if you specified <code>MAX_RRSETS_BY_ZONE</code>
         * for the value of <code>Type</code> in the request, the value of <code>Limit</code> is the maximum number of
         * records that you can create in the specified hosted zone.
         * </p>
         * 
         * @param limit
         *        The current setting for the specified limit. For example, if you specified
         *        <code>MAX_RRSETS_BY_ZONE</code> for the value of <code>Type</code> in the request, the value of
         *        <code>Limit</code> is the maximum number of records that you can create in the specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(HostedZoneLimit limit);

        /**
         * <p>
         * The current setting for the specified limit. For example, if you specified <code>MAX_RRSETS_BY_ZONE</code>
         * for the value of <code>Type</code> in the request, the value of <code>Limit</code> is the maximum number of
         * records that you can create in the specified hosted zone.
         * </p>
         * This is a convenience that creates an instance of the {@link HostedZoneLimit.Builder} avoiding the need to
         * create one manually via {@link HostedZoneLimit#builder()}.
         *
         * When the {@link Consumer} completes, {@link HostedZoneLimit.Builder#build()} is called immediately and its
         * result is passed to {@link #limit(HostedZoneLimit)}.
         * 
         * @param limit
         *        a consumer that will call methods on {@link HostedZoneLimit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #limit(HostedZoneLimit)
         */
        default Builder limit(Consumer<HostedZoneLimit.Builder> limit) {
            return limit(HostedZoneLimit.builder().applyMutation(limit).build());
        }

        /**
         * <p>
         * The current number of entities that you have created of the specified type. For example, if you specified
         * <code>MAX_RRSETS_BY_ZONE</code> for the value of <code>Type</code> in the request, the value of
         * <code>Count</code> is the current number of records that you have created in the specified hosted zone.
         * </p>
         * 
         * @param count
         *        The current number of entities that you have created of the specified type. For example, if you
         *        specified <code>MAX_RRSETS_BY_ZONE</code> for the value of <code>Type</code> in the request, the value
         *        of <code>Count</code> is the current number of records that you have created in the specified hosted
         *        zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Long count);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private HostedZoneLimit limit;

        private Long count;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostedZoneLimitResponse model) {
            super(model);
            limit(model.limit);
            count(model.count);
        }

        public final HostedZoneLimit.Builder getLimit() {
            return limit != null ? limit.toBuilder() : null;
        }

        @Override
        public final Builder limit(HostedZoneLimit limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(HostedZoneLimit.BuilderImpl limit) {
            this.limit = limit != null ? limit.build() : null;
        }

        public final Long getCount() {
            return count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public GetHostedZoneLimitResponse build() {
            return new GetHostedZoneLimitResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
