/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Generated;
import org.w3c.dom.Node;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AsyncClientHandler;
import software.amazon.awssdk.client.AwsAsyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkAsyncClientHandler;
import software.amazon.awssdk.http.DefaultErrorResponseHandler;
import software.amazon.awssdk.http.StaxResponseHandler;
import software.amazon.awssdk.runtime.transform.StandardErrorUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.AssociateVPCWithHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.AssociateVPCWithHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ChangeTagsForResourceRequest;
import software.amazon.awssdk.services.route53.model.ChangeTagsForResourceResponse;
import software.amazon.awssdk.services.route53.model.CreateHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.CreateHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.CreateHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.CreateHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionResponse;
import software.amazon.awssdk.services.route53.model.CreateVPCAssociationAuthorizationRequest;
import software.amazon.awssdk.services.route53.model.CreateVPCAssociationAuthorizationResponse;
import software.amazon.awssdk.services.route53.model.DeleteHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.DeleteHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.DeleteHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.DeleteHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.DeleteVPCAssociationAuthorizationRequest;
import software.amazon.awssdk.services.route53.model.DeleteVPCAssociationAuthorizationResponse;
import software.amazon.awssdk.services.route53.model.DisassociateVPCFromHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.DisassociateVPCFromHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.GetChangeRequest;
import software.amazon.awssdk.services.route53.model.GetChangeResponse;
import software.amazon.awssdk.services.route53.model.GetCheckerIpRangesRequest;
import software.amazon.awssdk.services.route53.model.GetCheckerIpRangesResponse;
import software.amazon.awssdk.services.route53.model.GetGeoLocationRequest;
import software.amazon.awssdk.services.route53.model.GetGeoLocationResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckCountRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckCountResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckStatusRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckStatusResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneCountRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneCountResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.ListGeoLocationsRequest;
import software.amazon.awssdk.services.route53.model.ListGeoLocationsResponse;
import software.amazon.awssdk.services.route53.model.ListHealthChecksRequest;
import software.amazon.awssdk.services.route53.model.ListHealthChecksResponse;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByNameResponse;
import software.amazon.awssdk.services.route53.model.ListHostedZonesRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesResponse;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsRequest;
import software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsResponse;
import software.amazon.awssdk.services.route53.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.route53.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.route53.model.ListTagsForResourcesRequest;
import software.amazon.awssdk.services.route53.model.ListTagsForResourcesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPoliciesRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPoliciesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsResponse;
import software.amazon.awssdk.services.route53.model.ListVPCAssociationAuthorizationsRequest;
import software.amazon.awssdk.services.route53.model.ListVPCAssociationAuthorizationsResponse;
import software.amazon.awssdk.services.route53.model.Route53Exception;
import software.amazon.awssdk.services.route53.model.TestDNSAnswerRequest;
import software.amazon.awssdk.services.route53.model.TestDNSAnswerResponse;
import software.amazon.awssdk.services.route53.model.UpdateHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.UpdateHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentRequest;
import software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentResponse;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentRequest;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentResponse;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.transform.AssociateVPCWithHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.AssociateVPCWithHostedZoneResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ChangeResourceRecordSetsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ChangeResourceRecordSetsResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ChangeTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ChangeTagsForResourceResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ConcurrentModificationExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ConflictingDomainExistsExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ConflictingTypesExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.CreateHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateHealthCheckResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.CreateHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateHostedZoneResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.CreateReusableDelegationSetRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateReusableDelegationSetResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyVersionResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.CreateVPCAssociationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateVPCAssociationAuthorizationResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.DelegationSetAlreadyCreatedExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.DelegationSetAlreadyReusableExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.DelegationSetInUseExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.DelegationSetNotAvailableExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.DelegationSetNotReusableExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteHealthCheckResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteHostedZoneResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteReusableDelegationSetRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteReusableDelegationSetResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteTrafficPolicyInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteTrafficPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteTrafficPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteVPCAssociationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteVPCAssociationAuthorizationResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.DisassociateVPCFromHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DisassociateVPCFromHostedZoneResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.GetChangeRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetChangeResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.GetCheckerIpRangesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetCheckerIpRangesResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.GetGeoLocationRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetGeoLocationResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckCountRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckCountResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckLastFailureReasonRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckLastFailureReasonResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckStatusRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckStatusResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.GetHostedZoneCountRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHostedZoneCountResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.GetHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHostedZoneResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.GetReusableDelegationSetRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetReusableDelegationSetResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyInstanceCountRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyInstanceCountResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.HealthCheckAlreadyExistsExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.HealthCheckInUseExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.HealthCheckVersionMismatchExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.HostedZoneAlreadyExistsExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.HostedZoneNotEmptyExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.HostedZoneNotFoundExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.IncompatibleVersionExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.InvalidArgumentExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.InvalidChangeBatchExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.InvalidDomainNameExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.InvalidInputExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.InvalidPaginationTokenExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.InvalidTrafficPolicyDocumentExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.InvalidVPCIdExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.LastVPCAssociationExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.LimitsExceededExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ListGeoLocationsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListGeoLocationsResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ListHealthChecksRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHealthChecksResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ListHostedZonesByNameRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHostedZonesByNameResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ListHostedZonesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHostedZonesResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ListResourceRecordSetsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListResourceRecordSetsResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ListReusableDelegationSetsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListReusableDelegationSetsResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTagsForResourceResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ListTagsForResourcesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTagsForResourcesResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPoliciesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPoliciesResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesByHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesByHostedZoneResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesByPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesByPolicyResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyVersionsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyVersionsResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ListVPCAssociationAuthorizationsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListVPCAssociationAuthorizationsResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.NoSuchChangeExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.NoSuchDelegationSetExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.NoSuchGeoLocationExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.NoSuchHealthCheckExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.NoSuchHostedZoneExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.NoSuchTrafficPolicyExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.NoSuchTrafficPolicyInstanceExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.NotAuthorizedExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.PriorRequestNotCompleteExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.PublicZoneVPCAssociationExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.TestDNSAnswerRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.TestDNSAnswerResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.ThrottlingExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.TooManyHealthChecksExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.TooManyHostedZonesExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.TooManyTrafficPoliciesExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.TooManyTrafficPolicyInstancesExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.TooManyVPCAssociationAuthorizationsExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.TrafficPolicyAlreadyExistsExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.TrafficPolicyInUseExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.TrafficPolicyInstanceAlreadyExistsExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateHealthCheckResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateHostedZoneCommentRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateHostedZoneCommentResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateTrafficPolicyCommentRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateTrafficPolicyCommentResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateTrafficPolicyInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.route53.transform.VPCAssociationAuthorizationNotFoundExceptionUnmarshaller;
import software.amazon.awssdk.services.route53.transform.VPCAssociationNotFoundExceptionUnmarshaller;

/**
 * Internal implementation of {@link Route53AsyncClient}.
 *
 * @see Route53AsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultRoute53AsyncClient implements Route53AsyncClient {
    private final AsyncClientHandler clientHandler;

    private final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers;

    protected DefaultRoute53AsyncClient(AwsAsyncClientParams clientParams) {
        this.clientHandler = new SdkAsyncClientHandler(new ClientHandlerParams().withAsyncClientParams(clientParams)
                .withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.exceptionUnmarshallers = init();
    }

    /**
     * <p>
     * Associates an Amazon VPC with a private hosted zone.
     * </p>
     * <important>
     * <p>
     * To perform the association, the VPC and the private hosted zone must already exist. You can't convert a public
     * hosted zone into a private hosted zone.
     * </p>
     * </important> <note>
     * <p>
     * If you want to associate a VPC that was created by using one AWS account with a private hosted zone that was
     * created by using a different account, the AWS account that created the private hosted zone must first submit a
     * <code>CreateVPCAssociationAuthorization</code> request. Then the account that created the VPC must submit an
     * <code>AssociateVPCWithHostedZone</code> request.
     * </p>
     * </note>
     * 
     * @param associateVPCWithHostedZoneRequest
     *        A complex type that contains information about the request to associate a VPC with a private hosted zone.
     * @return A Java Future containing the result of the AssociateVPCWithHostedZone operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>NotAuthorizedException Associating the specified VPC with the specified hosted zone has not been
     *         authorized.</li>
     *         <li>InvalidVPCIdException The VPC ID that you specified either isn't a valid ID or the current account is
     *         not authorized to access this VPC.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>PublicZoneVPCAssociationException You're trying to associate a VPC with a public hosted zone. Amazon
     *         Route 53 doesn't support associating a VPC with a public hosted zone.</li>
     *         <li>ConflictingDomainExistsException The cause of this error depends on whether you're trying to create a
     *         public or a private hosted zone:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Public hosted zone:</b> Two hosted zones that have the same name or that have a parent/child
     *         relationship (example.com and test.example.com) can't have any common name servers. You tried to create a
     *         hosted zone that has the same name as an existing hosted zone or that's the parent or child of an
     *         existing hosted zone, and you specified a delegation set that shares one or more name servers with the
     *         existing hosted zone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Private hosted zone:</b> You specified an Amazon VPC that you're already using for another hosted
     *         zone, and the domain that you specified for one of the hosted zones is a subdomain of the domain that you
     *         specified for the other hosted zone. For example, you can't use the same Amazon VPC for the hosted zones
     *         for example.com and test.example.com.
     *         </p>
     *         </li></li>
     *         <li>LimitsExceededException The limits specified for a resource have been exceeded.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.AssociateVPCWithHostedZone
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/AssociateVPCWithHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateVPCWithHostedZoneResponse> associateVPCWithHostedZone(
            AssociateVPCWithHostedZoneRequest associateVPCWithHostedZoneRequest) {

        StaxResponseHandler<AssociateVPCWithHostedZoneResponse> responseHandler = new StaxResponseHandler<AssociateVPCWithHostedZoneResponse>(
                new AssociateVPCWithHostedZoneResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<AssociateVPCWithHostedZoneRequest, AssociateVPCWithHostedZoneResponse>()
                        .withMarshaller(new AssociateVPCWithHostedZoneRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(associateVPCWithHostedZoneRequest));
    }

    /**
     * <p>
     * Creates, changes, or deletes a resource record set, which contains authoritative DNS information for a specified
     * domain name or subdomain name. For example, you can use <code>ChangeResourceRecordSets</code> to create a
     * resource record set that routes traffic for test.example.com to a web server that has an IP address of
     * 192.0.2.44.
     * </p>
     * <p>
     * <b>Change Batches and Transactional Changes</b>
     * </p>
     * <p>
     * The request body must include a document with a <code>ChangeResourceRecordSetsRequest</code> element. The request
     * body contains a list of change items, known as a change batch. Change batches are considered transactional
     * changes. When using the Amazon Route 53 API to change resource record sets, Amazon Route 53 either makes all or
     * none of the changes in a change batch request. This ensures that Amazon Route 53 never partially implements the
     * intended changes to the resource record sets in a hosted zone.
     * </p>
     * <p>
     * For example, a change batch request that deletes the <code>CNAME</code> record for www.example.com and creates an
     * alias resource record set for www.example.com. Amazon Route 53 deletes the first resource record set and creates
     * the second resource record set in a single operation. If either the <code>DELETE</code> or the
     * <code>CREATE</code> action fails, then both changes (plus any other changes in the batch) fail, and the original
     * <code>CNAME</code> record continues to exist.
     * </p>
     * <important>
     * <p>
     * Due to the nature of transactional changes, you can't delete the same resource record set more than once in a
     * single change batch. If you attempt to delete the same change batch more than once, Amazon Route 53 returns an
     * <code>InvalidChangeBatch</code> error.
     * </p>
     * </important>
     * <p>
     * <b>Traffic Flow</b>
     * </p>
     * <p>
     * To create resource record sets for complex routing configurations, use either the traffic flow visual editor in
     * the Amazon Route 53 console or the API actions for traffic policies and traffic policy instances. Save the
     * configuration as a traffic policy, then associate the traffic policy with one or more domain names (such as
     * example.com) or subdomain names (such as www.example.com), in the same hosted zone or in multiple hosted zones.
     * You can roll back the updates if the new configuration isn't performing as expected. For more information, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/traffic-flow.html">Using Traffic Flow to Route DNS
     * Traffic</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * <b>Create, Delete, and Upsert</b>
     * </p>
     * <p>
     * Use <code>ChangeResourceRecordsSetsRequest</code> to perform the following actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE</code>: Creates a resource record set that has the specified values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE</code>: Deletes an existing resource record set that has the specified values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPSERT</code>: If a resource record set does not already exist, AWS creates it. If a resource set does
     * exist, Amazon Route 53 updates it with the values in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Syntaxes for Creating, Updating, and Deleting Resource Record Sets</b>
     * </p>
     * <p>
     * The syntax for a request depends on the type of resource record set that you want to create, delete, or update,
     * such as weighted, alias, or failover. The XML elements in your request must appear in the order listed in the
     * syntax.
     * </p>
     * <p>
     * For an example for each type of resource record set, see "Examples."
     * </p>
     * <p>
     * Don't refer to the syntax in the "Parameter Syntax" section, which includes all of the elements for every kind of
     * resource record set that you can create, delete, or update by using <code>ChangeResourceRecordSets</code>.
     * </p>
     * <p>
     * <b>Change Propagation to Amazon Route 53 DNS Servers</b>
     * </p>
     * <p>
     * When you submit a <code>ChangeResourceRecordSets</code> request, Amazon Route 53 propagates your changes to all
     * of the Amazon Route 53 authoritative DNS servers. While your changes are propagating, <code>GetChange</code>
     * returns a status of <code>PENDING</code>. When propagation is complete, <code>GetChange</code> returns a status
     * of <code>INSYNC</code>. Changes generally propagate to all Amazon Route 53 name servers within 60 seconds. For
     * more information, see <a>GetChange</a>.
     * </p>
     * <p>
     * <b>Limits on ChangeResourceRecordSets Requests</b>
     * </p>
     * <p>
     * For information about the limits on a <code>ChangeResourceRecordSets</code> request, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html">Limits</a> in the <i>Amazon
     * Route 53 Developer Guide</i>.
     * </p>
     * 
     * @param changeResourceRecordSetsRequest
     *        A complex type that contains change information for the resource record set.
     * @return A Java Future containing the result of the ChangeResourceRecordSets operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>NoSuchHealthCheckException No health check exists with the ID that you specified in the
     *         <code>DeleteHealthCheck</code> request.</li>
     *         <li>InvalidChangeBatchException This exception contains a list of messages that might contain one or more
     *         error messages. Each error message indicates one error in the change batch.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Amazon Route 53 returns this error repeatedly
     *         for the same request, we recommend that you wait, in intervals of increasing duration, before you try the
     *         request again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ChangeResourceRecordSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ChangeResourceRecordSets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ChangeResourceRecordSetsResponse> changeResourceRecordSets(
            ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest) {

        StaxResponseHandler<ChangeResourceRecordSetsResponse> responseHandler = new StaxResponseHandler<ChangeResourceRecordSetsResponse>(
                new ChangeResourceRecordSetsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<ChangeResourceRecordSetsRequest, ChangeResourceRecordSetsResponse>()
                        .withMarshaller(new ChangeResourceRecordSetsRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(changeResourceRecordSetsRequest));
    }

    /**
     * <p>
     * Adds, edits, or deletes tags for a health check or a hosted zone.
     * </p>
     * <p>
     * For information about using tags for cost allocation, see <a
     * href="http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
     * Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     * </p>
     * 
     * @param changeTagsForResourceRequest
     *        A complex type that contains information about the tags that you want to add, edit, or delete.
     * @return A Java Future containing the result of the ChangeTagsForResource operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchHealthCheckException No health check exists with the ID that you specified in the
     *         <code>DeleteHealthCheck</code> request.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Amazon Route 53 returns this error repeatedly
     *         for the same request, we recommend that you wait, in intervals of increasing duration, before you try the
     *         request again.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ChangeTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ChangeTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ChangeTagsForResourceResponse> changeTagsForResource(
            ChangeTagsForResourceRequest changeTagsForResourceRequest) {

        StaxResponseHandler<ChangeTagsForResourceResponse> responseHandler = new StaxResponseHandler<ChangeTagsForResourceResponse>(
                new ChangeTagsForResourceResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ChangeTagsForResourceRequest, ChangeTagsForResourceResponse>()
                .withMarshaller(new ChangeTagsForResourceRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(changeTagsForResourceRequest));
    }

    /**
     * <p>
     * Creates a new health check.
     * </p>
     * <p>
     * For information about adding health checks to resource record sets, see
     * <a>ResourceRecordSet&#36;HealthCheckId</a> in <a>ChangeResourceRecordSets</a>.
     * </p>
     * <p>
     * <b>ELB Load Balancers</b>
     * </p>
     * <p>
     * If you're registering EC2 instances with an Elastic Load Balancing (ELB) load balancer, do not create Amazon
     * Route 53 health checks for the EC2 instances. When you register an EC2 instance with a load balancer, you
     * configure settings for an ELB health check, which performs a similar function to an Amazon Route 53 health check.
     * </p>
     * <p>
     * <b>Private Hosted Zones</b>
     * </p>
     * <p>
     * You can associate health checks with failover resource record sets in a private hosted zone. Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon Route 53 health checkers are outside the VPC. To check the health of an endpoint within a VPC by IP
     * address, you must assign a public IP address to the instance in the VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can configure a health checker to check the health of an external resource that the instance relies on, such
     * as a database server.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can create a CloudWatch metric, associate an alarm with the metric, and then create a health check that is
     * based on the state of the alarm. For example, you might create a CloudWatch metric that checks the status of the
     * Amazon EC2 <code>StatusCheckFailed</code> metric, add an alarm to the metric, and then create a health check that
     * is based on the state of the alarm. For information about creating CloudWatch metrics and alarms by using the
     * CloudWatch console, see the <a
     * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/WhatIsCloudWatch.html">Amazon CloudWatch
     * User Guide</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param createHealthCheckRequest
     *        A complex type that contains the health check request information.
     * @return A Java Future containing the result of the CreateHealthCheck operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyHealthChecksException You have reached the maximum number of active health checks for an AWS
     *         account. The default limit is 100. To request a higher limit, <a
     *         href="http://aws.amazon.com/route53-request">create a case</a> with the AWS Support Center.</li>
     *         <li>HealthCheckAlreadyExistsException The health check you're attempting to create already exists. Amazon
     *         Route 53 returns this error when you submit a request that has the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The same value for <code>CallerReference</code> as an existing health check, and one or more values that
     *         differ from the existing health check that has the same caller reference.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The same value for <code>CallerReference</code> as a health check that you created and later deleted,
     *         regardless of the other settings in the request.
     *         </p>
     *         </li></li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.CreateHealthCheck
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateHealthCheck" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateHealthCheckResponse> createHealthCheck(CreateHealthCheckRequest createHealthCheckRequest) {

        StaxResponseHandler<CreateHealthCheckResponse> responseHandler = new StaxResponseHandler<CreateHealthCheckResponse>(
                new CreateHealthCheckResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateHealthCheckRequest, CreateHealthCheckResponse>()
                .withMarshaller(new CreateHealthCheckRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createHealthCheckRequest));
    }

    /**
     * <p>
     * Creates a new public hosted zone, which you use to specify how the Domain Name System (DNS) routes traffic on the
     * Internet for a domain, such as example.com, and its subdomains.
     * </p>
     * <important>
     * <p>
     * You can't convert a public hosted zones to a private hosted zone or vice versa. Instead, you must create a new
     * hosted zone with the same name and create new resource record sets.
     * </p>
     * </important>
     * <p>
     * For more information about charges for hosted zones, see <a href="http://aws.amazon.com/route53/pricing/">Amazon
     * Route 53 Pricing</a>.
     * </p>
     * <p>
     * Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can't create a hosted zone for a top-level domain (TLD).
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Route 53 automatically creates a default SOA record and four NS records for the zone. For more information
     * about SOA and NS records, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/SOA-NSrecords.html">NS and SOA Records that Amazon
     * Route 53 Creates for a Hosted Zone</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * If you want to use the same name servers for multiple hosted zones, you can optionally associate a reusable
     * delegation set with the hosted zone. See the <code>DelegationSetId</code> element.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your domain is registered with a registrar other than Amazon Route 53, you must update the name servers with
     * your registrar to make Amazon Route 53 your DNS service. For more information, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/creating-migrating.html">Configuring Amazon Route
     * 53 as your DNS Service</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you submit a <code>CreateHostedZone</code> request, the initial status of the hosted zone is
     * <code>PENDING</code>. This means that the NS and SOA records are not yet available on all Amazon Route 53 DNS
     * servers. When the NS and SOA records are available, the status of the zone changes to <code>INSYNC</code>.
     * </p>
     * 
     * @param createHostedZoneRequest
     *        A complex type that contains information about the request to create a hosted zone.
     * @return A Java Future containing the result of the CreateHostedZone operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidDomainNameException The specified domain name is not valid.</li>
     *         <li>HostedZoneAlreadyExistsException The hosted zone you're trying to create already exists. Amazon Route
     *         53 returns this error when a hosted zone has already been created with the specified
     *         <code>CallerReference</code>.</li>
     *         <li>TooManyHostedZonesException This hosted zone can't be created because the hosted zone limit is
     *         exceeded. To request a limit increase, go to the Amazon Route 53 <a
     *         href="http://aws.amazon.com/route53-request/">Contact Us</a> page.</li>
     *         <li>InvalidVPCIdException The VPC ID that you specified either isn't a valid ID or the current account is
     *         not authorized to access this VPC.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>DelegationSetNotAvailableException You can create a hosted zone that has the same name as an existing
     *         hosted zone (example.com is common), but there is a limit to the number of hosted zones that have the
     *         same name. If you get this error, Amazon Route 53 has reached that limit. If you own the domain name and
     *         Amazon Route 53 generates this error, contact Customer Support.</li>
     *         <li>ConflictingDomainExistsException The cause of this error depends on whether you're trying to create a
     *         public or a private hosted zone:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Public hosted zone:</b> Two hosted zones that have the same name or that have a parent/child
     *         relationship (example.com and test.example.com) can't have any common name servers. You tried to create a
     *         hosted zone that has the same name as an existing hosted zone or that's the parent or child of an
     *         existing hosted zone, and you specified a delegation set that shares one or more name servers with the
     *         existing hosted zone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Private hosted zone:</b> You specified an Amazon VPC that you're already using for another hosted
     *         zone, and the domain that you specified for one of the hosted zones is a subdomain of the domain that you
     *         specified for the other hosted zone. For example, you can't use the same Amazon VPC for the hosted zones
     *         for example.com and test.example.com.
     *         </p>
     *         </li></li>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.CreateHostedZone
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateHostedZone" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateHostedZoneResponse> createHostedZone(CreateHostedZoneRequest createHostedZoneRequest) {

        StaxResponseHandler<CreateHostedZoneResponse> responseHandler = new StaxResponseHandler<CreateHostedZoneResponse>(
                new CreateHostedZoneResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateHostedZoneRequest, CreateHostedZoneResponse>()
                .withMarshaller(new CreateHostedZoneRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createHostedZoneRequest));
    }

    /**
     * <p>
     * Creates a delegation set (a group of four name servers) that can be reused by multiple hosted zones. If a hosted
     * zoned ID is specified, <code>CreateReusableDelegationSet</code> marks the delegation set associated with that
     * zone as reusable
     * </p>
     * <note>
     * <p>
     * A reusable delegation set can't be associated with a private hosted zone.
     * </p>
     * </note>
     * <p>
     * For information on how to use a reusable delegation set to configure white label name servers, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/white-label-name-servers.html">Configuring White
     * Label Name Servers</a>.
     * </p>
     * 
     * @param createReusableDelegationSetRequest
     * @return A Java Future containing the result of the CreateReusableDelegationSet operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DelegationSetAlreadyCreatedException A delegation set with the same owner and caller reference
     *         combination has already been created.</li>
     *         <li>LimitsExceededException The limits specified for a resource have been exceeded.</li>
     *         <li>HostedZoneNotFoundException The specified HostedZone can't be found.</li>
     *         <li>InvalidArgumentException Parameter name is invalid.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>DelegationSetNotAvailableException You can create a hosted zone that has the same name as an existing
     *         hosted zone (example.com is common), but there is a limit to the number of hosted zones that have the
     *         same name. If you get this error, Amazon Route 53 has reached that limit. If you own the domain name and
     *         Amazon Route 53 generates this error, contact Customer Support.</li>
     *         <li>DelegationSetAlreadyReusableException The specified delegation set has already been marked as
     *         reusable.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.CreateReusableDelegationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateReusableDelegationSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateReusableDelegationSetResponse> createReusableDelegationSet(
            CreateReusableDelegationSetRequest createReusableDelegationSetRequest) {

        StaxResponseHandler<CreateReusableDelegationSetResponse> responseHandler = new StaxResponseHandler<CreateReusableDelegationSetResponse>(
                new CreateReusableDelegationSetResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<CreateReusableDelegationSetRequest, CreateReusableDelegationSetResponse>()
                        .withMarshaller(new CreateReusableDelegationSetRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(createReusableDelegationSetRequest));
    }

    /**
     * <p>
     * Creates a traffic policy, which you use to create multiple DNS resource record sets for one domain name (such as
     * example.com) or one subdomain name (such as www.example.com).
     * </p>
     * 
     * @param createTrafficPolicyRequest
     *        A complex type that contains information about the traffic policy that you want to create.
     * @return A Java Future containing the result of the CreateTrafficPolicy operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>TooManyTrafficPoliciesException You've created the maximum number of traffic policies that can be
     *         created for the current AWS account. You can request an increase to the limit on the <a
     *         href="http://aws.amazon.com/route53-request/">Contact Us</a> page.</li>
     *         <li>TrafficPolicyAlreadyExistsException A traffic policy that has the same value for <code>Name</code>
     *         already exists.</li>
     *         <li>InvalidTrafficPolicyDocumentException The format of the traffic policy document that you specified in
     *         the <code>Document</code> element is invalid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.CreateTrafficPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrafficPolicyResponse> createTrafficPolicy(
            CreateTrafficPolicyRequest createTrafficPolicyRequest) {

        StaxResponseHandler<CreateTrafficPolicyResponse> responseHandler = new StaxResponseHandler<CreateTrafficPolicyResponse>(
                new CreateTrafficPolicyResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<CreateTrafficPolicyRequest, CreateTrafficPolicyResponse>()
                .withMarshaller(new CreateTrafficPolicyRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createTrafficPolicyRequest));
    }

    /**
     * <p>
     * Creates resource record sets in a specified hosted zone based on the settings in a specified traffic policy
     * version. In addition, <code>CreateTrafficPolicyInstance</code> associates the resource record sets with a
     * specified domain name (such as example.com) or subdomain name (such as www.example.com). Amazon Route 53 responds
     * to DNS queries for the domain or subdomain name by using the resource record sets that
     * <code>CreateTrafficPolicyInstance</code> created.
     * </p>
     * 
     * @param createTrafficPolicyInstanceRequest
     *        A complex type that contains information about the resource record sets that you want to create based on a
     *        specified traffic policy.
     * @return A Java Future containing the result of the CreateTrafficPolicyInstance operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>TooManyTrafficPolicyInstancesException You've created the maximum number of traffic policy instances
     *         that can be created for the current AWS account. You can request an increase to the limit on the <a
     *         href="http://aws.amazon.com/route53-request/">Contact Us</a> page.</li>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>TrafficPolicyInstanceAlreadyExistsException Traffic policy instance with given Id already exists.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.CreateTrafficPolicyInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicyInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrafficPolicyInstanceResponse> createTrafficPolicyInstance(
            CreateTrafficPolicyInstanceRequest createTrafficPolicyInstanceRequest) {

        StaxResponseHandler<CreateTrafficPolicyInstanceResponse> responseHandler = new StaxResponseHandler<CreateTrafficPolicyInstanceResponse>(
                new CreateTrafficPolicyInstanceResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<CreateTrafficPolicyInstanceRequest, CreateTrafficPolicyInstanceResponse>()
                        .withMarshaller(new CreateTrafficPolicyInstanceRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(createTrafficPolicyInstanceRequest));
    }

    /**
     * <p>
     * Creates a new version of an existing traffic policy. When you create a new version of a traffic policy, you
     * specify the ID of the traffic policy that you want to update and a JSON-formatted document that describes the new
     * version. You use traffic policies to create multiple DNS resource record sets for one domain name (such as
     * example.com) or one subdomain name (such as www.example.com). You can create a maximum of 1000 versions of a
     * traffic policy. If you reach the limit and need to create another version, you'll need to start a new traffic
     * policy.
     * </p>
     * 
     * @param createTrafficPolicyVersionRequest
     *        A complex type that contains information about the traffic policy that you want to create a new version
     *        for.
     * @return A Java Future containing the result of the CreateTrafficPolicyVersion operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to update the object at the same
     *         time that you did. Retry the request.</li>
     *         <li>InvalidTrafficPolicyDocumentException The format of the traffic policy document that you specified in
     *         the <code>Document</code> element is invalid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.CreateTrafficPolicyVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateTrafficPolicyVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrafficPolicyVersionResponse> createTrafficPolicyVersion(
            CreateTrafficPolicyVersionRequest createTrafficPolicyVersionRequest) {

        StaxResponseHandler<CreateTrafficPolicyVersionResponse> responseHandler = new StaxResponseHandler<CreateTrafficPolicyVersionResponse>(
                new CreateTrafficPolicyVersionResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<CreateTrafficPolicyVersionRequest, CreateTrafficPolicyVersionResponse>()
                        .withMarshaller(new CreateTrafficPolicyVersionRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(createTrafficPolicyVersionRequest));
    }

    /**
     * <p>
     * Authorizes the AWS account that created a specified VPC to submit an <code>AssociateVPCWithHostedZone</code>
     * request to associate the VPC with a specified hosted zone that was created by a different account. To submit a
     * <code>CreateVPCAssociationAuthorization</code> request, you must use the account that created the hosted zone.
     * After you authorize the association, use the account that created the VPC to submit an
     * <code>AssociateVPCWithHostedZone</code> request.
     * </p>
     * <note>
     * <p>
     * If you want to associate multiple VPCs that you created by using one account with a hosted zone that you created
     * by using a different account, you must submit one authorization request for each VPC.
     * </p>
     * </note>
     * 
     * @param createVPCAssociationAuthorizationRequest
     *        A complex type that contains information about the request to authorize associating a VPC with your
     *        private hosted zone. Authorization is only required when a private hosted zone and a VPC were created by
     *        using different accounts.
     * @return A Java Future containing the result of the CreateVPCAssociationAuthorization operation returned by the
     *         service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another user submitted a request to update the object at the same
     *         time that you did. Retry the request.</li>
     *         <li>TooManyVPCAssociationAuthorizationsException You've created the maximum number of authorizations that
     *         can be created for the specified hosted zone. To authorize another VPC to be associated with the hosted
     *         zone, submit a <code>DeleteVPCAssociationAuthorization</code> request to remove an existing
     *         authorization. To get a list of existing authorizations, submit a
     *         <code>ListVPCAssociationAuthorizations</code> request.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidVPCIdException The VPC ID that you specified either isn't a valid ID or the current account is
     *         not authorized to access this VPC.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.CreateVPCAssociationAuthorization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CreateVPCAssociationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVPCAssociationAuthorizationResponse> createVPCAssociationAuthorization(
            CreateVPCAssociationAuthorizationRequest createVPCAssociationAuthorizationRequest) {

        StaxResponseHandler<CreateVPCAssociationAuthorizationResponse> responseHandler = new StaxResponseHandler<CreateVPCAssociationAuthorizationResponse>(
                new CreateVPCAssociationAuthorizationResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<CreateVPCAssociationAuthorizationRequest, CreateVPCAssociationAuthorizationResponse>()
                        .withMarshaller(new CreateVPCAssociationAuthorizationRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(createVPCAssociationAuthorizationRequest));
    }

    /**
     * <p>
     * Deletes a health check.
     * </p>
     * <important>
     * <p>
     * Amazon Route 53 does not prevent you from deleting a health check even if the health check is associated with one
     * or more resource record sets. If you delete a health check and you don't update the associated resource record
     * sets, the future status of the health check can't be predicted and may change. This will affect the routing of
     * DNS queries for your DNS failover configuration. For more information, see <a href=
     * "http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html#health-checks-deleting.html"
     * >Replacing and Deleting Health Checks</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * </important>
     * 
     * @param deleteHealthCheckRequest
     *        This action deletes a health check.
     * @return A Java Future containing the result of the DeleteHealthCheck operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHealthCheckException No health check exists with the ID that you specified in the
     *         <code>DeleteHealthCheck</code> request.</li>
     *         <li>HealthCheckInUseException This error code is not in use.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.DeleteHealthCheck
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteHealthCheck" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteHealthCheckResponse> deleteHealthCheck(DeleteHealthCheckRequest deleteHealthCheckRequest) {

        StaxResponseHandler<DeleteHealthCheckResponse> responseHandler = new StaxResponseHandler<DeleteHealthCheckResponse>(
                new DeleteHealthCheckResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteHealthCheckRequest, DeleteHealthCheckResponse>()
                .withMarshaller(new DeleteHealthCheckRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteHealthCheckRequest));
    }

    /**
     * <p>
     * Deletes a hosted zone.
     * </p>
     * <important>
     * <p>
     * If the name servers for the hosted zone are associated with a domain and if you want to make the domain
     * unavailable on the Internet, we recommend that you delete the name servers from the domain to prevent future DNS
     * queries from possibly being misrouted. If the domain is registered with Amazon Route 53, see
     * <code>UpdateDomainNameservers</code>. If the domain is registered with another registrar, use the method provided
     * by the registrar to delete name servers for the domain.
     * </p>
     * <p>
     * Some domain registries don't allow you to remove all of the name servers for a domain. If the registry for your
     * domain requires one or more name servers, we recommend that you delete the hosted zone only if you transfer DNS
     * service to another service provider, and you replace the name servers for the domain with name servers from the
     * new provider.
     * </p>
     * </important>
     * <p>
     * You can delete a hosted zone only if it contains only the default SOA record and NS resource record sets. If the
     * hosted zone contains other resource record sets, you must delete them before you can delete the hosted zone. If
     * you try to delete a hosted zone that contains other resource record sets, the request fails, and Amazon Route 53
     * returns a <code>HostedZoneNotEmpty</code> error. For information about deleting records from your hosted zone,
     * see <a>ChangeResourceRecordSets</a>.
     * </p>
     * <p>
     * To verify that the hosted zone has been deleted, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use the <code>GetHostedZone</code> action to request information about the hosted zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the <code>ListHostedZones</code> action to get a list of the hosted zones associated with the current AWS
     * account.
     * </p>
     * </li>
     * </ul>
     * 
     * @param deleteHostedZoneRequest
     *        A request to delete a hosted zone.
     * @return A Java Future containing the result of the DeleteHostedZone operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>HostedZoneNotEmptyException The hosted zone contains resource records that are not SOA or NS records.
     *         </li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Amazon Route 53 returns this error repeatedly
     *         for the same request, we recommend that you wait, in intervals of increasing duration, before you try the
     *         request again.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidDomainNameException The specified domain name is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.DeleteHostedZone
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteHostedZone" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteHostedZoneResponse> deleteHostedZone(DeleteHostedZoneRequest deleteHostedZoneRequest) {

        StaxResponseHandler<DeleteHostedZoneResponse> responseHandler = new StaxResponseHandler<DeleteHostedZoneResponse>(
                new DeleteHostedZoneResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteHostedZoneRequest, DeleteHostedZoneResponse>()
                .withMarshaller(new DeleteHostedZoneRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteHostedZoneRequest));
    }

    /**
     * <p>
     * Deletes a reusable delegation set.
     * </p>
     * <important>
     * <p>
     * You can delete a reusable delegation set only if it isn't associated with any hosted zones.
     * </p>
     * </important>
     * <p>
     * To verify that the reusable delegation set is not associated with any hosted zones, submit a
     * <a>GetReusableDelegationSet</a> request and specify the ID of the reusable delegation set that you want to
     * delete.
     * </p>
     * 
     * @param deleteReusableDelegationSetRequest
     *        A request to delete a reusable delegation set.
     * @return A Java Future containing the result of the DeleteReusableDelegationSet operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetInUseException The specified delegation contains associated hosted zones which must be
     *         deleted before the reusable delegation set can be deleted.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.DeleteReusableDelegationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteReusableDelegationSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteReusableDelegationSetResponse> deleteReusableDelegationSet(
            DeleteReusableDelegationSetRequest deleteReusableDelegationSetRequest) {

        StaxResponseHandler<DeleteReusableDelegationSetResponse> responseHandler = new StaxResponseHandler<DeleteReusableDelegationSetResponse>(
                new DeleteReusableDelegationSetResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteReusableDelegationSetRequest, DeleteReusableDelegationSetResponse>()
                        .withMarshaller(new DeleteReusableDelegationSetRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteReusableDelegationSetRequest));
    }

    /**
     * <p>
     * Deletes a traffic policy.
     * </p>
     * 
     * @param deleteTrafficPolicyRequest
     *        A request to delete a specified traffic policy version.
     * @return A Java Future containing the result of the DeleteTrafficPolicy operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>TrafficPolicyInUseException One or more traffic policy instances were created by using the specified
     *         traffic policy.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to update the object at the same
     *         time that you did. Retry the request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.DeleteTrafficPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteTrafficPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrafficPolicyResponse> deleteTrafficPolicy(
            DeleteTrafficPolicyRequest deleteTrafficPolicyRequest) {

        StaxResponseHandler<DeleteTrafficPolicyResponse> responseHandler = new StaxResponseHandler<DeleteTrafficPolicyResponse>(
                new DeleteTrafficPolicyResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<DeleteTrafficPolicyRequest, DeleteTrafficPolicyResponse>()
                .withMarshaller(new DeleteTrafficPolicyRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteTrafficPolicyRequest));
    }

    /**
     * <p>
     * Deletes a traffic policy instance and all of the resource record sets that Amazon Route 53 created when you
     * created the instance.
     * </p>
     * <note>
     * <p>
     * In the Amazon Route 53 console, traffic policy instances are known as policy records.
     * </p>
     * </note>
     * 
     * @param deleteTrafficPolicyInstanceRequest
     *        A request to delete a specified traffic policy instance.
     * @return A Java Future containing the result of the DeleteTrafficPolicyInstance operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Amazon Route 53 returns this error repeatedly
     *         for the same request, we recommend that you wait, in intervals of increasing duration, before you try the
     *         request again.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.DeleteTrafficPolicyInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteTrafficPolicyInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrafficPolicyInstanceResponse> deleteTrafficPolicyInstance(
            DeleteTrafficPolicyInstanceRequest deleteTrafficPolicyInstanceRequest) {

        StaxResponseHandler<DeleteTrafficPolicyInstanceResponse> responseHandler = new StaxResponseHandler<DeleteTrafficPolicyInstanceResponse>(
                new DeleteTrafficPolicyInstanceResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteTrafficPolicyInstanceRequest, DeleteTrafficPolicyInstanceResponse>()
                        .withMarshaller(new DeleteTrafficPolicyInstanceRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteTrafficPolicyInstanceRequest));
    }

    /**
     * <p>
     * Removes authorization to submit an <code>AssociateVPCWithHostedZone</code> request to associate a specified VPC
     * with a hosted zone that was created by a different account. You must use the account that created the hosted zone
     * to submit a <code>DeleteVPCAssociationAuthorization</code> request.
     * </p>
     * <important>
     * <p>
     * Sending this request only prevents the AWS account that created the VPC from associating the VPC with the Amazon
     * Route 53 hosted zone in the future. If the VPC is already associated with the hosted zone,
     * <code>DeleteVPCAssociationAuthorization</code> won't disassociate the VPC from the hosted zone. If you want to
     * delete an existing association, use <code>DisassociateVPCFromHostedZone</code>.
     * </p>
     * </important>
     * 
     * @param deleteVPCAssociationAuthorizationRequest
     *        A complex type that contains information about the request to remove authorization to associate a VPC that
     *        was created by one AWS account with a hosted zone that was created with a different AWS account.
     * @return A Java Future containing the result of the DeleteVPCAssociationAuthorization operation returned by the
     *         service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another user submitted a request to update the object at the same
     *         time that you did. Retry the request.</li>
     *         <li>VPCAssociationAuthorizationNotFoundException The VPC that you specified is not authorized to be
     *         associated with the hosted zone.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidVPCIdException The VPC ID that you specified either isn't a valid ID or the current account is
     *         not authorized to access this VPC.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.DeleteVPCAssociationAuthorization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteVPCAssociationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVPCAssociationAuthorizationResponse> deleteVPCAssociationAuthorization(
            DeleteVPCAssociationAuthorizationRequest deleteVPCAssociationAuthorizationRequest) {

        StaxResponseHandler<DeleteVPCAssociationAuthorizationResponse> responseHandler = new StaxResponseHandler<DeleteVPCAssociationAuthorizationResponse>(
                new DeleteVPCAssociationAuthorizationResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteVPCAssociationAuthorizationRequest, DeleteVPCAssociationAuthorizationResponse>()
                        .withMarshaller(new DeleteVPCAssociationAuthorizationRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deleteVPCAssociationAuthorizationRequest));
    }

    /**
     * <p>
     * Disassociates a VPC from a Amazon Route 53 private hosted zone.
     * </p>
     * <note>
     * <p>
     * You can't disassociate the last VPC from a private hosted zone.
     * </p>
     * </note> <important>
     * <p>
     * You can't disassociate a VPC from a private hosted zone when only one VPC is associated with the hosted zone. You
     * also can't convert a private hosted zone into a public hosted zone.
     * </p>
     * </important>
     * 
     * @param disassociateVPCFromHostedZoneRequest
     *        A complex type that contains information about the VPC that you want to disassociate from a specified
     *        private hosted zone.
     * @return A Java Future containing the result of the DisassociateVPCFromHostedZone operation returned by the
     *         service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidVPCIdException The VPC ID that you specified either isn't a valid ID or the current account is
     *         not authorized to access this VPC.</li>
     *         <li>VPCAssociationNotFoundException The specified VPC and hosted zone are not currently associated.</li>
     *         <li>LastVPCAssociationException The VPC that you're trying to disassociate from the private hosted zone
     *         is the last VPC that is associated with the hosted zone. Amazon Route 53 doesn't support disassociating
     *         the last VPC from a hosted zone.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.DisassociateVPCFromHostedZone
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DisassociateVPCFromHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateVPCFromHostedZoneResponse> disassociateVPCFromHostedZone(
            DisassociateVPCFromHostedZoneRequest disassociateVPCFromHostedZoneRequest) {

        StaxResponseHandler<DisassociateVPCFromHostedZoneResponse> responseHandler = new StaxResponseHandler<DisassociateVPCFromHostedZoneResponse>(
                new DisassociateVPCFromHostedZoneResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<DisassociateVPCFromHostedZoneRequest, DisassociateVPCFromHostedZoneResponse>()
                        .withMarshaller(new DisassociateVPCFromHostedZoneRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(disassociateVPCFromHostedZoneRequest));
    }

    /**
     * <p>
     * Returns the current status of a change batch request. The status is one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> indicates that the changes in this request have not propagated to all Amazon Route 53 DNS
     * servers. This is the initial status of all change batch requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INSYNC</code> indicates that the changes have propagated to all Amazon Route 53 DNS servers.
     * </p>
     * </li>
     * </ul>
     * 
     * @param getChangeRequest
     *        The input for a GetChange request.
     * @return A Java Future containing the result of the GetChange operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchChangeException A change with the specified change ID does not exist.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.GetChange
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetChange" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetChangeResponse> getChange(GetChangeRequest getChangeRequest) {

        StaxResponseHandler<GetChangeResponse> responseHandler = new StaxResponseHandler<GetChangeResponse>(
                new GetChangeResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<GetChangeRequest, GetChangeResponse>()
                .withMarshaller(new GetChangeRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getChangeRequest));
    }

    /**
     * <p>
     * <code>GetCheckerIpRanges</code> still works, but we recommend that you download ip-ranges.json, which includes IP
     * address ranges for all AWS services. For more information, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-ip-addresses.html">IP Address Ranges of
     * Amazon Route 53 Servers</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * 
     * @param getCheckerIpRangesRequest
     * @return A Java Future containing the result of the GetCheckerIpRanges operation returned by the service.
     * @sample Route53AsyncClient.GetCheckerIpRanges
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetCheckerIpRanges" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetCheckerIpRangesResponse> getCheckerIpRanges() {
        return getCheckerIpRanges(GetCheckerIpRangesRequest.builder().build());
    }

    /**
     * <p>
     * <code>GetCheckerIpRanges</code> still works, but we recommend that you download ip-ranges.json, which includes IP
     * address ranges for all AWS services. For more information, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-ip-addresses.html">IP Address Ranges of
     * Amazon Route 53 Servers</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * 
     * @param getCheckerIpRangesRequest
     * @return A Java Future containing the result of the GetCheckerIpRanges operation returned by the service.
     * @sample Route53AsyncClient.GetCheckerIpRanges
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetCheckerIpRanges" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetCheckerIpRangesResponse> getCheckerIpRanges(GetCheckerIpRangesRequest getCheckerIpRangesRequest) {

        StaxResponseHandler<GetCheckerIpRangesResponse> responseHandler = new StaxResponseHandler<GetCheckerIpRangesResponse>(
                new GetCheckerIpRangesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<GetCheckerIpRangesRequest, GetCheckerIpRangesResponse>()
                .withMarshaller(new GetCheckerIpRangesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getCheckerIpRangesRequest));
    }

    /**
     * <p>
     * Gets information about whether a specified geographic location is supported for Amazon Route 53 geolocation
     * resource record sets.
     * </p>
     * <p>
     * Use the following syntax to determine whether a continent is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?ContinentCode=<i>two-letter abbreviation for a continent</i> </code>
     * </p>
     * <p>
     * Use the following syntax to determine whether a country is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?CountryCode=<i>two-character country code</i> </code>
     * </p>
     * <p>
     * Use the following syntax to determine whether a subdivision of a country is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?CountryCode=<i>two-character country code</i>&amp;SubdivisionCode=<i>subdivision code</i> </code>
     * </p>
     * 
     * @param getGeoLocationRequest
     *        A request for information about whether a specified geographic location is supported for Amazon Route 53
     *        geolocation resource record sets.
     * @return A Java Future containing the result of the GetGeoLocation operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchGeoLocationException Amazon Route 53 doesn't support the specified geolocation.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.GetGeoLocation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetGeoLocation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetGeoLocationResponse> getGeoLocation() {
        return getGeoLocation(GetGeoLocationRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about whether a specified geographic location is supported for Amazon Route 53 geolocation
     * resource record sets.
     * </p>
     * <p>
     * Use the following syntax to determine whether a continent is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?ContinentCode=<i>two-letter abbreviation for a continent</i> </code>
     * </p>
     * <p>
     * Use the following syntax to determine whether a country is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?CountryCode=<i>two-character country code</i> </code>
     * </p>
     * <p>
     * Use the following syntax to determine whether a subdivision of a country is supported for geolocation:
     * </p>
     * <p>
     * <code>GET /2013-04-01/geolocation?CountryCode=<i>two-character country code</i>&amp;SubdivisionCode=<i>subdivision code</i> </code>
     * </p>
     * 
     * @param getGeoLocationRequest
     *        A request for information about whether a specified geographic location is supported for Amazon Route 53
     *        geolocation resource record sets.
     * @return A Java Future containing the result of the GetGeoLocation operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchGeoLocationException Amazon Route 53 doesn't support the specified geolocation.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.GetGeoLocation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetGeoLocation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetGeoLocationResponse> getGeoLocation(GetGeoLocationRequest getGeoLocationRequest) {

        StaxResponseHandler<GetGeoLocationResponse> responseHandler = new StaxResponseHandler<GetGeoLocationResponse>(
                new GetGeoLocationResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<GetGeoLocationRequest, GetGeoLocationResponse>()
                .withMarshaller(new GetGeoLocationRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getGeoLocationRequest));
    }

    /**
     * <p>
     * Gets information about a specified health check.
     * </p>
     * 
     * @param getHealthCheckRequest
     *        A request to get information about a specified health check.
     * @return A Java Future containing the result of the GetHealthCheck operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHealthCheckException No health check exists with the ID that you specified in the
     *         <code>DeleteHealthCheck</code> request.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>IncompatibleVersionException The resource you're trying to access is unsupported on this Amazon Route
     *         53 endpoint.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.GetHealthCheck
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheck" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetHealthCheckResponse> getHealthCheck(GetHealthCheckRequest getHealthCheckRequest) {

        StaxResponseHandler<GetHealthCheckResponse> responseHandler = new StaxResponseHandler<GetHealthCheckResponse>(
                new GetHealthCheckResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<GetHealthCheckRequest, GetHealthCheckResponse>()
                .withMarshaller(new GetHealthCheckRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getHealthCheckRequest));
    }

    /**
     * <p>
     * Retrieves the number of health checks that are associated with the current AWS account.
     * </p>
     * 
     * @param getHealthCheckCountRequest
     *        A request for the number of health checks that are associated with the current AWS account.
     * @return A Java Future containing the result of the GetHealthCheckCount operation returned by the service.
     * @sample Route53AsyncClient.GetHealthCheckCount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckCount" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetHealthCheckCountResponse> getHealthCheckCount() {
        return getHealthCheckCount(GetHealthCheckCountRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the number of health checks that are associated with the current AWS account.
     * </p>
     * 
     * @param getHealthCheckCountRequest
     *        A request for the number of health checks that are associated with the current AWS account.
     * @return A Java Future containing the result of the GetHealthCheckCount operation returned by the service.
     * @sample Route53AsyncClient.GetHealthCheckCount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckCount" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetHealthCheckCountResponse> getHealthCheckCount(
            GetHealthCheckCountRequest getHealthCheckCountRequest) {

        StaxResponseHandler<GetHealthCheckCountResponse> responseHandler = new StaxResponseHandler<GetHealthCheckCountResponse>(
                new GetHealthCheckCountResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<GetHealthCheckCountRequest, GetHealthCheckCountResponse>()
                .withMarshaller(new GetHealthCheckCountRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getHealthCheckCountRequest));
    }

    /**
     * <p>
     * Gets the reason that a specified health check failed most recently.
     * </p>
     * 
     * @param getHealthCheckLastFailureReasonRequest
     *        A request for the reason that a health check failed most recently.
     * @return A Java Future containing the result of the GetHealthCheckLastFailureReason operation returned by the
     *         service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHealthCheckException No health check exists with the ID that you specified in the
     *         <code>DeleteHealthCheck</code> request.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.GetHealthCheckLastFailureReason
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckLastFailureReason"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetHealthCheckLastFailureReasonResponse> getHealthCheckLastFailureReason(
            GetHealthCheckLastFailureReasonRequest getHealthCheckLastFailureReasonRequest) {

        StaxResponseHandler<GetHealthCheckLastFailureReasonResponse> responseHandler = new StaxResponseHandler<GetHealthCheckLastFailureReasonResponse>(
                new GetHealthCheckLastFailureReasonResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<GetHealthCheckLastFailureReasonRequest, GetHealthCheckLastFailureReasonResponse>()
                        .withMarshaller(new GetHealthCheckLastFailureReasonRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getHealthCheckLastFailureReasonRequest));
    }

    /**
     * <p>
     * Gets status of a specified health check.
     * </p>
     * 
     * @param getHealthCheckStatusRequest
     *        A request to get the status for a health check.
     * @return A Java Future containing the result of the GetHealthCheckStatus operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHealthCheckException No health check exists with the ID that you specified in the
     *         <code>DeleteHealthCheck</code> request.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.GetHealthCheckStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHealthCheckStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetHealthCheckStatusResponse> getHealthCheckStatus(
            GetHealthCheckStatusRequest getHealthCheckStatusRequest) {

        StaxResponseHandler<GetHealthCheckStatusResponse> responseHandler = new StaxResponseHandler<GetHealthCheckStatusResponse>(
                new GetHealthCheckStatusResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<GetHealthCheckStatusRequest, GetHealthCheckStatusResponse>()
                .withMarshaller(new GetHealthCheckStatusRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getHealthCheckStatusRequest));
    }

    /**
     * <p>
     * Gets information about a specified hosted zone including the four name servers assigned to the hosted zone.
     * </p>
     * 
     * @param getHostedZoneRequest
     *        A request to get information about a specified hosted zone.
     * @return A Java Future containing the result of the GetHostedZone operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.GetHostedZone
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZone" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetHostedZoneResponse> getHostedZone(GetHostedZoneRequest getHostedZoneRequest) {

        StaxResponseHandler<GetHostedZoneResponse> responseHandler = new StaxResponseHandler<GetHostedZoneResponse>(
                new GetHostedZoneResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<GetHostedZoneRequest, GetHostedZoneResponse>()
                .withMarshaller(new GetHostedZoneRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getHostedZoneRequest));
    }

    /**
     * <p>
     * Retrieves the number of hosted zones that are associated with the current AWS account.
     * </p>
     * 
     * @param getHostedZoneCountRequest
     *        A request to retrieve a count of all the hosted zones that are associated with the current AWS account.
     * @return A Java Future containing the result of the GetHostedZoneCount operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.GetHostedZoneCount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZoneCount" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetHostedZoneCountResponse> getHostedZoneCount() {
        return getHostedZoneCount(GetHostedZoneCountRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the number of hosted zones that are associated with the current AWS account.
     * </p>
     * 
     * @param getHostedZoneCountRequest
     *        A request to retrieve a count of all the hosted zones that are associated with the current AWS account.
     * @return A Java Future containing the result of the GetHostedZoneCount operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.GetHostedZoneCount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetHostedZoneCount" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetHostedZoneCountResponse> getHostedZoneCount(GetHostedZoneCountRequest getHostedZoneCountRequest) {

        StaxResponseHandler<GetHostedZoneCountResponse> responseHandler = new StaxResponseHandler<GetHostedZoneCountResponse>(
                new GetHostedZoneCountResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<GetHostedZoneCountRequest, GetHostedZoneCountResponse>()
                .withMarshaller(new GetHostedZoneCountRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getHostedZoneCountRequest));
    }

    /**
     * <p>
     * Retrieves information about a specified reusable delegation set, including the four name servers that are
     * assigned to the delegation set.
     * </p>
     * 
     * @param getReusableDelegationSetRequest
     *        A request to get information about a specified reusable delegation set.
     * @return A Java Future containing the result of the GetReusableDelegationSet operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.GetReusableDelegationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetReusableDelegationSet"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetReusableDelegationSetResponse> getReusableDelegationSet(
            GetReusableDelegationSetRequest getReusableDelegationSetRequest) {

        StaxResponseHandler<GetReusableDelegationSetResponse> responseHandler = new StaxResponseHandler<GetReusableDelegationSetResponse>(
                new GetReusableDelegationSetResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<GetReusableDelegationSetRequest, GetReusableDelegationSetResponse>()
                        .withMarshaller(new GetReusableDelegationSetRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(getReusableDelegationSetRequest));
    }

    /**
     * <p>
     * Gets information about a specific traffic policy version.
     * </p>
     * 
     * @param getTrafficPolicyRequest
     *        Gets information about a specific traffic policy version.
     * @return A Java Future containing the result of the GetTrafficPolicy operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.GetTrafficPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetTrafficPolicyResponse> getTrafficPolicy(GetTrafficPolicyRequest getTrafficPolicyRequest) {

        StaxResponseHandler<GetTrafficPolicyResponse> responseHandler = new StaxResponseHandler<GetTrafficPolicyResponse>(
                new GetTrafficPolicyResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<GetTrafficPolicyRequest, GetTrafficPolicyResponse>()
                .withMarshaller(new GetTrafficPolicyRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getTrafficPolicyRequest));
    }

    /**
     * <p>
     * Gets information about a specified traffic policy instance.
     * </p>
     * <note>
     * <p>
     * After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code>
     * request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the
     * traffic policy definition. For more information, see the <code>State</code> response element.
     * </p>
     * </note> <note>
     * <p>
     * In the Amazon Route 53 console, traffic policy instances are known as policy records.
     * </p>
     * </note>
     * 
     * @param getTrafficPolicyInstanceRequest
     *        Gets information about a specified traffic policy instance.
     * @return A Java Future containing the result of the GetTrafficPolicyInstance operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.GetTrafficPolicyInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicyInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTrafficPolicyInstanceResponse> getTrafficPolicyInstance(
            GetTrafficPolicyInstanceRequest getTrafficPolicyInstanceRequest) {

        StaxResponseHandler<GetTrafficPolicyInstanceResponse> responseHandler = new StaxResponseHandler<GetTrafficPolicyInstanceResponse>(
                new GetTrafficPolicyInstanceResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<GetTrafficPolicyInstanceRequest, GetTrafficPolicyInstanceResponse>()
                        .withMarshaller(new GetTrafficPolicyInstanceRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(getTrafficPolicyInstanceRequest));
    }

    /**
     * <p>
     * Gets the number of traffic policy instances that are associated with the current AWS account.
     * </p>
     * 
     * @param getTrafficPolicyInstanceCountRequest
     *        Request to get the number of traffic policy instances that are associated with the current AWS account.
     * @return A Java Future containing the result of the GetTrafficPolicyInstanceCount operation returned by the
     *         service.
     * @sample Route53AsyncClient.GetTrafficPolicyInstanceCount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicyInstanceCount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTrafficPolicyInstanceCountResponse> getTrafficPolicyInstanceCount() {
        return getTrafficPolicyInstanceCount(GetTrafficPolicyInstanceCountRequest.builder().build());
    }

    /**
     * <p>
     * Gets the number of traffic policy instances that are associated with the current AWS account.
     * </p>
     * 
     * @param getTrafficPolicyInstanceCountRequest
     *        Request to get the number of traffic policy instances that are associated with the current AWS account.
     * @return A Java Future containing the result of the GetTrafficPolicyInstanceCount operation returned by the
     *         service.
     * @sample Route53AsyncClient.GetTrafficPolicyInstanceCount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GetTrafficPolicyInstanceCount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTrafficPolicyInstanceCountResponse> getTrafficPolicyInstanceCount(
            GetTrafficPolicyInstanceCountRequest getTrafficPolicyInstanceCountRequest) {

        StaxResponseHandler<GetTrafficPolicyInstanceCountResponse> responseHandler = new StaxResponseHandler<GetTrafficPolicyInstanceCountResponse>(
                new GetTrafficPolicyInstanceCountResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<GetTrafficPolicyInstanceCountRequest, GetTrafficPolicyInstanceCountResponse>()
                        .withMarshaller(new GetTrafficPolicyInstanceCountRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getTrafficPolicyInstanceCountRequest));
    }

    /**
     * <p>
     * Retrieves a list of supported geo locations.
     * </p>
     * <p>
     * Countries are listed first, and continents are listed last. If Amazon Route 53 supports subdivisions for a
     * country (for example, states or provinces), the subdivisions for that country are listed in alphabetical order
     * immediately after the corresponding country.
     * </p>
     * 
     * @param listGeoLocationsRequest
     *        A request to get a list of geographic locations that Amazon Route 53 supports for geolocation resource
     *        record sets.
     * @return A Java Future containing the result of the ListGeoLocations operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListGeoLocations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListGeoLocations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGeoLocationsResponse> listGeoLocations() {
        return listGeoLocations(ListGeoLocationsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list of supported geo locations.
     * </p>
     * <p>
     * Countries are listed first, and continents are listed last. If Amazon Route 53 supports subdivisions for a
     * country (for example, states or provinces), the subdivisions for that country are listed in alphabetical order
     * immediately after the corresponding country.
     * </p>
     * 
     * @param listGeoLocationsRequest
     *        A request to get a list of geographic locations that Amazon Route 53 supports for geolocation resource
     *        record sets.
     * @return A Java Future containing the result of the ListGeoLocations operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListGeoLocations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListGeoLocations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGeoLocationsResponse> listGeoLocations(ListGeoLocationsRequest listGeoLocationsRequest) {

        StaxResponseHandler<ListGeoLocationsResponse> responseHandler = new StaxResponseHandler<ListGeoLocationsResponse>(
                new ListGeoLocationsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ListGeoLocationsRequest, ListGeoLocationsResponse>()
                .withMarshaller(new ListGeoLocationsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listGeoLocationsRequest));
    }

    /**
     * <p>
     * Retrieve a list of the health checks that are associated with the current AWS account.
     * </p>
     * 
     * @param listHealthChecksRequest
     *        A request to retrieve a list of the health checks that are associated with the current AWS account.
     * @return A Java Future containing the result of the ListHealthChecks operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>IncompatibleVersionException The resource you're trying to access is unsupported on this Amazon Route
     *         53 endpoint.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListHealthChecks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHealthChecks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListHealthChecksResponse> listHealthChecks() {
        return listHealthChecks(ListHealthChecksRequest.builder().build());
    }

    /**
     * <p>
     * Retrieve a list of the health checks that are associated with the current AWS account.
     * </p>
     * 
     * @param listHealthChecksRequest
     *        A request to retrieve a list of the health checks that are associated with the current AWS account.
     * @return A Java Future containing the result of the ListHealthChecks operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>IncompatibleVersionException The resource you're trying to access is unsupported on this Amazon Route
     *         53 endpoint.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListHealthChecks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHealthChecks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListHealthChecksResponse> listHealthChecks(ListHealthChecksRequest listHealthChecksRequest) {

        StaxResponseHandler<ListHealthChecksResponse> responseHandler = new StaxResponseHandler<ListHealthChecksResponse>(
                new ListHealthChecksResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ListHealthChecksRequest, ListHealthChecksResponse>()
                .withMarshaller(new ListHealthChecksRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listHealthChecksRequest));
    }

    /**
     * <p>
     * Retrieves a list of the public and private hosted zones that are associated with the current AWS account. The
     * response includes a <code>HostedZones</code> child element for each hosted zone.
     * </p>
     * <p>
     * Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of hosted zones, you can use
     * the <code>maxitems</code> parameter to list them in groups of up to 100.
     * </p>
     * 
     * @param listHostedZonesRequest
     *        A request to retrieve a list of the public and private hosted zones that are associated with the current
     *        AWS account.
     * @return A Java Future containing the result of the ListHostedZones operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListHostedZones
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZones" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListHostedZonesResponse> listHostedZones() {
        return listHostedZones(ListHostedZonesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list of the public and private hosted zones that are associated with the current AWS account. The
     * response includes a <code>HostedZones</code> child element for each hosted zone.
     * </p>
     * <p>
     * Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of hosted zones, you can use
     * the <code>maxitems</code> parameter to list them in groups of up to 100.
     * </p>
     * 
     * @param listHostedZonesRequest
     *        A request to retrieve a list of the public and private hosted zones that are associated with the current
     *        AWS account.
     * @return A Java Future containing the result of the ListHostedZones operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchDelegationSetException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>DelegationSetNotReusableException A reusable delegation set with the specified ID does not exist.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListHostedZones
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZones" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListHostedZonesResponse> listHostedZones(ListHostedZonesRequest listHostedZonesRequest) {

        StaxResponseHandler<ListHostedZonesResponse> responseHandler = new StaxResponseHandler<ListHostedZonesResponse>(
                new ListHostedZonesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ListHostedZonesRequest, ListHostedZonesResponse>()
                .withMarshaller(new ListHostedZonesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listHostedZonesRequest));
    }

    /**
     * <p>
     * Retrieves a list of your hosted zones in lexicographic order. The response includes a <code>HostedZones</code>
     * child element for each hosted zone created by the current AWS account.
     * </p>
     * <p>
     * <code>ListHostedZonesByName</code> sorts hosted zones by name with the labels reversed. For example:
     * </p>
     * <p>
     * <code>com.example.www.</code>
     * </p>
     * <p>
     * Note the trailing dot, which can change the sort order in some circumstances.
     * </p>
     * <p>
     * If the domain name includes escape characters or Punycode, <code>ListHostedZonesByName</code> alphabetizes the
     * domain name using the escaped or Punycoded value, which is the format that Amazon Route 53 saves in its database.
     * For example, to create a hosted zone for exämple.com, you specify ex\344mple.com for the domain name.
     * <code>ListHostedZonesByName</code> alphabetizes it as:
     * </p>
     * <p>
     * <code>com.ex\344mple.</code>
     * </p>
     * <p>
     * The labels are reversed and alphabetized using the escaped value. For more information about valid domain name
     * formats, including internationalized domain names, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a>
     * in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * Amazon Route 53 returns up to 100 items in each response. If you have a lot of hosted zones, use the
     * <code>MaxItems</code> parameter to list them in groups of up to 100. The response includes values that help
     * navigate from one group of <code>MaxItems</code> hosted zones to the next:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>DNSName</code> and <code>HostedZoneId</code> elements in the response contain the values, if any,
     * specified for the <code>dnsname</code> and <code>hostedzoneid</code> parameters in the request that produced the
     * current response.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>MaxItems</code> element in the response contains the value, if any, that you specified for the
     * <code>maxitems</code> parameter in the request that produced the current response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the value of <code>IsTruncated</code> in the response is true, there are more hosted zones associated with the
     * current AWS account.
     * </p>
     * <p>
     * If <code>IsTruncated</code> is false, this response includes the last hosted zone that is associated with the
     * current account. The <code>NextDNSName</code> element and <code>NextHostedZoneId</code> elements are omitted from
     * the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>NextDNSName</code> and <code>NextHostedZoneId</code> elements in the response contain the domain name
     * and the hosted zone ID of the next hosted zone that is associated with the current AWS account. If you want to
     * list more hosted zones, make another call to <code>ListHostedZonesByName</code>, and specify the value of
     * <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and
     * <code>hostedzoneid</code> parameters, respectively.
     * </p>
     * </li>
     * </ul>
     * 
     * @param listHostedZonesByNameRequest
     *        Retrieves a list of the public and private hosted zones that are associated with the current AWS account
     *        in ASCII order by domain name.
     * @return A Java Future containing the result of the ListHostedZonesByName operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidDomainNameException The specified domain name is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListHostedZonesByName
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZonesByName" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListHostedZonesByNameResponse> listHostedZonesByName() {
        return listHostedZonesByName(ListHostedZonesByNameRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list of your hosted zones in lexicographic order. The response includes a <code>HostedZones</code>
     * child element for each hosted zone created by the current AWS account.
     * </p>
     * <p>
     * <code>ListHostedZonesByName</code> sorts hosted zones by name with the labels reversed. For example:
     * </p>
     * <p>
     * <code>com.example.www.</code>
     * </p>
     * <p>
     * Note the trailing dot, which can change the sort order in some circumstances.
     * </p>
     * <p>
     * If the domain name includes escape characters or Punycode, <code>ListHostedZonesByName</code> alphabetizes the
     * domain name using the escaped or Punycoded value, which is the format that Amazon Route 53 saves in its database.
     * For example, to create a hosted zone for exämple.com, you specify ex\344mple.com for the domain name.
     * <code>ListHostedZonesByName</code> alphabetizes it as:
     * </p>
     * <p>
     * <code>com.ex\344mple.</code>
     * </p>
     * <p>
     * The labels are reversed and alphabetized using the escaped value. For more information about valid domain name
     * formats, including internationalized domain names, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html">DNS Domain Name Format</a>
     * in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * Amazon Route 53 returns up to 100 items in each response. If you have a lot of hosted zones, use the
     * <code>MaxItems</code> parameter to list them in groups of up to 100. The response includes values that help
     * navigate from one group of <code>MaxItems</code> hosted zones to the next:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>DNSName</code> and <code>HostedZoneId</code> elements in the response contain the values, if any,
     * specified for the <code>dnsname</code> and <code>hostedzoneid</code> parameters in the request that produced the
     * current response.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>MaxItems</code> element in the response contains the value, if any, that you specified for the
     * <code>maxitems</code> parameter in the request that produced the current response.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the value of <code>IsTruncated</code> in the response is true, there are more hosted zones associated with the
     * current AWS account.
     * </p>
     * <p>
     * If <code>IsTruncated</code> is false, this response includes the last hosted zone that is associated with the
     * current account. The <code>NextDNSName</code> element and <code>NextHostedZoneId</code> elements are omitted from
     * the response.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>NextDNSName</code> and <code>NextHostedZoneId</code> elements in the response contain the domain name
     * and the hosted zone ID of the next hosted zone that is associated with the current AWS account. If you want to
     * list more hosted zones, make another call to <code>ListHostedZonesByName</code>, and specify the value of
     * <code>NextDNSName</code> and <code>NextHostedZoneId</code> in the <code>dnsname</code> and
     * <code>hostedzoneid</code> parameters, respectively.
     * </p>
     * </li>
     * </ul>
     * 
     * @param listHostedZonesByNameRequest
     *        Retrieves a list of the public and private hosted zones that are associated with the current AWS account
     *        in ASCII order by domain name.
     * @return A Java Future containing the result of the ListHostedZonesByName operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidDomainNameException The specified domain name is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListHostedZonesByName
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListHostedZonesByName" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListHostedZonesByNameResponse> listHostedZonesByName(
            ListHostedZonesByNameRequest listHostedZonesByNameRequest) {

        StaxResponseHandler<ListHostedZonesByNameResponse> responseHandler = new StaxResponseHandler<ListHostedZonesByNameResponse>(
                new ListHostedZonesByNameResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ListHostedZonesByNameRequest, ListHostedZonesByNameResponse>()
                .withMarshaller(new ListHostedZonesByNameRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listHostedZonesByNameRequest));
    }

    /**
     * <p>
     * Lists the resource record sets in a specified hosted zone.
     * </p>
     * <p>
     * <code>ListResourceRecordSets</code> returns up to 100 resource record sets at a time in ASCII order, beginning at
     * a position specified by the <code>name</code> and <code>type</code> elements. The action sorts results first by
     * DNS name with the labels reversed, for example:
     * </p>
     * <p>
     * <code>com.example.www.</code>
     * </p>
     * <p>
     * Note the trailing dot, which can change the sort order in some circumstances.
     * </p>
     * <p>
     * When multiple records have the same DNS name, the action sorts results by the record type.
     * </p>
     * <p>
     * You can use the name and type elements to adjust the beginning position of the list of resource record sets
     * returned:
     * </p>
     * <dl>
     * <dt>If you do not specify Name or Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set that the hosted zone contains.
     * </p>
     * </dd>
     * <dt>If you specify Name but not Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set in the list whose name is greater than or equal to
     * <code>Name</code>.
     * </p>
     * </dd>
     * <dt>If you specify Type but not Name</dt>
     * <dd>
     * <p>
     * Amazon Route 53 returns the <code>InvalidInput</code> error.
     * </p>
     * </dd>
     * <dt>If you specify both Name and Type</dt>
     * <dd>
     * <p>
     * The results begin with the first resource record set in the list whose name is greater than or equal to
     * <code>Name</code>, and whose type is greater than or equal to <code>Type</code>.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * This action returns the most current version of the records. This includes records that are <code>PENDING</code>,
     * and that are not yet available on all Amazon Route 53 DNS servers.
     * </p>
     * <p>
     * To ensure that you get an accurate listing of the resource record sets for a hosted zone at a point in time, do
     * not submit a <code>ChangeResourceRecordSets</code> request while you're paging through the results of a
     * <code>ListResourceRecordSets</code> request. If you do, some pages may display results without the latest changes
     * while other pages display results with the latest changes.
     * </p>
     * 
     * @param listResourceRecordSetsRequest
     *        A request for the resource record sets that are associated with a specified hosted zone.
     * @return A Java Future containing the result of the ListResourceRecordSets operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListResourceRecordSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListResourceRecordSets" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceRecordSetsResponse> listResourceRecordSets(
            ListResourceRecordSetsRequest listResourceRecordSetsRequest) {

        StaxResponseHandler<ListResourceRecordSetsResponse> responseHandler = new StaxResponseHandler<ListResourceRecordSetsResponse>(
                new ListResourceRecordSetsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ListResourceRecordSetsRequest, ListResourceRecordSetsResponse>()
                .withMarshaller(new ListResourceRecordSetsRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listResourceRecordSetsRequest));
    }

    /**
     * <p>
     * Retrieves a list of the reusable delegation sets that are associated with the current AWS account.
     * </p>
     * 
     * @param listReusableDelegationSetsRequest
     *        A request to get a list of the reusable delegation sets that are associated with the current AWS account.
     * @return A Java Future containing the result of the ListReusableDelegationSets operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListReusableDelegationSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListReusableDelegationSets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListReusableDelegationSetsResponse> listReusableDelegationSets() {
        return listReusableDelegationSets(ListReusableDelegationSetsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list of the reusable delegation sets that are associated with the current AWS account.
     * </p>
     * 
     * @param listReusableDelegationSetsRequest
     *        A request to get a list of the reusable delegation sets that are associated with the current AWS account.
     * @return A Java Future containing the result of the ListReusableDelegationSets operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListReusableDelegationSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListReusableDelegationSets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListReusableDelegationSetsResponse> listReusableDelegationSets(
            ListReusableDelegationSetsRequest listReusableDelegationSetsRequest) {

        StaxResponseHandler<ListReusableDelegationSetsResponse> responseHandler = new StaxResponseHandler<ListReusableDelegationSetsResponse>(
                new ListReusableDelegationSetsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<ListReusableDelegationSetsRequest, ListReusableDelegationSetsResponse>()
                        .withMarshaller(new ListReusableDelegationSetsRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(listReusableDelegationSetsRequest));
    }

    /**
     * <p>
     * Lists tags for one health check or hosted zone.
     * </p>
     * <p>
     * For information about using tags for cost allocation, see <a
     * href="http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
     * Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     * </p>
     * 
     * @param listTagsForResourceRequest
     *        A complex type containing information about a request for a list of the tags that are associated with an
     *        individual resource.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchHealthCheckException No health check exists with the ID that you specified in the
     *         <code>DeleteHealthCheck</code> request.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Amazon Route 53 returns this error repeatedly
     *         for the same request, we recommend that you wait, in intervals of increasing duration, before you try the
     *         request again.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {

        StaxResponseHandler<ListTagsForResourceResponse> responseHandler = new StaxResponseHandler<ListTagsForResourceResponse>(
                new ListTagsForResourceResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                .withMarshaller(new ListTagsForResourceRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest));
    }

    /**
     * <p>
     * Lists tags for up to 10 health checks or hosted zones.
     * </p>
     * <p>
     * For information about using tags for cost allocation, see <a
     * href="http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation
     * Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     * </p>
     * 
     * @param listTagsForResourcesRequest
     *        A complex type that contains information about the health checks or hosted zones for which you want to
     *        list tags.
     * @return A Java Future containing the result of the ListTagsForResources operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchHealthCheckException No health check exists with the ID that you specified in the
     *         <code>DeleteHealthCheck</code> request.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Amazon Route 53 returns this error repeatedly
     *         for the same request, we recommend that you wait, in intervals of increasing duration, before you try the
     *         request again.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListTagsForResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTagsForResources" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourcesResponse> listTagsForResources(
            ListTagsForResourcesRequest listTagsForResourcesRequest) {

        StaxResponseHandler<ListTagsForResourcesResponse> responseHandler = new StaxResponseHandler<ListTagsForResourcesResponse>(
                new ListTagsForResourcesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ListTagsForResourcesRequest, ListTagsForResourcesResponse>()
                .withMarshaller(new ListTagsForResourcesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourcesRequest));
    }

    /**
     * <p>
     * Gets information about the latest version for every traffic policy that is associated with the current AWS
     * account. Policies are listed in the order in which they were created.
     * </p>
     * 
     * @param listTrafficPoliciesRequest
     *        A complex type that contains the information about the request to list the traffic policies that are
     *        associated with the current AWS account.
     * @return A Java Future containing the result of the ListTrafficPolicies operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListTrafficPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTrafficPoliciesResponse> listTrafficPolicies() {
        return listTrafficPolicies(ListTrafficPoliciesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the latest version for every traffic policy that is associated with the current AWS
     * account. Policies are listed in the order in which they were created.
     * </p>
     * 
     * @param listTrafficPoliciesRequest
     *        A complex type that contains the information about the request to list the traffic policies that are
     *        associated with the current AWS account.
     * @return A Java Future containing the result of the ListTrafficPolicies operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListTrafficPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTrafficPoliciesResponse> listTrafficPolicies(
            ListTrafficPoliciesRequest listTrafficPoliciesRequest) {

        StaxResponseHandler<ListTrafficPoliciesResponse> responseHandler = new StaxResponseHandler<ListTrafficPoliciesResponse>(
                new ListTrafficPoliciesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<ListTrafficPoliciesRequest, ListTrafficPoliciesResponse>()
                .withMarshaller(new ListTrafficPoliciesRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listTrafficPoliciesRequest));
    }

    /**
     * <p>
     * Gets information about the traffic policy instances that you created by using the current AWS account.
     * </p>
     * <note>
     * <p>
     * After you submit an <code>UpdateTrafficPolicyInstance</code> request, there's a brief delay while Amazon Route 53
     * creates the resource record sets that are specified in the traffic policy definition. For more information, see
     * the <code>State</code> response element.
     * </p>
     * </note>
     * <p>
     * Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances,
     * you can use the <code>MaxItems</code> parameter to list them in groups of up to 100.
     * </p>
     * 
     * @param listTrafficPolicyInstancesRequest
     *        A request to get information about the traffic policy instances that you created by using the current AWS
     *        account.
     * @return A Java Future containing the result of the ListTrafficPolicyInstances operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListTrafficPolicyInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTrafficPolicyInstancesResponse> listTrafficPolicyInstances() {
        return listTrafficPolicyInstances(ListTrafficPolicyInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the traffic policy instances that you created by using the current AWS account.
     * </p>
     * <note>
     * <p>
     * After you submit an <code>UpdateTrafficPolicyInstance</code> request, there's a brief delay while Amazon Route 53
     * creates the resource record sets that are specified in the traffic policy definition. For more information, see
     * the <code>State</code> response element.
     * </p>
     * </note>
     * <p>
     * Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances,
     * you can use the <code>MaxItems</code> parameter to list them in groups of up to 100.
     * </p>
     * 
     * @param listTrafficPolicyInstancesRequest
     *        A request to get information about the traffic policy instances that you created by using the current AWS
     *        account.
     * @return A Java Future containing the result of the ListTrafficPolicyInstances operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListTrafficPolicyInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTrafficPolicyInstancesResponse> listTrafficPolicyInstances(
            ListTrafficPolicyInstancesRequest listTrafficPolicyInstancesRequest) {

        StaxResponseHandler<ListTrafficPolicyInstancesResponse> responseHandler = new StaxResponseHandler<ListTrafficPolicyInstancesResponse>(
                new ListTrafficPolicyInstancesResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<ListTrafficPolicyInstancesRequest, ListTrafficPolicyInstancesResponse>()
                        .withMarshaller(new ListTrafficPolicyInstancesRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(listTrafficPolicyInstancesRequest));
    }

    /**
     * <p>
     * Gets information about the traffic policy instances that you created in a specified hosted zone.
     * </p>
     * <note>
     * <p>
     * After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code>
     * request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the
     * traffic policy definition. For more information, see the <code>State</code> response element.
     * </p>
     * </note>
     * <p>
     * Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances,
     * you can use the <code>MaxItems</code> parameter to list them in groups of up to 100.
     * </p>
     * 
     * @param listTrafficPolicyInstancesByHostedZoneRequest
     *        A request for the traffic policy instances that you created in a specified hosted zone.
     * @return A Java Future containing the result of the ListTrafficPolicyInstancesByHostedZone operation returned by
     *         the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListTrafficPolicyInstancesByHostedZone
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstancesByHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTrafficPolicyInstancesByHostedZoneResponse> listTrafficPolicyInstancesByHostedZone(
            ListTrafficPolicyInstancesByHostedZoneRequest listTrafficPolicyInstancesByHostedZoneRequest) {

        StaxResponseHandler<ListTrafficPolicyInstancesByHostedZoneResponse> responseHandler = new StaxResponseHandler<ListTrafficPolicyInstancesByHostedZoneResponse>(
                new ListTrafficPolicyInstancesByHostedZoneResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<ListTrafficPolicyInstancesByHostedZoneRequest, ListTrafficPolicyInstancesByHostedZoneResponse>()
                        .withMarshaller(new ListTrafficPolicyInstancesByHostedZoneRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listTrafficPolicyInstancesByHostedZoneRequest));
    }

    /**
     * <p>
     * Gets information about the traffic policy instances that you created by using a specify traffic policy version.
     * </p>
     * <note>
     * <p>
     * After you submit a <code>CreateTrafficPolicyInstance</code> or an <code>UpdateTrafficPolicyInstance</code>
     * request, there's a brief delay while Amazon Route 53 creates the resource record sets that are specified in the
     * traffic policy definition. For more information, see the <code>State</code> response element.
     * </p>
     * </note>
     * <p>
     * Amazon Route 53 returns a maximum of 100 items in each response. If you have a lot of traffic policy instances,
     * you can use the <code>MaxItems</code> parameter to list them in groups of up to 100.
     * </p>
     * 
     * @param listTrafficPolicyInstancesByPolicyRequest
     *        A complex type that contains the information about the request to list your traffic policy instances.
     * @return A Java Future containing the result of the ListTrafficPolicyInstancesByPolicy operation returned by the
     *         service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListTrafficPolicyInstancesByPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstancesByPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTrafficPolicyInstancesByPolicyResponse> listTrafficPolicyInstancesByPolicy(
            ListTrafficPolicyInstancesByPolicyRequest listTrafficPolicyInstancesByPolicyRequest) {

        StaxResponseHandler<ListTrafficPolicyInstancesByPolicyResponse> responseHandler = new StaxResponseHandler<ListTrafficPolicyInstancesByPolicyResponse>(
                new ListTrafficPolicyInstancesByPolicyResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<ListTrafficPolicyInstancesByPolicyRequest, ListTrafficPolicyInstancesByPolicyResponse>()
                        .withMarshaller(new ListTrafficPolicyInstancesByPolicyRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listTrafficPolicyInstancesByPolicyRequest));
    }

    /**
     * <p>
     * Gets information about all of the versions for a specified traffic policy.
     * </p>
     * <p>
     * Traffic policy versions are listed in numerical order by <code>VersionNumber</code>.
     * </p>
     * 
     * @param listTrafficPolicyVersionsRequest
     *        A complex type that contains the information about the request to list your traffic policies.
     * @return A Java Future containing the result of the ListTrafficPolicyVersions operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListTrafficPolicyVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTrafficPolicyVersionsResponse> listTrafficPolicyVersions(
            ListTrafficPolicyVersionsRequest listTrafficPolicyVersionsRequest) {

        StaxResponseHandler<ListTrafficPolicyVersionsResponse> responseHandler = new StaxResponseHandler<ListTrafficPolicyVersionsResponse>(
                new ListTrafficPolicyVersionsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<ListTrafficPolicyVersionsRequest, ListTrafficPolicyVersionsResponse>()
                        .withMarshaller(new ListTrafficPolicyVersionsRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(listTrafficPolicyVersionsRequest));
    }

    /**
     * <p>
     * Gets a list of the VPCs that were created by other accounts and that can be associated with a specified hosted
     * zone because you've submitted one or more <code>CreateVPCAssociationAuthorization</code> requests.
     * </p>
     * <p>
     * The response includes a <code>VPCs</code> element with a <code>VPC</code> child element for each VPC that can be
     * associated with the hosted zone.
     * </p>
     * 
     * @param listVPCAssociationAuthorizationsRequest
     *        A complex type that contains information about that can be associated with your hosted zone.
     * @return A Java Future containing the result of the ListVPCAssociationAuthorizations operation returned by the
     *         service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>InvalidPaginationTokenException</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.ListVPCAssociationAuthorizations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListVPCAssociationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListVPCAssociationAuthorizationsResponse> listVPCAssociationAuthorizations(
            ListVPCAssociationAuthorizationsRequest listVPCAssociationAuthorizationsRequest) {

        StaxResponseHandler<ListVPCAssociationAuthorizationsResponse> responseHandler = new StaxResponseHandler<ListVPCAssociationAuthorizationsResponse>(
                new ListVPCAssociationAuthorizationsResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<ListVPCAssociationAuthorizationsRequest, ListVPCAssociationAuthorizationsResponse>()
                        .withMarshaller(new ListVPCAssociationAuthorizationsRequestMarshaller())
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(listVPCAssociationAuthorizationsRequest));
    }

    /**
     * <p>
     * Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and type.
     * You can optionally specify the IP address of a DNS resolver, an EDNS0 client subnet IP address, and a subnet
     * mask.
     * </p>
     * 
     * @param testDNSAnswerRequest
     *        Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and
     *        type. You can optionally specify the IP address of a DNS resolver, an EDNS0 client subnet IP address, and
     *        a subnet mask.
     * @return A Java Future containing the result of the TestDNSAnswer operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.TestDNSAnswer
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/TestDNSAnswer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TestDNSAnswerResponse> testDNSAnswer(TestDNSAnswerRequest testDNSAnswerRequest) {

        StaxResponseHandler<TestDNSAnswerResponse> responseHandler = new StaxResponseHandler<TestDNSAnswerResponse>(
                new TestDNSAnswerResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<TestDNSAnswerRequest, TestDNSAnswerResponse>()
                .withMarshaller(new TestDNSAnswerRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(testDNSAnswerRequest));
    }

    /**
     * <p>
     * Updates an existing health check. Note that some values can't be updated.
     * </p>
     * <p>
     * For more information about updating health checks, see <a
     * href="http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html">Creating,
     * Updating, and Deleting Health Checks</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * 
     * @param updateHealthCheckRequest
     *        A complex type that contains information about a request to update a health check.
     * @return A Java Future containing the result of the UpdateHealthCheck operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHealthCheckException No health check exists with the ID that you specified in the
     *         <code>DeleteHealthCheck</code> request.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>HealthCheckVersionMismatchException The value of <code>HealthCheckVersion</code> in the request
     *         doesn't match the value of <code>HealthCheckVersion</code> in the health check.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.UpdateHealthCheck
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateHealthCheck" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateHealthCheckResponse> updateHealthCheck(UpdateHealthCheckRequest updateHealthCheckRequest) {

        StaxResponseHandler<UpdateHealthCheckResponse> responseHandler = new StaxResponseHandler<UpdateHealthCheckResponse>(
                new UpdateHealthCheckResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<UpdateHealthCheckRequest, UpdateHealthCheckResponse>()
                .withMarshaller(new UpdateHealthCheckRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateHealthCheckRequest));
    }

    /**
     * <p>
     * Updates the comment for a specified hosted zone.
     * </p>
     * 
     * @param updateHostedZoneCommentRequest
     *        A request to update the comment for a hosted zone.
     * @return A Java Future containing the result of the UpdateHostedZoneComment operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchHostedZoneException No hosted zone exists with the ID that you specified.</li>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.UpdateHostedZoneComment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateHostedZoneComment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateHostedZoneCommentResponse> updateHostedZoneComment(
            UpdateHostedZoneCommentRequest updateHostedZoneCommentRequest) {

        StaxResponseHandler<UpdateHostedZoneCommentResponse> responseHandler = new StaxResponseHandler<UpdateHostedZoneCommentResponse>(
                new UpdateHostedZoneCommentResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler.execute(new ClientExecutionParams<UpdateHostedZoneCommentRequest, UpdateHostedZoneCommentResponse>()
                .withMarshaller(new UpdateHostedZoneCommentRequestMarshaller()).withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateHostedZoneCommentRequest));
    }

    /**
     * <p>
     * Updates the comment for a specified traffic policy version.
     * </p>
     * 
     * @param updateTrafficPolicyCommentRequest
     *        A complex type that contains information about the traffic policy that you want to update the comment for.
     * @return A Java Future containing the result of the UpdateTrafficPolicyComment operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>ConcurrentModificationException Another user submitted a request to update the object at the same
     *         time that you did. Retry the request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.UpdateTrafficPolicyComment
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateTrafficPolicyComment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTrafficPolicyCommentResponse> updateTrafficPolicyComment(
            UpdateTrafficPolicyCommentRequest updateTrafficPolicyCommentRequest) {

        StaxResponseHandler<UpdateTrafficPolicyCommentResponse> responseHandler = new StaxResponseHandler<UpdateTrafficPolicyCommentResponse>(
                new UpdateTrafficPolicyCommentResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateTrafficPolicyCommentRequest, UpdateTrafficPolicyCommentResponse>()
                        .withMarshaller(new UpdateTrafficPolicyCommentRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updateTrafficPolicyCommentRequest));
    }

    /**
     * <p>
     * Updates the resource record sets in a specified hosted zone that were created based on the settings in a
     * specified traffic policy version.
     * </p>
     * <p>
     * When you update a traffic policy instance, Amazon Route 53 continues to respond to DNS queries for the root
     * resource record set name (such as example.com) while it replaces one group of resource record sets with another.
     * Amazon Route 53 performs the following operations:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Amazon Route 53 creates a new group of resource record sets based on the specified traffic policy. This is true
     * regardless of how significant the differences are between the existing resource record sets and the new resource
     * record sets.
     * </p>
     * </li>
     * <li>
     * <p>
     * When all of the new resource record sets have been created, Amazon Route 53 starts to respond to DNS queries for
     * the root resource record set name (such as example.com) by using the new resource record sets.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Route 53 deletes the old group of resource record sets that are associated with the root resource record
     * set name.
     * </p>
     * </li>
     * </ol>
     * 
     * @param updateTrafficPolicyInstanceRequest
     *        A complex type that contains information about the resource record sets that you want to update based on a
     *        specified traffic policy instance.
     * @return A Java Future containing the result of the UpdateTrafficPolicyInstance operation returned by the service. <br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException The input is not valid.</li>
     *         <li>NoSuchTrafficPolicyException No traffic policy exists with the specified ID.</li>
     *         <li>NoSuchTrafficPolicyInstanceException No traffic policy instance exists with the specified ID.</li>
     *         <li>PriorRequestNotCompleteException If Amazon Route 53 can't process a request before the next request
     *         arrives, it will reject subsequent requests for the same hosted zone and return an
     *         <code>HTTP 400 error</code> (<code>Bad request</code>). If Amazon Route 53 returns this error repeatedly
     *         for the same request, we recommend that you wait, in intervals of increasing duration, before you try the
     *         request again.</li>
     *         <li>ConflictingTypesException You tried to update a traffic policy instance by using a traffic policy
     *         version that has a different DNS type than the current type for the instance. You specified the type in
     *         the JSON document in the <code>CreateTrafficPolicy</code> or <code>CreateTrafficPolicyVersion</code>
     *         request.</li>
     *         <li>SdkBaseException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc</li>
     *         <li>Route53Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this</li >
     *         <ul>
     * @sample Route53AsyncClient.UpdateTrafficPolicyInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/UpdateTrafficPolicyInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTrafficPolicyInstanceResponse> updateTrafficPolicyInstance(
            UpdateTrafficPolicyInstanceRequest updateTrafficPolicyInstanceRequest) {

        StaxResponseHandler<UpdateTrafficPolicyInstanceResponse> responseHandler = new StaxResponseHandler<UpdateTrafficPolicyInstanceResponse>(
                new UpdateTrafficPolicyInstanceResponseUnmarshaller());

        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(exceptionUnmarshallers);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateTrafficPolicyInstanceRequest, UpdateTrafficPolicyInstanceResponse>()
                        .withMarshaller(new UpdateTrafficPolicyInstanceRequestMarshaller()).withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updateTrafficPolicyInstanceRequest));
    }

    @Override
    public void close() throws Exception {
        clientHandler.close();
    }

    private List<Unmarshaller<AmazonServiceException, Node>> init() {
        List<Unmarshaller<AmazonServiceException, Node>> unmarshallers = new ArrayList<>();
        unmarshallers.add(new HostedZoneNotEmptyExceptionUnmarshaller());
        unmarshallers.add(new ConcurrentModificationExceptionUnmarshaller());
        unmarshallers.add(new VPCAssociationAuthorizationNotFoundExceptionUnmarshaller());
        unmarshallers.add(new InvalidDomainNameExceptionUnmarshaller());
        unmarshallers.add(new TooManyHealthChecksExceptionUnmarshaller());
        unmarshallers.add(new IncompatibleVersionExceptionUnmarshaller());
        unmarshallers.add(new HealthCheckInUseExceptionUnmarshaller());
        unmarshallers.add(new InvalidChangeBatchExceptionUnmarshaller());
        unmarshallers.add(new HostedZoneAlreadyExistsExceptionUnmarshaller());
        unmarshallers.add(new InvalidTrafficPolicyDocumentExceptionUnmarshaller());
        unmarshallers.add(new NoSuchTrafficPolicyExceptionUnmarshaller());
        unmarshallers.add(new ThrottlingExceptionUnmarshaller());
        unmarshallers.add(new TooManyTrafficPoliciesExceptionUnmarshaller());
        unmarshallers.add(new TrafficPolicyAlreadyExistsExceptionUnmarshaller());
        unmarshallers.add(new DelegationSetAlreadyCreatedExceptionUnmarshaller());
        unmarshallers.add(new DelegationSetAlreadyReusableExceptionUnmarshaller());
        unmarshallers.add(new InvalidVPCIdExceptionUnmarshaller());
        unmarshallers.add(new TrafficPolicyInUseExceptionUnmarshaller());
        unmarshallers.add(new NoSuchHostedZoneExceptionUnmarshaller());
        unmarshallers.add(new TooManyHostedZonesExceptionUnmarshaller());
        unmarshallers.add(new VPCAssociationNotFoundExceptionUnmarshaller());
        unmarshallers.add(new PublicZoneVPCAssociationExceptionUnmarshaller());
        unmarshallers.add(new NoSuchGeoLocationExceptionUnmarshaller());
        unmarshallers.add(new TrafficPolicyInstanceAlreadyExistsExceptionUnmarshaller());
        unmarshallers.add(new NoSuchChangeExceptionUnmarshaller());
        unmarshallers.add(new ConflictingTypesExceptionUnmarshaller());
        unmarshallers.add(new LastVPCAssociationExceptionUnmarshaller());
        unmarshallers.add(new DelegationSetNotReusableExceptionUnmarshaller());
        unmarshallers.add(new PriorRequestNotCompleteExceptionUnmarshaller());
        unmarshallers.add(new HostedZoneNotFoundExceptionUnmarshaller());
        unmarshallers.add(new InvalidArgumentExceptionUnmarshaller());
        unmarshallers.add(new HealthCheckVersionMismatchExceptionUnmarshaller());
        unmarshallers.add(new InvalidInputExceptionUnmarshaller());
        unmarshallers.add(new ConflictingDomainExistsExceptionUnmarshaller());
        unmarshallers.add(new HealthCheckAlreadyExistsExceptionUnmarshaller());
        unmarshallers.add(new DelegationSetInUseExceptionUnmarshaller());
        unmarshallers.add(new NoSuchDelegationSetExceptionUnmarshaller());
        unmarshallers.add(new NotAuthorizedExceptionUnmarshaller());
        unmarshallers.add(new NoSuchHealthCheckExceptionUnmarshaller());
        unmarshallers.add(new TooManyVPCAssociationAuthorizationsExceptionUnmarshaller());
        unmarshallers.add(new TooManyTrafficPolicyInstancesExceptionUnmarshaller());
        unmarshallers.add(new InvalidPaginationTokenExceptionUnmarshaller());
        unmarshallers.add(new LimitsExceededExceptionUnmarshaller());
        unmarshallers.add(new DelegationSetNotAvailableExceptionUnmarshaller());
        unmarshallers.add(new NoSuchTrafficPolicyInstanceExceptionUnmarshaller());
        unmarshallers.add(new StandardErrorUnmarshaller(Route53Exception.class));
        return unmarshallers;
    }
}
