/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that describes change information about changes made to your hosted zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ChangeInfo implements ToCopyableBuilder<ChangeInfo.Builder, ChangeInfo> {
    private final String id;

    private final String status;

    private final Instant submittedAt;

    private final String comment;

    private ChangeInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.submittedAt = builder.submittedAt;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The ID of the request.
     * </p>
     * 
     * @return The ID of the request.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The current state of the request. <code>PENDING</code> indicates that this request has not yet been applied to
     * all Amazon Route 53 DNS servers.
     * </p>
     * 
     * @return The current state of the request. <code>PENDING</code> indicates that this request has not yet been
     *         applied to all Amazon Route 53 DNS servers.
     * @see ChangeStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The date and time that the change request was submitted in <a href="https://en.wikipedia.org/wiki/ISO_8601">ISO
     * 8601 format</a> and Coordinated Universal Time (UTC). For example, the value
     * <code>2017-03-27T17:48:16.751Z</code> represents March 27, 2017 at 17:48:16.751 UTC.
     * </p>
     * 
     * @return The date and time that the change request was submitted in <a
     *         href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 format</a> and Coordinated Universal Time (UTC).
     *         For example, the value <code>2017-03-27T17:48:16.751Z</code> represents March 27, 2017 at 17:48:16.751
     *         UTC.
     */
    public Instant submittedAt() {
        return submittedAt;
    }

    /**
     * <p>
     * A complex type that describes change information about changes made to your hosted zone.
     * </p>
     * <p>
     * This element contains an ID that you use when performing a <a>GetChange</a> action to get detailed information
     * about the change.
     * </p>
     * 
     * @return A complex type that describes change information about changes made to your hosted zone.</p>
     *         <p>
     *         This element contains an ID that you use when performing a <a>GetChange</a> action to get detailed
     *         information about the change.
     */
    public String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((submittedAt() == null) ? 0 : submittedAt().hashCode());
        hashCode = 31 * hashCode + ((comment() == null) ? 0 : comment().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeInfo)) {
            return false;
        }
        ChangeInfo other = (ChangeInfo) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.submittedAt() == null ^ this.submittedAt() == null) {
            return false;
        }
        if (other.submittedAt() != null && !other.submittedAt().equals(this.submittedAt())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        if (other.comment() != null && !other.comment().equals(this.comment())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (submittedAt() != null) {
            sb.append("SubmittedAt: ").append(submittedAt()).append(",");
        }
        if (comment() != null) {
            sb.append("Comment: ").append(comment()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ChangeInfo> {
        /**
         * <p>
         * The ID of the request.
         * </p>
         * 
         * @param id
         *        The ID of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The current state of the request. <code>PENDING</code> indicates that this request has not yet been applied
         * to all Amazon Route 53 DNS servers.
         * </p>
         * 
         * @param status
         *        The current state of the request. <code>PENDING</code> indicates that this request has not yet been
         *        applied to all Amazon Route 53 DNS servers.
         * @see ChangeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of the request. <code>PENDING</code> indicates that this request has not yet been applied
         * to all Amazon Route 53 DNS servers.
         * </p>
         * 
         * @param status
         *        The current state of the request. <code>PENDING</code> indicates that this request has not yet been
         *        applied to all Amazon Route 53 DNS servers.
         * @see ChangeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeStatus
         */
        Builder status(ChangeStatus status);

        /**
         * <p>
         * The date and time that the change request was submitted in <a
         * href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 format</a> and Coordinated Universal Time (UTC). For
         * example, the value <code>2017-03-27T17:48:16.751Z</code> represents March 27, 2017 at 17:48:16.751 UTC.
         * </p>
         * 
         * @param submittedAt
         *        The date and time that the change request was submitted in <a
         *        href="https://en.wikipedia.org/wiki/ISO_8601">ISO 8601 format</a> and Coordinated Universal Time
         *        (UTC). For example, the value <code>2017-03-27T17:48:16.751Z</code> represents March 27, 2017 at
         *        17:48:16.751 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedAt(Instant submittedAt);

        /**
         * <p>
         * A complex type that describes change information about changes made to your hosted zone.
         * </p>
         * <p>
         * This element contains an ID that you use when performing a <a>GetChange</a> action to get detailed
         * information about the change.
         * </p>
         * 
         * @param comment
         *        A complex type that describes change information about changes made to your hosted zone.</p>
         *        <p>
         *        This element contains an ID that you use when performing a <a>GetChange</a> action to get detailed
         *        information about the change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String status;

        private Instant submittedAt;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeInfo model) {
            setId(model.id);
            setStatus(model.status);
            setSubmittedAt(model.submittedAt);
            setComment(model.comment);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ChangeStatus status) {
            this.status(status.toString());
        }

        public final Instant getSubmittedAt() {
            return submittedAt;
        }

        @Override
        public final Builder submittedAt(Instant submittedAt) {
            this.submittedAt = submittedAt;
            return this;
        }

        public final void setSubmittedAt(Instant submittedAt) {
            this.submittedAt = submittedAt;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public ChangeInfo build() {
            return new ChangeInfo(this);
        }
    }
}
