/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the tags that you want to add, edit, or delete.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ChangeTagsForResourceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ChangeTagsForResourceRequest.Builder, ChangeTagsForResourceRequest> {
    private final String resourceType;

    private final String resourceId;

    private final List<Tag> addTags;

    private final List<String> removeTagKeys;

    private ChangeTagsForResourceRequest(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.addTags = builder.addTags;
        this.removeTagKeys = builder.removeTagKeys;
    }

    /**
     * <p>
     * The type of the resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The resource type for health checks is <code>healthcheck</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The resource type for hosted zones is <code>hostedzone</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of the resource.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The resource type for health checks is <code>healthcheck</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The resource type for hosted zones is <code>hostedzone</code>.
     *         </p>
     *         </li>
     * @see TagResourceType
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the resource for which you want to add, change, or delete tags.
     * </p>
     * 
     * @return The ID of the resource for which you want to add, change, or delete tags.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * A complex type that contains a list of the tags that you want to add to the specified health check or hosted zone
     * and/or the tags that you want to edit <code>Value</code> for.
     * </p>
     * <p>
     * You can add a maximum of 10 tags to a health check or a hosted zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains a list of the tags that you want to add to the specified health check or
     *         hosted zone and/or the tags that you want to edit <code>Value</code> for.</p>
     *         <p>
     *         You can add a maximum of 10 tags to a health check or a hosted zone.
     */
    public List<Tag> addTags() {
        return addTags;
    }

    /**
     * <p>
     * A complex type that contains a list of the tags that you want to delete from the specified health check or hosted
     * zone. You can specify up to 10 keys.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains a list of the tags that you want to delete from the specified health check
     *         or hosted zone. You can specify up to 10 keys.
     */
    public List<String> removeTagKeys() {
        return removeTagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceType() == null) ? 0 : resourceType().hashCode());
        hashCode = 31 * hashCode + ((resourceId() == null) ? 0 : resourceId().hashCode());
        hashCode = 31 * hashCode + ((addTags() == null) ? 0 : addTags().hashCode());
        hashCode = 31 * hashCode + ((removeTagKeys() == null) ? 0 : removeTagKeys().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeTagsForResourceRequest)) {
            return false;
        }
        ChangeTagsForResourceRequest other = (ChangeTagsForResourceRequest) obj;
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.addTags() == null ^ this.addTags() == null) {
            return false;
        }
        if (other.addTags() != null && !other.addTags().equals(this.addTags())) {
            return false;
        }
        if (other.removeTagKeys() == null ^ this.removeTagKeys() == null) {
            return false;
        }
        if (other.removeTagKeys() != null && !other.removeTagKeys().equals(this.removeTagKeys())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (resourceId() != null) {
            sb.append("ResourceId: ").append(resourceId()).append(",");
        }
        if (addTags() != null) {
            sb.append("AddTags: ").append(addTags()).append(",");
        }
        if (removeTagKeys() != null) {
            sb.append("RemoveTagKeys: ").append(removeTagKeys()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ChangeTagsForResourceRequest> {
        /**
         * <p>
         * The type of the resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The resource type for health checks is <code>healthcheck</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The resource type for hosted zones is <code>hostedzone</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        The type of the resource.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The resource type for health checks is <code>healthcheck</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The resource type for hosted zones is <code>hostedzone</code>.
         *        </p>
         *        </li>
         * @see TagResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The resource type for health checks is <code>healthcheck</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * The resource type for hosted zones is <code>hostedzone</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        The type of the resource.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The resource type for health checks is <code>healthcheck</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The resource type for hosted zones is <code>hostedzone</code>.
         *        </p>
         *        </li>
         * @see TagResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagResourceType
         */
        Builder resourceType(TagResourceType resourceType);

        /**
         * <p>
         * The ID of the resource for which you want to add, change, or delete tags.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource for which you want to add, change, or delete tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * A complex type that contains a list of the tags that you want to add to the specified health check or hosted
         * zone and/or the tags that you want to edit <code>Value</code> for.
         * </p>
         * <p>
         * You can add a maximum of 10 tags to a health check or a hosted zone.
         * </p>
         * 
         * @param addTags
         *        A complex type that contains a list of the tags that you want to add to the specified health check or
         *        hosted zone and/or the tags that you want to edit <code>Value</code> for.</p>
         *        <p>
         *        You can add a maximum of 10 tags to a health check or a hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addTags(Collection<Tag> addTags);

        /**
         * <p>
         * A complex type that contains a list of the tags that you want to add to the specified health check or hosted
         * zone and/or the tags that you want to edit <code>Value</code> for.
         * </p>
         * <p>
         * You can add a maximum of 10 tags to a health check or a hosted zone.
         * </p>
         * 
         * @param addTags
         *        A complex type that contains a list of the tags that you want to add to the specified health check or
         *        hosted zone and/or the tags that you want to edit <code>Value</code> for.</p>
         *        <p>
         *        You can add a maximum of 10 tags to a health check or a hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addTags(Tag... addTags);

        /**
         * <p>
         * A complex type that contains a list of the tags that you want to delete from the specified health check or
         * hosted zone. You can specify up to 10 keys.
         * </p>
         * 
         * @param removeTagKeys
         *        A complex type that contains a list of the tags that you want to delete from the specified health
         *        check or hosted zone. You can specify up to 10 keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeTagKeys(Collection<String> removeTagKeys);

        /**
         * <p>
         * A complex type that contains a list of the tags that you want to delete from the specified health check or
         * hosted zone. You can specify up to 10 keys.
         * </p>
         * 
         * @param removeTagKeys
         *        A complex type that contains a list of the tags that you want to delete from the specified health
         *        check or hosted zone. You can specify up to 10 keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeTagKeys(String... removeTagKeys);
    }

    private static final class BuilderImpl implements Builder {
        private String resourceType;

        private String resourceId;

        private List<Tag> addTags;

        private List<String> removeTagKeys;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeTagsForResourceRequest model) {
            setResourceType(model.resourceType);
            setResourceId(model.resourceId);
            setAddTags(model.addTags);
            setRemoveTagKeys(model.removeTagKeys);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TagResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final void setResourceType(TagResourceType resourceType) {
            this.resourceType(resourceType.toString());
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Collection<Tag> getAddTags() {
            return addTags;
        }

        @Override
        public final Builder addTags(Collection<Tag> addTags) {
            this.addTags = TagListCopier.copy(addTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Tag... addTags) {
            addTags(Arrays.asList(addTags));
            return this;
        }

        public final void setAddTags(Collection<Tag> addTags) {
            this.addTags = TagListCopier.copy(addTags);
        }

        @SafeVarargs
        public final void setAddTags(Tag... addTags) {
            addTags(Arrays.asList(addTags));
        }

        public final Collection<String> getRemoveTagKeys() {
            return removeTagKeys;
        }

        @Override
        public final Builder removeTagKeys(Collection<String> removeTagKeys) {
            this.removeTagKeys = TagKeyListCopier.copy(removeTagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeTagKeys(String... removeTagKeys) {
            removeTagKeys(Arrays.asList(removeTagKeys));
            return this;
        }

        public final void setRemoveTagKeys(Collection<String> removeTagKeys) {
            this.removeTagKeys = TagKeyListCopier.copy(removeTagKeys);
        }

        @SafeVarargs
        public final void setRemoveTagKeys(String... removeTagKeys) {
            removeTagKeys(Arrays.asList(removeTagKeys));
        }

        @Override
        public ChangeTagsForResourceRequest build() {
            return new ChangeTagsForResourceRequest(this);
        }
    }
}
