/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the traffic policy that you want to create a new version for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateTrafficPolicyVersionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateTrafficPolicyVersionRequest.Builder, CreateTrafficPolicyVersionRequest> {
    private final String id;

    private final String document;

    private final String comment;

    private CreateTrafficPolicyVersionRequest(BuilderImpl builder) {
        this.id = builder.id;
        this.document = builder.document;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The ID of the traffic policy for which you want to create a new version.
     * </p>
     * 
     * @return The ID of the traffic policy for which you want to create a new version.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The definition of this version of the traffic policy, in JSON format. You specified the JSON in the
     * <code>CreateTrafficPolicyVersion</code> request. For more information about the JSON format, see
     * <a>CreateTrafficPolicy</a>.
     * </p>
     * 
     * @return The definition of this version of the traffic policy, in JSON format. You specified the JSON in the
     *         <code>CreateTrafficPolicyVersion</code> request. For more information about the JSON format, see
     *         <a>CreateTrafficPolicy</a>.
     */
    public String document() {
        return document;
    }

    /**
     * <p>
     * The comment that you specified in the <code>CreateTrafficPolicyVersion</code> request, if any.
     * </p>
     * 
     * @return The comment that you specified in the <code>CreateTrafficPolicyVersion</code> request, if any.
     */
    public String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((document() == null) ? 0 : document().hashCode());
        hashCode = 31 * hashCode + ((comment() == null) ? 0 : comment().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficPolicyVersionRequest)) {
            return false;
        }
        CreateTrafficPolicyVersionRequest other = (CreateTrafficPolicyVersionRequest) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.document() == null ^ this.document() == null) {
            return false;
        }
        if (other.document() != null && !other.document().equals(this.document())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        if (other.comment() != null && !other.comment().equals(this.comment())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (document() != null) {
            sb.append("Document: ").append(document()).append(",");
        }
        if (comment() != null) {
            sb.append("Comment: ").append(comment()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateTrafficPolicyVersionRequest> {
        /**
         * <p>
         * The ID of the traffic policy for which you want to create a new version.
         * </p>
         * 
         * @param id
         *        The ID of the traffic policy for which you want to create a new version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The definition of this version of the traffic policy, in JSON format. You specified the JSON in the
         * <code>CreateTrafficPolicyVersion</code> request. For more information about the JSON format, see
         * <a>CreateTrafficPolicy</a>.
         * </p>
         * 
         * @param document
         *        The definition of this version of the traffic policy, in JSON format. You specified the JSON in the
         *        <code>CreateTrafficPolicyVersion</code> request. For more information about the JSON format, see
         *        <a>CreateTrafficPolicy</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(String document);

        /**
         * <p>
         * The comment that you specified in the <code>CreateTrafficPolicyVersion</code> request, if any.
         * </p>
         * 
         * @param comment
         *        The comment that you specified in the <code>CreateTrafficPolicyVersion</code> request, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String document;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficPolicyVersionRequest model) {
            setId(model.id);
            setDocument(model.document);
            setComment(model.comment);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getDocument() {
            return document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public CreateTrafficPolicyVersionRequest build() {
            return new CreateTrafficPolicyVersionRequest(this);
        }
    }
}
