/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the VPC that you want to disassociate from a specified private hosted
 * zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DisassociateVPCFromHostedZoneRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DisassociateVPCFromHostedZoneRequest.Builder, DisassociateVPCFromHostedZoneRequest> {
    private final String hostedZoneId;

    private final VPC vpc;

    private final String comment;

    private DisassociateVPCFromHostedZoneRequest(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
        this.vpc = builder.vpc;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The ID of the private hosted zone that you want to disassociate a VPC from.
     * </p>
     * 
     * @return The ID of the private hosted zone that you want to disassociate a VPC from.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * A complex type that contains information about the VPC that you're disassociating from the specified hosted zone.
     * </p>
     * 
     * @return A complex type that contains information about the VPC that you're disassociating from the specified
     *         hosted zone.
     */
    public VPC vpc() {
        return vpc;
    }

    /**
     * <p>
     * <i>Optional:</i> A comment about the disassociation request.
     * </p>
     * 
     * @return <i>Optional:</i> A comment about the disassociation request.
     */
    public String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((hostedZoneId() == null) ? 0 : hostedZoneId().hashCode());
        hashCode = 31 * hashCode + ((vpc() == null) ? 0 : vpc().hashCode());
        hashCode = 31 * hashCode + ((comment() == null) ? 0 : comment().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateVPCFromHostedZoneRequest)) {
            return false;
        }
        DisassociateVPCFromHostedZoneRequest other = (DisassociateVPCFromHostedZoneRequest) obj;
        if (other.hostedZoneId() == null ^ this.hostedZoneId() == null) {
            return false;
        }
        if (other.hostedZoneId() != null && !other.hostedZoneId().equals(this.hostedZoneId())) {
            return false;
        }
        if (other.vpc() == null ^ this.vpc() == null) {
            return false;
        }
        if (other.vpc() != null && !other.vpc().equals(this.vpc())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        if (other.comment() != null && !other.comment().equals(this.comment())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(hostedZoneId()).append(",");
        }
        if (vpc() != null) {
            sb.append("VPC: ").append(vpc()).append(",");
        }
        if (comment() != null) {
            sb.append("Comment: ").append(comment()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DisassociateVPCFromHostedZoneRequest> {
        /**
         * <p>
         * The ID of the private hosted zone that you want to disassociate a VPC from.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the private hosted zone that you want to disassociate a VPC from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * A complex type that contains information about the VPC that you're disassociating from the specified hosted
         * zone.
         * </p>
         * 
         * @param vpc
         *        A complex type that contains information about the VPC that you're disassociating from the specified
         *        hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(VPC vpc);

        /**
         * <p>
         * <i>Optional:</i> A comment about the disassociation request.
         * </p>
         * 
         * @param comment
         *        <i>Optional:</i> A comment about the disassociation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);
    }

    private static final class BuilderImpl implements Builder {
        private String hostedZoneId;

        private VPC vpc;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateVPCFromHostedZoneRequest model) {
            setHostedZoneId(model.hostedZoneId);
            setVPC(model.vpc);
            setComment(model.comment);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final VPC getVPC() {
            return vpc;
        }

        @Override
        public final Builder vpc(VPC vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVPC(VPC vpc) {
            this.vpc = vpc;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public DisassociateVPCFromHostedZoneRequest build() {
            return new DisassociateVPCFromHostedZoneRequest(this);
        }
    }
}
