/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request for information about whether a specified geographic location is supported for Amazon Route 53 geolocation
 * resource record sets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetGeoLocationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetGeoLocationRequest.Builder, GetGeoLocationRequest> {
    private final String continentCode;

    private final String countryCode;

    private final String subdivisionCode;

    private GetGeoLocationRequest(BuilderImpl builder) {
        this.continentCode = builder.continentCode;
        this.countryCode = builder.countryCode;
        this.subdivisionCode = builder.subdivisionCode;
    }

    /**
     * <p>
     * Amazon Route 53 supports the following continent codes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>AF</b>: Africa
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AN</b>: Antarctica
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>AS</b>: Asia
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EU</b>: Europe
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>OC</b>: Oceania
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>NA</b>: North America
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SA</b>: South America
     * </p>
     * </li>
     * </ul>
     * 
     * @return Amazon Route 53 supports the following continent codes:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>AF</b>: Africa
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AN</b>: Antarctica
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>AS</b>: Asia
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>EU</b>: Europe
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>OC</b>: Oceania
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>NA</b>: North America
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SA</b>: South America
     *         </p>
     *         </li>
     */
    public String continentCode() {
        return continentCode;
    }

    /**
     * <p>
     * Amazon Route 53 uses the two-letter country codes that are specified in <a
     * href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.
     * </p>
     * 
     * @return Amazon Route 53 uses the two-letter country codes that are specified in <a
     *         href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.
     */
    public String countryCode() {
        return countryCode;
    }

    /**
     * <p>
     * Amazon Route 53 uses the one- to three-letter subdivision codes that are specified in <a
     * href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>. Amazon Route 53 doesn't
     * support subdivision codes for all countries. If you specify <code>SubdivisionCode</code>, you must also specify
     * <code>CountryCode</code>.
     * </p>
     * 
     * @return Amazon Route 53 uses the one- to three-letter subdivision codes that are specified in <a
     *         href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>. Amazon Route 53
     *         doesn't support subdivision codes for all countries. If you specify <code>SubdivisionCode</code>, you
     *         must also specify <code>CountryCode</code>.
     */
    public String subdivisionCode() {
        return subdivisionCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((continentCode() == null) ? 0 : continentCode().hashCode());
        hashCode = 31 * hashCode + ((countryCode() == null) ? 0 : countryCode().hashCode());
        hashCode = 31 * hashCode + ((subdivisionCode() == null) ? 0 : subdivisionCode().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGeoLocationRequest)) {
            return false;
        }
        GetGeoLocationRequest other = (GetGeoLocationRequest) obj;
        if (other.continentCode() == null ^ this.continentCode() == null) {
            return false;
        }
        if (other.continentCode() != null && !other.continentCode().equals(this.continentCode())) {
            return false;
        }
        if (other.countryCode() == null ^ this.countryCode() == null) {
            return false;
        }
        if (other.countryCode() != null && !other.countryCode().equals(this.countryCode())) {
            return false;
        }
        if (other.subdivisionCode() == null ^ this.subdivisionCode() == null) {
            return false;
        }
        if (other.subdivisionCode() != null && !other.subdivisionCode().equals(this.subdivisionCode())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (continentCode() != null) {
            sb.append("ContinentCode: ").append(continentCode()).append(",");
        }
        if (countryCode() != null) {
            sb.append("CountryCode: ").append(countryCode()).append(",");
        }
        if (subdivisionCode() != null) {
            sb.append("SubdivisionCode: ").append(subdivisionCode()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetGeoLocationRequest> {
        /**
         * <p>
         * Amazon Route 53 supports the following continent codes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>AF</b>: Africa
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AN</b>: Antarctica
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>AS</b>: Asia
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>EU</b>: Europe
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>OC</b>: Oceania
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NA</b>: North America
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SA</b>: South America
         * </p>
         * </li>
         * </ul>
         * 
         * @param continentCode
         *        Amazon Route 53 supports the following continent codes:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>AF</b>: Africa
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AN</b>: Antarctica
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>AS</b>: Asia
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>EU</b>: Europe
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>OC</b>: Oceania
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>NA</b>: North America
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SA</b>: South America
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continentCode(String continentCode);

        /**
         * <p>
         * Amazon Route 53 uses the two-letter country codes that are specified in <a
         * href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.
         * </p>
         * 
         * @param countryCode
         *        Amazon Route 53 uses the two-letter country codes that are specified in <a
         *        href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder countryCode(String countryCode);

        /**
         * <p>
         * Amazon Route 53 uses the one- to three-letter subdivision codes that are specified in <a
         * href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>. Amazon Route 53
         * doesn't support subdivision codes for all countries. If you specify <code>SubdivisionCode</code>, you must
         * also specify <code>CountryCode</code>.
         * </p>
         * 
         * @param subdivisionCode
         *        Amazon Route 53 uses the one- to three-letter subdivision codes that are specified in <a
         *        href="https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2">ISO standard 3166-1 alpha-2</a>. Amazon Route
         *        53 doesn't support subdivision codes for all countries. If you specify <code>SubdivisionCode</code>,
         *        you must also specify <code>CountryCode</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdivisionCode(String subdivisionCode);
    }

    private static final class BuilderImpl implements Builder {
        private String continentCode;

        private String countryCode;

        private String subdivisionCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGeoLocationRequest model) {
            setContinentCode(model.continentCode);
            setCountryCode(model.countryCode);
            setSubdivisionCode(model.subdivisionCode);
        }

        public final String getContinentCode() {
            return continentCode;
        }

        @Override
        public final Builder continentCode(String continentCode) {
            this.continentCode = continentCode;
            return this;
        }

        public final void setContinentCode(String continentCode) {
            this.continentCode = continentCode;
        }

        public final String getCountryCode() {
            return countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public final String getSubdivisionCode() {
            return subdivisionCode;
        }

        @Override
        public final Builder subdivisionCode(String subdivisionCode) {
            this.subdivisionCode = subdivisionCode;
            return this;
        }

        public final void setSubdivisionCode(String subdivisionCode) {
            this.subdivisionCode = subdivisionCode;
        }

        @Override
        public GetGeoLocationRequest build() {
            return new GetGeoLocationRequest(this);
        }
    }
}
