/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to get the status for a health check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetHealthCheckStatusRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetHealthCheckStatusRequest.Builder, GetHealthCheckStatusRequest> {
    private final String healthCheckId;

    private GetHealthCheckStatusRequest(BuilderImpl builder) {
        this.healthCheckId = builder.healthCheckId;
    }

    /**
     * <p>
     * The ID for the health check that you want the current status for. When you created the health check,
     * <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.
     * </p>
     * <note>
     * <p>
     * If you want to check the status of a calculated health check, you must use the Amazon Route 53 console or the
     * CloudWatch console. You can't use <code>GetHealthCheckStatus</code> to get the status of a calculated health
     * check.
     * </p>
     * </note>
     * 
     * @return The ID for the health check that you want the current status for. When you created the health check,
     *         <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code>
     *         element.</p> <note>
     *         <p>
     *         If you want to check the status of a calculated health check, you must use the Amazon Route 53 console or
     *         the CloudWatch console. You can't use <code>GetHealthCheckStatus</code> to get the status of a calculated
     *         health check.
     *         </p>
     */
    public String healthCheckId() {
        return healthCheckId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((healthCheckId() == null) ? 0 : healthCheckId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHealthCheckStatusRequest)) {
            return false;
        }
        GetHealthCheckStatusRequest other = (GetHealthCheckStatusRequest) obj;
        if (other.healthCheckId() == null ^ this.healthCheckId() == null) {
            return false;
        }
        if (other.healthCheckId() != null && !other.healthCheckId().equals(this.healthCheckId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (healthCheckId() != null) {
            sb.append("HealthCheckId: ").append(healthCheckId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetHealthCheckStatusRequest> {
        /**
         * <p>
         * The ID for the health check that you want the current status for. When you created the health check,
         * <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code> element.
         * </p>
         * <note>
         * <p>
         * If you want to check the status of a calculated health check, you must use the Amazon Route 53 console or the
         * CloudWatch console. You can't use <code>GetHealthCheckStatus</code> to get the status of a calculated health
         * check.
         * </p>
         * </note>
         * 
         * @param healthCheckId
         *        The ID for the health check that you want the current status for. When you created the health check,
         *        <code>CreateHealthCheck</code> returned the ID in the response, in the <code>HealthCheckId</code>
         *        element.</p> <note>
         *        <p>
         *        If you want to check the status of a calculated health check, you must use the Amazon Route 53 console
         *        or the CloudWatch console. You can't use <code>GetHealthCheckStatus</code> to get the status of a
         *        calculated health check.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckId(String healthCheckId);
    }

    private static final class BuilderImpl implements Builder {
        private String healthCheckId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHealthCheckStatusRequest model) {
            setHealthCheckId(model.healthCheckId);
        }

        public final String getHealthCheckId() {
            return healthCheckId;
        }

        @Override
        public final Builder healthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
            return this;
        }

        public final void setHealthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
        }

        @Override
        public GetHealthCheckStatusRequest build() {
            return new GetHealthCheckStatusRequest(this);
        }
    }
}
