/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response to a <code>GetHealthCheck</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetHealthCheckStatusResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetHealthCheckStatusResponse.Builder, GetHealthCheckStatusResponse> {
    private final List<HealthCheckObservation> healthCheckObservations;

    private GetHealthCheckStatusResponse(BuilderImpl builder) {
        this.healthCheckObservations = builder.healthCheckObservations;
    }

    /**
     * <p>
     * A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health checker that
     * is reporting a status about the health check endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health
     *         checker that is reporting a status about the health check endpoint.
     */
    public List<HealthCheckObservation> healthCheckObservations() {
        return healthCheckObservations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((healthCheckObservations() == null) ? 0 : healthCheckObservations().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHealthCheckStatusResponse)) {
            return false;
        }
        GetHealthCheckStatusResponse other = (GetHealthCheckStatusResponse) obj;
        if (other.healthCheckObservations() == null ^ this.healthCheckObservations() == null) {
            return false;
        }
        if (other.healthCheckObservations() != null && !other.healthCheckObservations().equals(this.healthCheckObservations())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (healthCheckObservations() != null) {
            sb.append("HealthCheckObservations: ").append(healthCheckObservations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetHealthCheckStatusResponse> {
        /**
         * <p>
         * A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health checker
         * that is reporting a status about the health check endpoint.
         * </p>
         * 
         * @param healthCheckObservations
         *        A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health
         *        checker that is reporting a status about the health check endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckObservations(Collection<HealthCheckObservation> healthCheckObservations);

        /**
         * <p>
         * A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health checker
         * that is reporting a status about the health check endpoint.
         * </p>
         * 
         * @param healthCheckObservations
         *        A list that contains one <code>HealthCheckObservation</code> element for each Amazon Route 53 health
         *        checker that is reporting a status about the health check endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckObservations(HealthCheckObservation... healthCheckObservations);
    }

    private static final class BuilderImpl implements Builder {
        private List<HealthCheckObservation> healthCheckObservations;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHealthCheckStatusResponse model) {
            setHealthCheckObservations(model.healthCheckObservations);
        }

        public final Collection<HealthCheckObservation> getHealthCheckObservations() {
            return healthCheckObservations;
        }

        @Override
        public final Builder healthCheckObservations(Collection<HealthCheckObservation> healthCheckObservations) {
            this.healthCheckObservations = HealthCheckObservationsCopier.copy(healthCheckObservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthCheckObservations(HealthCheckObservation... healthCheckObservations) {
            healthCheckObservations(Arrays.asList(healthCheckObservations));
            return this;
        }

        public final void setHealthCheckObservations(Collection<HealthCheckObservation> healthCheckObservations) {
            this.healthCheckObservations = HealthCheckObservationsCopier.copy(healthCheckObservations);
        }

        @SafeVarargs
        public final void setHealthCheckObservations(HealthCheckObservation... healthCheckObservations) {
            healthCheckObservations(Arrays.asList(healthCheckObservations));
        }

        @Override
        public GetHealthCheckStatusResponse build() {
            return new GetHealthCheckStatusResponse(this);
        }
    }
}
