/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the last failure reason as reported by one Amazon Route 53 health checker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class HealthCheckObservation implements ToCopyableBuilder<HealthCheckObservation.Builder, HealthCheckObservation> {
    private final String region;

    private final String ipAddress;

    private final StatusReport statusReport;

    private HealthCheckObservation(BuilderImpl builder) {
        this.region = builder.region;
        this.ipAddress = builder.ipAddress;
        this.statusReport = builder.statusReport;
    }

    /**
     * <p>
     * The region of the Amazon Route 53 health checker that provided the status in <code>StatusReport</code>.
     * </p>
     * 
     * @return The region of the Amazon Route 53 health checker that provided the status in <code>StatusReport</code>.
     * @see HealthCheckRegion
     */
    public String region() {
        return region;
    }

    /**
     * <p>
     * The IP address of the Amazon Route 53 health checker that provided the failure reason in
     * <code>StatusReport</code>.
     * </p>
     * 
     * @return The IP address of the Amazon Route 53 health checker that provided the failure reason in
     *         <code>StatusReport</code>.
     */
    public String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * A complex type that contains the last failure reason as reported by one Amazon Route 53 health checker and the
     * time of the failed health check.
     * </p>
     * 
     * @return A complex type that contains the last failure reason as reported by one Amazon Route 53 health checker
     *         and the time of the failed health check.
     */
    public StatusReport statusReport() {
        return statusReport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((region() == null) ? 0 : region().hashCode());
        hashCode = 31 * hashCode + ((ipAddress() == null) ? 0 : ipAddress().hashCode());
        hashCode = 31 * hashCode + ((statusReport() == null) ? 0 : statusReport().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckObservation)) {
            return false;
        }
        HealthCheckObservation other = (HealthCheckObservation) obj;
        if (other.region() == null ^ this.region() == null) {
            return false;
        }
        if (other.region() != null && !other.region().equals(this.region())) {
            return false;
        }
        if (other.ipAddress() == null ^ this.ipAddress() == null) {
            return false;
        }
        if (other.ipAddress() != null && !other.ipAddress().equals(this.ipAddress())) {
            return false;
        }
        if (other.statusReport() == null ^ this.statusReport() == null) {
            return false;
        }
        if (other.statusReport() != null && !other.statusReport().equals(this.statusReport())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (region() != null) {
            sb.append("Region: ").append(region()).append(",");
        }
        if (ipAddress() != null) {
            sb.append("IPAddress: ").append(ipAddress()).append(",");
        }
        if (statusReport() != null) {
            sb.append("StatusReport: ").append(statusReport()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, HealthCheckObservation> {
        /**
         * <p>
         * The region of the Amazon Route 53 health checker that provided the status in <code>StatusReport</code>.
         * </p>
         * 
         * @param region
         *        The region of the Amazon Route 53 health checker that provided the status in <code>StatusReport</code>
         *        .
         * @see HealthCheckRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthCheckRegion
         */
        Builder region(String region);

        /**
         * <p>
         * The region of the Amazon Route 53 health checker that provided the status in <code>StatusReport</code>.
         * </p>
         * 
         * @param region
         *        The region of the Amazon Route 53 health checker that provided the status in <code>StatusReport</code>
         *        .
         * @see HealthCheckRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthCheckRegion
         */
        Builder region(HealthCheckRegion region);

        /**
         * <p>
         * The IP address of the Amazon Route 53 health checker that provided the failure reason in
         * <code>StatusReport</code>.
         * </p>
         * 
         * @param ipAddress
         *        The IP address of the Amazon Route 53 health checker that provided the failure reason in
         *        <code>StatusReport</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * A complex type that contains the last failure reason as reported by one Amazon Route 53 health checker and
         * the time of the failed health check.
         * </p>
         * 
         * @param statusReport
         *        A complex type that contains the last failure reason as reported by one Amazon Route 53 health checker
         *        and the time of the failed health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReport(StatusReport statusReport);
    }

    private static final class BuilderImpl implements Builder {
        private String region;

        private String ipAddress;

        private StatusReport statusReport;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckObservation model) {
            setRegion(model.region);
            setIPAddress(model.ipAddress);
            setStatusReport(model.statusReport);
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public final Builder region(HealthCheckRegion region) {
            this.region(region.toString());
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final void setRegion(HealthCheckRegion region) {
            this.region(region.toString());
        }

        public final String getIPAddress() {
            return ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIPAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final StatusReport getStatusReport() {
            return statusReport;
        }

        @Override
        public final Builder statusReport(StatusReport statusReport) {
            this.statusReport = statusReport;
            return this;
        }

        public final void setStatusReport(StatusReport statusReport) {
            this.statusReport = statusReport;
        }

        @Override
        public HealthCheckObservation build() {
            return new HealthCheckObservation(this);
        }
    }
}
