/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTrafficPolicyVersionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListTrafficPolicyVersionsResponse.Builder, ListTrafficPolicyVersionsResponse> {
    private final List<TrafficPolicy> trafficPolicies;

    private final Boolean isTruncated;

    private final String trafficPolicyVersionMarker;

    private final String maxItems;

    private ListTrafficPolicyVersionsResponse(BuilderImpl builder) {
        this.trafficPolicies = builder.trafficPolicies;
        this.isTruncated = builder.isTruncated;
        this.trafficPolicyVersionMarker = builder.trafficPolicyVersionMarker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * A list that contains one <code>TrafficPolicy</code> element for each traffic policy version that is associated
     * with the specified traffic policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list that contains one <code>TrafficPolicy</code> element for each traffic policy version that is
     *         associated with the specified traffic policy.
     */
    public List<TrafficPolicy> trafficPolicies() {
        return trafficPolicies;
    }

    /**
     * <p>
     * A flag that indicates whether there are more traffic policies to be listed. If the response was truncated, you
     * can get the next group of traffic policies by submitting another <code>ListTrafficPolicyVersions</code> request
     * and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.
     * </p>
     * 
     * @return A flag that indicates whether there are more traffic policies to be listed. If the response was
     *         truncated, you can get the next group of traffic policies by submitting another
     *         <code>ListTrafficPolicyVersions</code> request and specifying the value of <code>NextMarker</code> in the
     *         <code>marker</code> parameter.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, the value of <code>TrafficPolicyVersionMarker</code> identifies
     * the first traffic policy that Amazon Route 53 will return if you submit another request. Call
     * <code>ListTrafficPolicyVersions</code> again and specify the value of <code>TrafficPolicyVersionMarker</code> in
     * the <code>TrafficPolicyVersionMarker</code> request parameter.
     * </p>
     * <p>
     * This element is present only if <code>IsTruncated</code> is <code>true</code>.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, the value of <code>TrafficPolicyVersionMarker</code>
     *         identifies the first traffic policy that Amazon Route 53 will return if you submit another request. Call
     *         <code>ListTrafficPolicyVersions</code> again and specify the value of
     *         <code>TrafficPolicyVersionMarker</code> in the <code>TrafficPolicyVersionMarker</code> request
     *         parameter.</p>
     *         <p>
     *         This element is present only if <code>IsTruncated</code> is <code>true</code>.
     */
    public String trafficPolicyVersionMarker() {
        return trafficPolicyVersionMarker;
    }

    /**
     * <p>
     * The value that you specified for the <code>maxitems</code> parameter in the
     * <code>ListTrafficPolicyVersions</code> request that produced the current response.
     * </p>
     * 
     * @return The value that you specified for the <code>maxitems</code> parameter in the
     *         <code>ListTrafficPolicyVersions</code> request that produced the current response.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((trafficPolicies() == null) ? 0 : trafficPolicies().hashCode());
        hashCode = 31 * hashCode + ((isTruncated() == null) ? 0 : isTruncated().hashCode());
        hashCode = 31 * hashCode + ((trafficPolicyVersionMarker() == null) ? 0 : trafficPolicyVersionMarker().hashCode());
        hashCode = 31 * hashCode + ((maxItems() == null) ? 0 : maxItems().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPolicyVersionsResponse)) {
            return false;
        }
        ListTrafficPolicyVersionsResponse other = (ListTrafficPolicyVersionsResponse) obj;
        if (other.trafficPolicies() == null ^ this.trafficPolicies() == null) {
            return false;
        }
        if (other.trafficPolicies() != null && !other.trafficPolicies().equals(this.trafficPolicies())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.trafficPolicyVersionMarker() == null ^ this.trafficPolicyVersionMarker() == null) {
            return false;
        }
        if (other.trafficPolicyVersionMarker() != null
                && !other.trafficPolicyVersionMarker().equals(this.trafficPolicyVersionMarker())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (trafficPolicies() != null) {
            sb.append("TrafficPolicies: ").append(trafficPolicies()).append(",");
        }
        if (isTruncated() != null) {
            sb.append("IsTruncated: ").append(isTruncated()).append(",");
        }
        if (trafficPolicyVersionMarker() != null) {
            sb.append("TrafficPolicyVersionMarker: ").append(trafficPolicyVersionMarker()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListTrafficPolicyVersionsResponse> {
        /**
         * <p>
         * A list that contains one <code>TrafficPolicy</code> element for each traffic policy version that is
         * associated with the specified traffic policy.
         * </p>
         * 
         * @param trafficPolicies
         *        A list that contains one <code>TrafficPolicy</code> element for each traffic policy version that is
         *        associated with the specified traffic policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicies(Collection<TrafficPolicy> trafficPolicies);

        /**
         * <p>
         * A list that contains one <code>TrafficPolicy</code> element for each traffic policy version that is
         * associated with the specified traffic policy.
         * </p>
         * 
         * @param trafficPolicies
         *        A list that contains one <code>TrafficPolicy</code> element for each traffic policy version that is
         *        associated with the specified traffic policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicies(TrafficPolicy... trafficPolicies);

        /**
         * <p>
         * A flag that indicates whether there are more traffic policies to be listed. If the response was truncated,
         * you can get the next group of traffic policies by submitting another <code>ListTrafficPolicyVersions</code>
         * request and specifying the value of <code>NextMarker</code> in the <code>marker</code> parameter.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more traffic policies to be listed. If the response was
         *        truncated, you can get the next group of traffic policies by submitting another
         *        <code>ListTrafficPolicyVersions</code> request and specifying the value of <code>NextMarker</code> in
         *        the <code>marker</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, the value of <code>TrafficPolicyVersionMarker</code>
         * identifies the first traffic policy that Amazon Route 53 will return if you submit another request. Call
         * <code>ListTrafficPolicyVersions</code> again and specify the value of <code>TrafficPolicyVersionMarker</code>
         * in the <code>TrafficPolicyVersionMarker</code> request parameter.
         * </p>
         * <p>
         * This element is present only if <code>IsTruncated</code> is <code>true</code>.
         * </p>
         * 
         * @param trafficPolicyVersionMarker
         *        If <code>IsTruncated</code> is <code>true</code>, the value of <code>TrafficPolicyVersionMarker</code>
         *        identifies the first traffic policy that Amazon Route 53 will return if you submit another request.
         *        Call <code>ListTrafficPolicyVersions</code> again and specify the value of
         *        <code>TrafficPolicyVersionMarker</code> in the <code>TrafficPolicyVersionMarker</code> request
         *        parameter.</p>
         *        <p>
         *        This element is present only if <code>IsTruncated</code> is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyVersionMarker(String trafficPolicyVersionMarker);

        /**
         * <p>
         * The value that you specified for the <code>maxitems</code> parameter in the
         * <code>ListTrafficPolicyVersions</code> request that produced the current response.
         * </p>
         * 
         * @param maxItems
         *        The value that you specified for the <code>maxitems</code> parameter in the
         *        <code>ListTrafficPolicyVersions</code> request that produced the current response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    private static final class BuilderImpl implements Builder {
        private List<TrafficPolicy> trafficPolicies;

        private Boolean isTruncated;

        private String trafficPolicyVersionMarker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPolicyVersionsResponse model) {
            setTrafficPolicies(model.trafficPolicies);
            setIsTruncated(model.isTruncated);
            setTrafficPolicyVersionMarker(model.trafficPolicyVersionMarker);
            setMaxItems(model.maxItems);
        }

        public final Collection<TrafficPolicy> getTrafficPolicies() {
            return trafficPolicies;
        }

        @Override
        public final Builder trafficPolicies(Collection<TrafficPolicy> trafficPolicies) {
            this.trafficPolicies = TrafficPoliciesCopier.copy(trafficPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficPolicies(TrafficPolicy... trafficPolicies) {
            trafficPolicies(Arrays.asList(trafficPolicies));
            return this;
        }

        public final void setTrafficPolicies(Collection<TrafficPolicy> trafficPolicies) {
            this.trafficPolicies = TrafficPoliciesCopier.copy(trafficPolicies);
        }

        @SafeVarargs
        public final void setTrafficPolicies(TrafficPolicy... trafficPolicies) {
            trafficPolicies(Arrays.asList(trafficPolicies));
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getTrafficPolicyVersionMarker() {
            return trafficPolicyVersionMarker;
        }

        @Override
        public final Builder trafficPolicyVersionMarker(String trafficPolicyVersionMarker) {
            this.trafficPolicyVersionMarker = trafficPolicyVersionMarker;
            return this;
        }

        public final void setTrafficPolicyVersionMarker(String trafficPolicyVersionMarker) {
            this.trafficPolicyVersionMarker = trafficPolicyVersionMarker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListTrafficPolicyVersionsResponse build() {
            return new ListTrafficPolicyVersionsResponse(this);
        }
    }
}
