/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and type. You
 * can optionally specify the IP address of a DNS resolver, an EDNS0 client subnet IP address, and a subnet mask.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TestDNSAnswerRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<TestDNSAnswerRequest.Builder, TestDNSAnswerRequest> {
    private final String hostedZoneId;

    private final String recordName;

    private final String recordType;

    private final String resolverIP;

    private final String edns0ClientSubnetIP;

    private final String edns0ClientSubnetMask;

    private TestDNSAnswerRequest(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
        this.recordName = builder.recordName;
        this.recordType = builder.recordType;
        this.resolverIP = builder.resolverIP;
        this.edns0ClientSubnetIP = builder.edns0ClientSubnetIP;
        this.edns0ClientSubnetMask = builder.edns0ClientSubnetMask;
    }

    /**
     * <p>
     * The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.
     * </p>
     * 
     * @return The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.
     */
    public String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The name of the resource record set that you want Amazon Route 53 to simulate a query for.
     * </p>
     * 
     * @return The name of the resource record set that you want Amazon Route 53 to simulate a query for.
     */
    public String recordName() {
        return recordName;
    }

    /**
     * <p>
     * The type of the resource record set.
     * </p>
     * 
     * @return The type of the resource record set.
     * @see RRType
     */
    public String recordType() {
        return recordType;
    }

    /**
     * <p>
     * If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver. If you
     * omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in the AWS US East (N.
     * Virginia) Region (<code>us-east-1</code>).
     * </p>
     * 
     * @return If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver.
     *         If you omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in the AWS US
     *         East (N. Virginia) Region (<code>us-east-1</code>).
     */
    public String resolverIP() {
        return resolverIP;
    }

    /**
     * <p>
     * If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a client in
     * the applicable location, for example, <code>192.0.2.44</code> or <code>2001:db8:85a3::8a2e:370:7334</code>.
     * </p>
     * 
     * @return If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a
     *         client in the applicable location, for example, <code>192.0.2.44</code> or
     *         <code>2001:db8:85a3::8a2e:370:7334</code>.
     */
    public String edns0ClientSubnetIP() {
        return edns0ClientSubnetIP;
    }

    /**
     * <p>
     * If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the number of bits
     * of the IP address that you want the checking tool to include in the DNS query. For example, if you specify
     * <code>192.0.2.44</code> for <code>edns0clientsubnetip</code> and <code>24</code> for
     * <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from 192.0.2.0/24. The default
     * value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.
     * </p>
     * 
     * @return If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the number
     *         of bits of the IP address that you want the checking tool to include in the DNS query. For example, if
     *         you specify <code>192.0.2.44</code> for <code>edns0clientsubnetip</code> and <code>24</code> for
     *         <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from 192.0.2.0/24. The
     *         default value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.
     */
    public String edns0ClientSubnetMask() {
        return edns0ClientSubnetMask;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((hostedZoneId() == null) ? 0 : hostedZoneId().hashCode());
        hashCode = 31 * hashCode + ((recordName() == null) ? 0 : recordName().hashCode());
        hashCode = 31 * hashCode + ((recordType() == null) ? 0 : recordType().hashCode());
        hashCode = 31 * hashCode + ((resolverIP() == null) ? 0 : resolverIP().hashCode());
        hashCode = 31 * hashCode + ((edns0ClientSubnetIP() == null) ? 0 : edns0ClientSubnetIP().hashCode());
        hashCode = 31 * hashCode + ((edns0ClientSubnetMask() == null) ? 0 : edns0ClientSubnetMask().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestDNSAnswerRequest)) {
            return false;
        }
        TestDNSAnswerRequest other = (TestDNSAnswerRequest) obj;
        if (other.hostedZoneId() == null ^ this.hostedZoneId() == null) {
            return false;
        }
        if (other.hostedZoneId() != null && !other.hostedZoneId().equals(this.hostedZoneId())) {
            return false;
        }
        if (other.recordName() == null ^ this.recordName() == null) {
            return false;
        }
        if (other.recordName() != null && !other.recordName().equals(this.recordName())) {
            return false;
        }
        if (other.recordType() == null ^ this.recordType() == null) {
            return false;
        }
        if (other.recordType() != null && !other.recordType().equals(this.recordType())) {
            return false;
        }
        if (other.resolverIP() == null ^ this.resolverIP() == null) {
            return false;
        }
        if (other.resolverIP() != null && !other.resolverIP().equals(this.resolverIP())) {
            return false;
        }
        if (other.edns0ClientSubnetIP() == null ^ this.edns0ClientSubnetIP() == null) {
            return false;
        }
        if (other.edns0ClientSubnetIP() != null && !other.edns0ClientSubnetIP().equals(this.edns0ClientSubnetIP())) {
            return false;
        }
        if (other.edns0ClientSubnetMask() == null ^ this.edns0ClientSubnetMask() == null) {
            return false;
        }
        if (other.edns0ClientSubnetMask() != null && !other.edns0ClientSubnetMask().equals(this.edns0ClientSubnetMask())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(hostedZoneId()).append(",");
        }
        if (recordName() != null) {
            sb.append("RecordName: ").append(recordName()).append(",");
        }
        if (recordType() != null) {
            sb.append("RecordType: ").append(recordType()).append(",");
        }
        if (resolverIP() != null) {
            sb.append("ResolverIP: ").append(resolverIP()).append(",");
        }
        if (edns0ClientSubnetIP() != null) {
            sb.append("EDNS0ClientSubnetIP: ").append(edns0ClientSubnetIP()).append(",");
        }
        if (edns0ClientSubnetMask() != null) {
            sb.append("EDNS0ClientSubnetMask: ").append(edns0ClientSubnetMask()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, TestDNSAnswerRequest> {
        /**
         * <p>
         * The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of the hosted zone that you want Amazon Route 53 to simulate a query for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The name of the resource record set that you want Amazon Route 53 to simulate a query for.
         * </p>
         * 
         * @param recordName
         *        The name of the resource record set that you want Amazon Route 53 to simulate a query for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordName(String recordName);

        /**
         * <p>
         * The type of the resource record set.
         * </p>
         * 
         * @param recordType
         *        The type of the resource record set.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder recordType(String recordType);

        /**
         * <p>
         * The type of the resource record set.
         * </p>
         * 
         * @param recordType
         *        The type of the resource record set.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder recordType(RRType recordType);

        /**
         * <p>
         * If you want to simulate a request from a specific DNS resolver, specify the IP address for that resolver. If
         * you omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in the AWS US East (N.
         * Virginia) Region (<code>us-east-1</code>).
         * </p>
         * 
         * @param resolverIP
         *        If you want to simulate a request from a specific DNS resolver, specify the IP address for that
         *        resolver. If you omit this value, <code>TestDnsAnswer</code> uses the IP address of a DNS resolver in
         *        the AWS US East (N. Virginia) Region (<code>us-east-1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverIP(String resolverIP);

        /**
         * <p>
         * If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of a
         * client in the applicable location, for example, <code>192.0.2.44</code> or
         * <code>2001:db8:85a3::8a2e:370:7334</code>.
         * </p>
         * 
         * @param edns0ClientSubnetIP
         *        If the resolver that you specified for resolverip supports EDNS0, specify the IPv4 or IPv6 address of
         *        a client in the applicable location, for example, <code>192.0.2.44</code> or
         *        <code>2001:db8:85a3::8a2e:370:7334</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edns0ClientSubnetIP(String edns0ClientSubnetIP);

        /**
         * <p>
         * If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the number of
         * bits of the IP address that you want the checking tool to include in the DNS query. For example, if you
         * specify <code>192.0.2.44</code> for <code>edns0clientsubnetip</code> and <code>24</code> for
         * <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from 192.0.2.0/24. The default
         * value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.
         * </p>
         * 
         * @param edns0ClientSubnetMask
         *        If you specify an IP address for <code>edns0clientsubnetip</code>, you can optionally specify the
         *        number of bits of the IP address that you want the checking tool to include in the DNS query. For
         *        example, if you specify <code>192.0.2.44</code> for <code>edns0clientsubnetip</code> and
         *        <code>24</code> for <code>edns0clientsubnetmask</code>, the checking tool will simulate a request from
         *        192.0.2.0/24. The default value is 24 bits for IPv4 addresses and 64 bits for IPv6 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edns0ClientSubnetMask(String edns0ClientSubnetMask);
    }

    private static final class BuilderImpl implements Builder {
        private String hostedZoneId;

        private String recordName;

        private String recordType;

        private String resolverIP;

        private String edns0ClientSubnetIP;

        private String edns0ClientSubnetMask;

        private BuilderImpl() {
        }

        private BuilderImpl(TestDNSAnswerRequest model) {
            setHostedZoneId(model.hostedZoneId);
            setRecordName(model.recordName);
            setRecordType(model.recordType);
            setResolverIP(model.resolverIP);
            setEDNS0ClientSubnetIP(model.edns0ClientSubnetIP);
            setEDNS0ClientSubnetMask(model.edns0ClientSubnetMask);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getRecordName() {
            return recordName;
        }

        @Override
        public final Builder recordName(String recordName) {
            this.recordName = recordName;
            return this;
        }

        public final void setRecordName(String recordName) {
            this.recordName = recordName;
        }

        public final String getRecordType() {
            return recordType;
        }

        @Override
        public final Builder recordType(String recordType) {
            this.recordType = recordType;
            return this;
        }

        @Override
        public final Builder recordType(RRType recordType) {
            this.recordType(recordType.toString());
            return this;
        }

        public final void setRecordType(String recordType) {
            this.recordType = recordType;
        }

        public final void setRecordType(RRType recordType) {
            this.recordType(recordType.toString());
        }

        public final String getResolverIP() {
            return resolverIP;
        }

        @Override
        public final Builder resolverIP(String resolverIP) {
            this.resolverIP = resolverIP;
            return this;
        }

        public final void setResolverIP(String resolverIP) {
            this.resolverIP = resolverIP;
        }

        public final String getEDNS0ClientSubnetIP() {
            return edns0ClientSubnetIP;
        }

        @Override
        public final Builder edns0ClientSubnetIP(String edns0ClientSubnetIP) {
            this.edns0ClientSubnetIP = edns0ClientSubnetIP;
            return this;
        }

        public final void setEDNS0ClientSubnetIP(String edns0ClientSubnetIP) {
            this.edns0ClientSubnetIP = edns0ClientSubnetIP;
        }

        public final String getEDNS0ClientSubnetMask() {
            return edns0ClientSubnetMask;
        }

        @Override
        public final Builder edns0ClientSubnetMask(String edns0ClientSubnetMask) {
            this.edns0ClientSubnetMask = edns0ClientSubnetMask;
            return this;
        }

        public final void setEDNS0ClientSubnetMask(String edns0ClientSubnetMask) {
            this.edns0ClientSubnetMask = edns0ClientSubnetMask;
        }

        @Override
        public TestDNSAnswerRequest build() {
            return new TestDNSAnswerRequest(this);
        }
    }
}
