/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response to a <code>TestDNSAnswer</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TestDNSAnswerResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<TestDNSAnswerResponse.Builder, TestDNSAnswerResponse> {
    private final String nameserver;

    private final String recordName;

    private final String recordType;

    private final List<String> recordData;

    private final String responseCode;

    private final String protocol;

    private TestDNSAnswerResponse(BuilderImpl builder) {
        this.nameserver = builder.nameserver;
        this.recordName = builder.recordName;
        this.recordType = builder.recordType;
        this.recordData = builder.recordData;
        this.responseCode = builder.responseCode;
        this.protocol = builder.protocol;
    }

    /**
     * <p>
     * The Amazon Route 53 name server used to respond to the request.
     * </p>
     * 
     * @return The Amazon Route 53 name server used to respond to the request.
     */
    public String nameserver() {
        return nameserver;
    }

    /**
     * <p>
     * The name of the resource record set that you submitted a request for.
     * </p>
     * 
     * @return The name of the resource record set that you submitted a request for.
     */
    public String recordName() {
        return recordName;
    }

    /**
     * <p>
     * The type of the resource record set that you submitted a request for.
     * </p>
     * 
     * @return The type of the resource record set that you submitted a request for.
     * @see RRType
     */
    public String recordType() {
        return recordType;
    }

    /**
     * <p>
     * A list that contains values that Amazon Route 53 returned for this resource record set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list that contains values that Amazon Route 53 returned for this resource record set.
     */
    public List<String> recordData() {
        return recordData;
    }

    /**
     * <p>
     * A code that indicates whether the request is valid or not. The most common response code is <code>NOERROR</code>,
     * meaning that the request is valid. If the response is not valid, Amazon Route 53 returns a response code that
     * describes the error. For a list of possible response codes, see <a
     * href="http://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-6">DNS RCODES</a> on the
     * IANA website.
     * </p>
     * 
     * @return A code that indicates whether the request is valid or not. The most common response code is
     *         <code>NOERROR</code>, meaning that the request is valid. If the response is not valid, Amazon Route 53
     *         returns a response code that describes the error. For a list of possible response codes, see <a
     *         href="http://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-6">DNS
     *         RCODES</a> on the IANA website.
     */
    public String responseCode() {
        return responseCode;
    }

    /**
     * <p>
     * The protocol that Amazon Route 53 used to respond to the request, either <code>UDP</code> or <code>TCP</code>.
     * </p>
     * 
     * @return The protocol that Amazon Route 53 used to respond to the request, either <code>UDP</code> or
     *         <code>TCP</code>.
     */
    public String protocol() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((nameserver() == null) ? 0 : nameserver().hashCode());
        hashCode = 31 * hashCode + ((recordName() == null) ? 0 : recordName().hashCode());
        hashCode = 31 * hashCode + ((recordType() == null) ? 0 : recordType().hashCode());
        hashCode = 31 * hashCode + ((recordData() == null) ? 0 : recordData().hashCode());
        hashCode = 31 * hashCode + ((responseCode() == null) ? 0 : responseCode().hashCode());
        hashCode = 31 * hashCode + ((protocol() == null) ? 0 : protocol().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestDNSAnswerResponse)) {
            return false;
        }
        TestDNSAnswerResponse other = (TestDNSAnswerResponse) obj;
        if (other.nameserver() == null ^ this.nameserver() == null) {
            return false;
        }
        if (other.nameserver() != null && !other.nameserver().equals(this.nameserver())) {
            return false;
        }
        if (other.recordName() == null ^ this.recordName() == null) {
            return false;
        }
        if (other.recordName() != null && !other.recordName().equals(this.recordName())) {
            return false;
        }
        if (other.recordType() == null ^ this.recordType() == null) {
            return false;
        }
        if (other.recordType() != null && !other.recordType().equals(this.recordType())) {
            return false;
        }
        if (other.recordData() == null ^ this.recordData() == null) {
            return false;
        }
        if (other.recordData() != null && !other.recordData().equals(this.recordData())) {
            return false;
        }
        if (other.responseCode() == null ^ this.responseCode() == null) {
            return false;
        }
        if (other.responseCode() != null && !other.responseCode().equals(this.responseCode())) {
            return false;
        }
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        if (other.protocol() != null && !other.protocol().equals(this.protocol())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (nameserver() != null) {
            sb.append("Nameserver: ").append(nameserver()).append(",");
        }
        if (recordName() != null) {
            sb.append("RecordName: ").append(recordName()).append(",");
        }
        if (recordType() != null) {
            sb.append("RecordType: ").append(recordType()).append(",");
        }
        if (recordData() != null) {
            sb.append("RecordData: ").append(recordData()).append(",");
        }
        if (responseCode() != null) {
            sb.append("ResponseCode: ").append(responseCode()).append(",");
        }
        if (protocol() != null) {
            sb.append("Protocol: ").append(protocol()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, TestDNSAnswerResponse> {
        /**
         * <p>
         * The Amazon Route 53 name server used to respond to the request.
         * </p>
         * 
         * @param nameserver
         *        The Amazon Route 53 name server used to respond to the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameserver(String nameserver);

        /**
         * <p>
         * The name of the resource record set that you submitted a request for.
         * </p>
         * 
         * @param recordName
         *        The name of the resource record set that you submitted a request for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordName(String recordName);

        /**
         * <p>
         * The type of the resource record set that you submitted a request for.
         * </p>
         * 
         * @param recordType
         *        The type of the resource record set that you submitted a request for.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder recordType(String recordType);

        /**
         * <p>
         * The type of the resource record set that you submitted a request for.
         * </p>
         * 
         * @param recordType
         *        The type of the resource record set that you submitted a request for.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder recordType(RRType recordType);

        /**
         * <p>
         * A list that contains values that Amazon Route 53 returned for this resource record set.
         * </p>
         * 
         * @param recordData
         *        A list that contains values that Amazon Route 53 returned for this resource record set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordData(Collection<String> recordData);

        /**
         * <p>
         * A list that contains values that Amazon Route 53 returned for this resource record set.
         * </p>
         * 
         * @param recordData
         *        A list that contains values that Amazon Route 53 returned for this resource record set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordData(String... recordData);

        /**
         * <p>
         * A code that indicates whether the request is valid or not. The most common response code is
         * <code>NOERROR</code>, meaning that the request is valid. If the response is not valid, Amazon Route 53
         * returns a response code that describes the error. For a list of possible response codes, see <a
         * href="http://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-6">DNS RCODES</a> on
         * the IANA website.
         * </p>
         * 
         * @param responseCode
         *        A code that indicates whether the request is valid or not. The most common response code is
         *        <code>NOERROR</code>, meaning that the request is valid. If the response is not valid, Amazon Route 53
         *        returns a response code that describes the error. For a list of possible response codes, see <a
         *        href="http://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml#dns-parameters-6">DNS
         *        RCODES</a> on the IANA website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseCode(String responseCode);

        /**
         * <p>
         * The protocol that Amazon Route 53 used to respond to the request, either <code>UDP</code> or <code>TCP</code>
         * .
         * </p>
         * 
         * @param protocol
         *        The protocol that Amazon Route 53 used to respond to the request, either <code>UDP</code> or
         *        <code>TCP</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);
    }

    private static final class BuilderImpl implements Builder {
        private String nameserver;

        private String recordName;

        private String recordType;

        private List<String> recordData;

        private String responseCode;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(TestDNSAnswerResponse model) {
            setNameserver(model.nameserver);
            setRecordName(model.recordName);
            setRecordType(model.recordType);
            setRecordData(model.recordData);
            setResponseCode(model.responseCode);
            setProtocol(model.protocol);
        }

        public final String getNameserver() {
            return nameserver;
        }

        @Override
        public final Builder nameserver(String nameserver) {
            this.nameserver = nameserver;
            return this;
        }

        public final void setNameserver(String nameserver) {
            this.nameserver = nameserver;
        }

        public final String getRecordName() {
            return recordName;
        }

        @Override
        public final Builder recordName(String recordName) {
            this.recordName = recordName;
            return this;
        }

        public final void setRecordName(String recordName) {
            this.recordName = recordName;
        }

        public final String getRecordType() {
            return recordType;
        }

        @Override
        public final Builder recordType(String recordType) {
            this.recordType = recordType;
            return this;
        }

        @Override
        public final Builder recordType(RRType recordType) {
            this.recordType(recordType.toString());
            return this;
        }

        public final void setRecordType(String recordType) {
            this.recordType = recordType;
        }

        public final void setRecordType(RRType recordType) {
            this.recordType(recordType.toString());
        }

        public final Collection<String> getRecordData() {
            return recordData;
        }

        @Override
        public final Builder recordData(Collection<String> recordData) {
            this.recordData = RecordDataCopier.copy(recordData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordData(String... recordData) {
            recordData(Arrays.asList(recordData));
            return this;
        }

        public final void setRecordData(Collection<String> recordData) {
            this.recordData = RecordDataCopier.copy(recordData);
        }

        @SafeVarargs
        public final void setRecordData(String... recordData) {
            recordData(Arrays.asList(recordData));
        }

        public final String getResponseCode() {
            return responseCode;
        }

        @Override
        public final Builder responseCode(String responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final void setResponseCode(String responseCode) {
            this.responseCode = responseCode;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public TestDNSAnswerResponse build() {
            return new TestDNSAnswerResponse(this);
        }
    }
}
