/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the traffic policy that you want to update the comment for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateTrafficPolicyCommentRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateTrafficPolicyCommentRequest.Builder, UpdateTrafficPolicyCommentRequest> {
    private final String id;

    private final Integer version;

    private final String comment;

    private UpdateTrafficPolicyCommentRequest(BuilderImpl builder) {
        this.id = builder.id;
        this.version = builder.version;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The value of <code>Id</code> for the traffic policy that you want to update the comment for.
     * </p>
     * 
     * @return The value of <code>Id</code> for the traffic policy that you want to update the comment for.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The value of <code>Version</code> for the traffic policy that you want to update the comment for.
     * </p>
     * 
     * @return The value of <code>Version</code> for the traffic policy that you want to update the comment for.
     */
    public Integer version() {
        return version;
    }

    /**
     * <p>
     * The new comment for the specified traffic policy and version.
     * </p>
     * 
     * @return The new comment for the specified traffic policy and version.
     */
    public String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((version() == null) ? 0 : version().hashCode());
        hashCode = 31 * hashCode + ((comment() == null) ? 0 : comment().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTrafficPolicyCommentRequest)) {
            return false;
        }
        UpdateTrafficPolicyCommentRequest other = (UpdateTrafficPolicyCommentRequest) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        if (other.comment() != null && !other.comment().equals(this.comment())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (version() != null) {
            sb.append("Version: ").append(version()).append(",");
        }
        if (comment() != null) {
            sb.append("Comment: ").append(comment()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateTrafficPolicyCommentRequest> {
        /**
         * <p>
         * The value of <code>Id</code> for the traffic policy that you want to update the comment for.
         * </p>
         * 
         * @param id
         *        The value of <code>Id</code> for the traffic policy that you want to update the comment for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The value of <code>Version</code> for the traffic policy that you want to update the comment for.
         * </p>
         * 
         * @param version
         *        The value of <code>Version</code> for the traffic policy that you want to update the comment for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);

        /**
         * <p>
         * The new comment for the specified traffic policy and version.
         * </p>
         * 
         * @param comment
         *        The new comment for the specified traffic policy and version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private Integer version;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTrafficPolicyCommentRequest model) {
            setId(model.id);
            setVersion(model.version);
            setComment(model.comment);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Integer getVersion() {
            return version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public UpdateTrafficPolicyCommentRequest build() {
            return new UpdateTrafficPolicyCommentRequest(this);
        }
    }
}
