/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * (Private hosted zones only) A complex type that contains information about an Amazon VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VPC implements ToCopyableBuilder<VPC.Builder, VPC> {
    private final String vpcRegion;

    private final String vpcId;

    private VPC(BuilderImpl builder) {
        this.vpcRegion = builder.vpcRegion;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * (Private hosted zones only) The region in which you created an Amazon VPC.
     * </p>
     * 
     * @return (Private hosted zones only) The region in which you created an Amazon VPC.
     * @see VPCRegion
     */
    public String vpcRegion() {
        return vpcRegion;
    }

    /**
     * Returns the value of the VPCId property for this object.
     * 
     * @return The value of the VPCId property for this object.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((vpcRegion() == null) ? 0 : vpcRegion().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VPC)) {
            return false;
        }
        VPC other = (VPC) obj;
        if (other.vpcRegion() == null ^ this.vpcRegion() == null) {
            return false;
        }
        if (other.vpcRegion() != null && !other.vpcRegion().equals(this.vpcRegion())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (vpcRegion() != null) {
            sb.append("VPCRegion: ").append(vpcRegion()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VPCId: ").append(vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, VPC> {
        /**
         * <p>
         * (Private hosted zones only) The region in which you created an Amazon VPC.
         * </p>
         * 
         * @param vpcRegion
         *        (Private hosted zones only) The region in which you created an Amazon VPC.
         * @see VPCRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VPCRegion
         */
        Builder vpcRegion(String vpcRegion);

        /**
         * <p>
         * (Private hosted zones only) The region in which you created an Amazon VPC.
         * </p>
         * 
         * @param vpcRegion
         *        (Private hosted zones only) The region in which you created an Amazon VPC.
         * @see VPCRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VPCRegion
         */
        Builder vpcRegion(VPCRegion vpcRegion);

        /**
         * Sets the value of the VPCId property for this object.
         *
         * @param vpcId
         *        The new value for the VPCId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    private static final class BuilderImpl implements Builder {
        private String vpcRegion;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(VPC model) {
            setVPCRegion(model.vpcRegion);
            setVPCId(model.vpcId);
        }

        public final String getVPCRegion() {
            return vpcRegion;
        }

        @Override
        public final Builder vpcRegion(String vpcRegion) {
            this.vpcRegion = vpcRegion;
            return this;
        }

        @Override
        public final Builder vpcRegion(VPCRegion vpcRegion) {
            this.vpcRegion(vpcRegion.toString());
            return this;
        }

        public final void setVPCRegion(String vpcRegion) {
            this.vpcRegion = vpcRegion;
        }

        public final void setVPCRegion(VPCRegion vpcRegion) {
            this.vpcRegion(vpcRegion.toString());
        }

        public final String getVPCId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVPCId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public VPC build() {
            return new VPC(this);
        }
    }
}
