/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * CloudWatchAlarmConfiguration StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CloudWatchAlarmConfigurationUnmarshaller implements
        Unmarshaller<CloudWatchAlarmConfiguration, StaxUnmarshallerContext> {

    public CloudWatchAlarmConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        CloudWatchAlarmConfiguration.Builder cloudWatchAlarmConfiguration = CloudWatchAlarmConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<Dimension> dimensions = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                cloudWatchAlarmConfiguration.dimensions(dimensions);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("EvaluationPeriods", targetDepth)) {
                    cloudWatchAlarmConfiguration.evaluationPeriods(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Threshold", targetDepth)) {
                    cloudWatchAlarmConfiguration.threshold(DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ComparisonOperator", targetDepth)) {
                    cloudWatchAlarmConfiguration.comparisonOperator(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Period", targetDepth)) {
                    cloudWatchAlarmConfiguration.period(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MetricName", targetDepth)) {
                    cloudWatchAlarmConfiguration.metricName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Namespace", targetDepth)) {
                    cloudWatchAlarmConfiguration.namespace(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Statistic", targetDepth)) {
                    cloudWatchAlarmConfiguration.statistic(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Dimensions", targetDepth)) {
                    dimensions = new ArrayList<Dimension>();
                    continue;
                }

                if (context.testExpression("Dimensions/Dimension", targetDepth)) {
                    dimensions.add(DimensionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    cloudWatchAlarmConfiguration.dimensions(dimensions);
                    break;
                }
            }
        }
        return cloudWatchAlarmConfiguration.build();
    }

    private static CloudWatchAlarmConfigurationUnmarshaller INSTANCE;

    public static CloudWatchAlarmConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new CloudWatchAlarmConfigurationUnmarshaller();
        return INSTANCE;
    }
}
