/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListGeoLocationsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListGeoLocationsResponseUnmarshaller implements Unmarshaller<ListGeoLocationsResponse, StaxUnmarshallerContext> {

    public ListGeoLocationsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListGeoLocationsResponse.Builder listGeoLocationsResponse = ListGeoLocationsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<GeoLocationDetails> geoLocationDetailsList = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listGeoLocationsResponse.geoLocationDetailsList(geoLocationDetailsList);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("GeoLocationDetailsList", targetDepth)) {
                    geoLocationDetailsList = new ArrayList<GeoLocationDetails>();
                    continue;
                }

                if (context.testExpression("GeoLocationDetailsList/GeoLocationDetails", targetDepth)) {
                    geoLocationDetailsList.add(GeoLocationDetailsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("IsTruncated", targetDepth)) {
                    listGeoLocationsResponse.isTruncated(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextContinentCode", targetDepth)) {
                    listGeoLocationsResponse.nextContinentCode(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextCountryCode", targetDepth)) {
                    listGeoLocationsResponse.nextCountryCode(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextSubdivisionCode", targetDepth)) {
                    listGeoLocationsResponse.nextSubdivisionCode(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MaxItems", targetDepth)) {
                    listGeoLocationsResponse.maxItems(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listGeoLocationsResponse.geoLocationDetailsList(geoLocationDetailsList);
                    break;
                }
            }
        }
        return listGeoLocationsResponse.build();
    }

    private static ListGeoLocationsResponseUnmarshaller INSTANCE;

    public static ListGeoLocationsResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ListGeoLocationsResponseUnmarshaller();
        return INSTANCE;
    }
}
