/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import static software.amazon.awssdk.util.StringUtils.UTF8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;

import software.amazon.awssdk.util.StringInputStream;

import software.amazon.awssdk.util.XmlWriter;

/**
 * ListTagsForResourcesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListTagsForResourcesRequestMarshaller implements
        Marshaller<Request<ListTagsForResourcesRequest>, ListTagsForResourcesRequest> {

    public Request<ListTagsForResourcesRequest> marshall(ListTagsForResourcesRequest listTagsForResourcesRequest) {

        if (listTagsForResourcesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ListTagsForResourcesRequest> request = new DefaultRequest<ListTagsForResourcesRequest>(
                listTagsForResourcesRequest, "Route53Client");

        request.setHttpMethod(HttpMethodName.POST);

        String uriResourcePath = "/2013-04-01/tags/{ResourceType}";

        uriResourcePath = software.amazon.awssdk.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "ResourceType", listTagsForResourcesRequest.resourceType());
        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter(stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");

            xmlWriter.startElement("ListTagsForResourcesRequest");
            if (listTagsForResourcesRequest != null) {

                java.util.List<String> listTagsForResourcesRequestResourceIdsList = listTagsForResourcesRequest.resourceIds();
                if (listTagsForResourcesRequestResourceIdsList != null) {
                    xmlWriter.startElement("ResourceIds");

                    for (String listTagsForResourcesRequestResourceIdsListValue : listTagsForResourcesRequestResourceIdsList) {
                        xmlWriter.startElement("ResourceId");
                        xmlWriter.value(listTagsForResourcesRequestResourceIdsListValue);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
            }
            xmlWriter.endElement();

            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }

        return request;
    }

}