/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * TestDNSAnswerResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class TestDNSAnswerResponseUnmarshaller implements Unmarshaller<TestDNSAnswerResponse, StaxUnmarshallerContext> {

    public TestDNSAnswerResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        TestDNSAnswerResponse.Builder testDNSAnswerResponse = TestDNSAnswerResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<String> recordData = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                testDNSAnswerResponse.recordData(recordData);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Nameserver", targetDepth)) {
                    testDNSAnswerResponse.nameserver(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("RecordName", targetDepth)) {
                    testDNSAnswerResponse.recordName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("RecordType", targetDepth)) {
                    testDNSAnswerResponse.recordType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("RecordData", targetDepth)) {
                    recordData = new ArrayList<String>();
                    continue;
                }

                if (context.testExpression("RecordData/RecordDataEntry", targetDepth)) {
                    recordData.add(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ResponseCode", targetDepth)) {
                    testDNSAnswerResponse.responseCode(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Protocol", targetDepth)) {
                    testDNSAnswerResponse.protocol(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    testDNSAnswerResponse.recordData(recordData);
                    break;
                }
            }
        }
        return testDNSAnswerResponse.build();
    }

    private static TestDNSAnswerResponseUnmarshaller INSTANCE;

    public static TestDNSAnswerResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new TestDNSAnswerResponseUnmarshaller();
        return INSTANCE;
    }
}
