/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import static software.amazon.awssdk.util.StringUtils.UTF8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;

import software.amazon.awssdk.util.StringInputStream;

import software.amazon.awssdk.util.XmlWriter;

/**
 * UpdateHealthCheckRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateHealthCheckRequestMarshaller implements
        Marshaller<Request<UpdateHealthCheckRequest>, UpdateHealthCheckRequest> {

    public Request<UpdateHealthCheckRequest> marshall(UpdateHealthCheckRequest updateHealthCheckRequest) {

        if (updateHealthCheckRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<UpdateHealthCheckRequest> request = new DefaultRequest<UpdateHealthCheckRequest>(updateHealthCheckRequest,
                "Route53Client");

        request.setHttpMethod(HttpMethodName.POST);

        String uriResourcePath = "/2013-04-01/healthcheck/{HealthCheckId}";

        uriResourcePath = software.amazon.awssdk.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "HealthCheckId", updateHealthCheckRequest.healthCheckId());
        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter(stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");

            xmlWriter.startElement("UpdateHealthCheckRequest");
            if (updateHealthCheckRequest != null) {

                if (updateHealthCheckRequest.healthCheckVersion() != null) {
                    xmlWriter.startElement("HealthCheckVersion").value(updateHealthCheckRequest.healthCheckVersion())
                            .endElement();
                }

                if (updateHealthCheckRequest.ipAddress() != null) {
                    xmlWriter.startElement("IPAddress").value(updateHealthCheckRequest.ipAddress()).endElement();
                }

                if (updateHealthCheckRequest.port() != null) {
                    xmlWriter.startElement("Port").value(updateHealthCheckRequest.port()).endElement();
                }

                if (updateHealthCheckRequest.resourcePath() != null) {
                    xmlWriter.startElement("ResourcePath").value(updateHealthCheckRequest.resourcePath()).endElement();
                }

                if (updateHealthCheckRequest.fullyQualifiedDomainName() != null) {
                    xmlWriter.startElement("FullyQualifiedDomainName").value(updateHealthCheckRequest.fullyQualifiedDomainName())
                            .endElement();
                }

                if (updateHealthCheckRequest.searchString() != null) {
                    xmlWriter.startElement("SearchString").value(updateHealthCheckRequest.searchString()).endElement();
                }

                if (updateHealthCheckRequest.failureThreshold() != null) {
                    xmlWriter.startElement("FailureThreshold").value(updateHealthCheckRequest.failureThreshold()).endElement();
                }

                if (updateHealthCheckRequest.inverted() != null) {
                    xmlWriter.startElement("Inverted").value(updateHealthCheckRequest.inverted()).endElement();
                }

                if (updateHealthCheckRequest.healthThreshold() != null) {
                    xmlWriter.startElement("HealthThreshold").value(updateHealthCheckRequest.healthThreshold()).endElement();
                }

                java.util.List<String> updateHealthCheckRequestChildHealthChecksList = updateHealthCheckRequest
                        .childHealthChecks();
                if (updateHealthCheckRequestChildHealthChecksList != null) {
                    xmlWriter.startElement("ChildHealthChecks");

                    for (String updateHealthCheckRequestChildHealthChecksListValue : updateHealthCheckRequestChildHealthChecksList) {
                        xmlWriter.startElement("ChildHealthCheck");
                        xmlWriter.value(updateHealthCheckRequestChildHealthChecksListValue);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }

                if (updateHealthCheckRequest.enableSNI() != null) {
                    xmlWriter.startElement("EnableSNI").value(updateHealthCheckRequest.enableSNI()).endElement();
                }

                java.util.List<String> updateHealthCheckRequestRegionsList = updateHealthCheckRequest.regions();
                if (updateHealthCheckRequestRegionsList != null) {
                    xmlWriter.startElement("Regions");

                    for (String updateHealthCheckRequestRegionsListValue : updateHealthCheckRequestRegionsList) {
                        xmlWriter.startElement("Region");
                        xmlWriter.value(updateHealthCheckRequestRegionsListValue);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }

                AlarmIdentifier alarmIdentifier = updateHealthCheckRequest.alarmIdentifier();
                if (alarmIdentifier != null) {
                    xmlWriter.startElement("AlarmIdentifier");

                    if (alarmIdentifier.region() != null) {
                        xmlWriter.startElement("Region").value(alarmIdentifier.region()).endElement();
                    }

                    if (alarmIdentifier.name() != null) {
                        xmlWriter.startElement("Name").value(alarmIdentifier.name()).endElement();
                    }
                    xmlWriter.endElement();
                }

                if (updateHealthCheckRequest.insufficientDataHealthStatus() != null) {
                    xmlWriter.startElement("InsufficientDataHealthStatus")
                            .value(updateHealthCheckRequest.insufficientDataHealthStatus()).endElement();
                }
            }
            xmlWriter.endElement();

            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }

        return request;
    }

}