/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.route53domains.transform.ContactDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ContactDetail includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ContactDetail implements StructuredPojo, ToCopyableBuilder<ContactDetail.Builder, ContactDetail> {
    private final String firstName;

    private final String lastName;

    private final String contactType;

    private final String organizationName;

    private final String addressLine1;

    private final String addressLine2;

    private final String city;

    private final String state;

    private final String countryCode;

    private final String zipCode;

    private final String phoneNumber;

    private final String email;

    private final String fax;

    private final List<ExtraParam> extraParams;

    private ContactDetail(BuilderImpl builder) {
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.contactType = builder.contactType;
        this.organizationName = builder.organizationName;
        this.addressLine1 = builder.addressLine1;
        this.addressLine2 = builder.addressLine2;
        this.city = builder.city;
        this.state = builder.state;
        this.countryCode = builder.countryCode;
        this.zipCode = builder.zipCode;
        this.phoneNumber = builder.phoneNumber;
        this.email = builder.email;
        this.fax = builder.fax;
        this.extraParams = builder.extraParams;
    }

    /**
     * <p>
     * First name of contact.
     * </p>
     * 
     * @return First name of contact.
     */
    public String firstName() {
        return firstName;
    }

    /**
     * <p>
     * Last name of contact.
     * </p>
     * 
     * @return Last name of contact.
     */
    public String lastName() {
        return lastName;
    }

    /**
     * <p>
     * Indicates whether the contact is a person, company, association, or public organization. If you choose an option
     * other than <code>PERSON</code>, you must enter an organization name, and you can't enable privacy protection for
     * the contact.
     * </p>
     * 
     * @return Indicates whether the contact is a person, company, association, or public organization. If you choose an
     *         option other than <code>PERSON</code>, you must enter an organization name, and you can't enable privacy
     *         protection for the contact.
     * @see ContactType
     */
    public String contactType() {
        return contactType;
    }

    /**
     * <p>
     * Name of the organization for contact types other than <code>PERSON</code>.
     * </p>
     * 
     * @return Name of the organization for contact types other than <code>PERSON</code>.
     */
    public String organizationName() {
        return organizationName;
    }

    /**
     * <p>
     * First line of the contact's address.
     * </p>
     * 
     * @return First line of the contact's address.
     */
    public String addressLine1() {
        return addressLine1;
    }

    /**
     * <p>
     * Second line of contact's address, if any.
     * </p>
     * 
     * @return Second line of contact's address, if any.
     */
    public String addressLine2() {
        return addressLine2;
    }

    /**
     * <p>
     * The city of the contact's address.
     * </p>
     * 
     * @return The city of the contact's address.
     */
    public String city() {
        return city;
    }

    /**
     * <p>
     * The state or province of the contact's city.
     * </p>
     * 
     * @return The state or province of the contact's city.
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * Code for the country of the contact's address.
     * </p>
     * 
     * @return Code for the country of the contact's address.
     * @see CountryCode
     */
    public String countryCode() {
        return countryCode;
    }

    /**
     * <p>
     * The zip or postal code of the contact's address.
     * </p>
     * 
     * @return The zip or postal code of the contact's address.
     */
    public String zipCode() {
        return zipCode;
    }

    /**
     * <p>
     * The phone number of the contact.
     * </p>
     * <p>
     * Constraints: Phone number must be specified in the format
     * "+[country dialing code].[number including any area code&gt;]". For example, a US phone number might appear as
     * <code>"+1.1234567890"</code>.
     * </p>
     * 
     * @return The phone number of the contact.</p>
     *         <p>
     *         Constraints: Phone number must be specified in the format
     *         "+[country dialing code].[number including any area code&gt;]". For example, a US phone number might
     *         appear as <code>"+1.1234567890"</code>.
     */
    public String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * Email address of the contact.
     * </p>
     * 
     * @return Email address of the contact.
     */
    public String email() {
        return email;
    }

    /**
     * <p>
     * Fax number of the contact.
     * </p>
     * <p>
     * Constraints: Phone number must be specified in the format
     * "+[country dialing code].[number including any area code]". For example, a US phone number might appear as
     * <code>"+1.1234567890"</code>.
     * </p>
     * 
     * @return Fax number of the contact.</p>
     *         <p>
     *         Constraints: Phone number must be specified in the format
     *         "+[country dialing code].[number including any area code]". For example, a US phone number might appear
     *         as <code>"+1.1234567890"</code>.
     */
    public String fax() {
        return fax;
    }

    /**
     * <p>
     * A list of name-value pairs for parameters required by certain top-level domains.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of name-value pairs for parameters required by certain top-level domains.
     */
    public List<ExtraParam> extraParams() {
        return extraParams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((firstName() == null) ? 0 : firstName().hashCode());
        hashCode = 31 * hashCode + ((lastName() == null) ? 0 : lastName().hashCode());
        hashCode = 31 * hashCode + ((contactType() == null) ? 0 : contactType().hashCode());
        hashCode = 31 * hashCode + ((organizationName() == null) ? 0 : organizationName().hashCode());
        hashCode = 31 * hashCode + ((addressLine1() == null) ? 0 : addressLine1().hashCode());
        hashCode = 31 * hashCode + ((addressLine2() == null) ? 0 : addressLine2().hashCode());
        hashCode = 31 * hashCode + ((city() == null) ? 0 : city().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((countryCode() == null) ? 0 : countryCode().hashCode());
        hashCode = 31 * hashCode + ((zipCode() == null) ? 0 : zipCode().hashCode());
        hashCode = 31 * hashCode + ((phoneNumber() == null) ? 0 : phoneNumber().hashCode());
        hashCode = 31 * hashCode + ((email() == null) ? 0 : email().hashCode());
        hashCode = 31 * hashCode + ((fax() == null) ? 0 : fax().hashCode());
        hashCode = 31 * hashCode + ((extraParams() == null) ? 0 : extraParams().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactDetail)) {
            return false;
        }
        ContactDetail other = (ContactDetail) obj;
        if (other.firstName() == null ^ this.firstName() == null) {
            return false;
        }
        if (other.firstName() != null && !other.firstName().equals(this.firstName())) {
            return false;
        }
        if (other.lastName() == null ^ this.lastName() == null) {
            return false;
        }
        if (other.lastName() != null && !other.lastName().equals(this.lastName())) {
            return false;
        }
        if (other.contactType() == null ^ this.contactType() == null) {
            return false;
        }
        if (other.contactType() != null && !other.contactType().equals(this.contactType())) {
            return false;
        }
        if (other.organizationName() == null ^ this.organizationName() == null) {
            return false;
        }
        if (other.organizationName() != null && !other.organizationName().equals(this.organizationName())) {
            return false;
        }
        if (other.addressLine1() == null ^ this.addressLine1() == null) {
            return false;
        }
        if (other.addressLine1() != null && !other.addressLine1().equals(this.addressLine1())) {
            return false;
        }
        if (other.addressLine2() == null ^ this.addressLine2() == null) {
            return false;
        }
        if (other.addressLine2() != null && !other.addressLine2().equals(this.addressLine2())) {
            return false;
        }
        if (other.city() == null ^ this.city() == null) {
            return false;
        }
        if (other.city() != null && !other.city().equals(this.city())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.countryCode() == null ^ this.countryCode() == null) {
            return false;
        }
        if (other.countryCode() != null && !other.countryCode().equals(this.countryCode())) {
            return false;
        }
        if (other.zipCode() == null ^ this.zipCode() == null) {
            return false;
        }
        if (other.zipCode() != null && !other.zipCode().equals(this.zipCode())) {
            return false;
        }
        if (other.phoneNumber() == null ^ this.phoneNumber() == null) {
            return false;
        }
        if (other.phoneNumber() != null && !other.phoneNumber().equals(this.phoneNumber())) {
            return false;
        }
        if (other.email() == null ^ this.email() == null) {
            return false;
        }
        if (other.email() != null && !other.email().equals(this.email())) {
            return false;
        }
        if (other.fax() == null ^ this.fax() == null) {
            return false;
        }
        if (other.fax() != null && !other.fax().equals(this.fax())) {
            return false;
        }
        if (other.extraParams() == null ^ this.extraParams() == null) {
            return false;
        }
        if (other.extraParams() != null && !other.extraParams().equals(this.extraParams())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (firstName() != null) {
            sb.append("FirstName: ").append(firstName()).append(",");
        }
        if (lastName() != null) {
            sb.append("LastName: ").append(lastName()).append(",");
        }
        if (contactType() != null) {
            sb.append("ContactType: ").append(contactType()).append(",");
        }
        if (organizationName() != null) {
            sb.append("OrganizationName: ").append(organizationName()).append(",");
        }
        if (addressLine1() != null) {
            sb.append("AddressLine1: ").append(addressLine1()).append(",");
        }
        if (addressLine2() != null) {
            sb.append("AddressLine2: ").append(addressLine2()).append(",");
        }
        if (city() != null) {
            sb.append("City: ").append(city()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (countryCode() != null) {
            sb.append("CountryCode: ").append(countryCode()).append(",");
        }
        if (zipCode() != null) {
            sb.append("ZipCode: ").append(zipCode()).append(",");
        }
        if (phoneNumber() != null) {
            sb.append("PhoneNumber: ").append(phoneNumber()).append(",");
        }
        if (email() != null) {
            sb.append("Email: ").append(email()).append(",");
        }
        if (fax() != null) {
            sb.append("Fax: ").append(fax()).append(",");
        }
        if (extraParams() != null) {
            sb.append("ExtraParams: ").append(extraParams()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContactDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ContactDetail> {
        /**
         * <p>
         * First name of contact.
         * </p>
         * 
         * @param firstName
         *        First name of contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * Last name of contact.
         * </p>
         * 
         * @param lastName
         *        Last name of contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * Indicates whether the contact is a person, company, association, or public organization. If you choose an
         * option other than <code>PERSON</code>, you must enter an organization name, and you can't enable privacy
         * protection for the contact.
         * </p>
         * 
         * @param contactType
         *        Indicates whether the contact is a person, company, association, or public organization. If you choose
         *        an option other than <code>PERSON</code>, you must enter an organization name, and you can't enable
         *        privacy protection for the contact.
         * @see ContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactType
         */
        Builder contactType(String contactType);

        /**
         * <p>
         * Indicates whether the contact is a person, company, association, or public organization. If you choose an
         * option other than <code>PERSON</code>, you must enter an organization name, and you can't enable privacy
         * protection for the contact.
         * </p>
         * 
         * @param contactType
         *        Indicates whether the contact is a person, company, association, or public organization. If you choose
         *        an option other than <code>PERSON</code>, you must enter an organization name, and you can't enable
         *        privacy protection for the contact.
         * @see ContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactType
         */
        Builder contactType(ContactType contactType);

        /**
         * <p>
         * Name of the organization for contact types other than <code>PERSON</code>.
         * </p>
         * 
         * @param organizationName
         *        Name of the organization for contact types other than <code>PERSON</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationName(String organizationName);

        /**
         * <p>
         * First line of the contact's address.
         * </p>
         * 
         * @param addressLine1
         *        First line of the contact's address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressLine1(String addressLine1);

        /**
         * <p>
         * Second line of contact's address, if any.
         * </p>
         * 
         * @param addressLine2
         *        Second line of contact's address, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressLine2(String addressLine2);

        /**
         * <p>
         * The city of the contact's address.
         * </p>
         * 
         * @param city
         *        The city of the contact's address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The state or province of the contact's city.
         * </p>
         * 
         * @param state
         *        The state or province of the contact's city.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * Code for the country of the contact's address.
         * </p>
         * 
         * @param countryCode
         *        Code for the country of the contact's address.
         * @see CountryCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CountryCode
         */
        Builder countryCode(String countryCode);

        /**
         * <p>
         * Code for the country of the contact's address.
         * </p>
         * 
         * @param countryCode
         *        Code for the country of the contact's address.
         * @see CountryCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CountryCode
         */
        Builder countryCode(CountryCode countryCode);

        /**
         * <p>
         * The zip or postal code of the contact's address.
         * </p>
         * 
         * @param zipCode
         *        The zip or postal code of the contact's address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zipCode(String zipCode);

        /**
         * <p>
         * The phone number of the contact.
         * </p>
         * <p>
         * Constraints: Phone number must be specified in the format
         * "+[country dialing code].[number including any area code&gt;]". For example, a US phone number might appear
         * as <code>"+1.1234567890"</code>.
         * </p>
         * 
         * @param phoneNumber
         *        The phone number of the contact.</p>
         *        <p>
         *        Constraints: Phone number must be specified in the format
         *        "+[country dialing code].[number including any area code&gt;]". For example, a US phone number might
         *        appear as <code>"+1.1234567890"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * Email address of the contact.
         * </p>
         * 
         * @param email
         *        Email address of the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * Fax number of the contact.
         * </p>
         * <p>
         * Constraints: Phone number must be specified in the format
         * "+[country dialing code].[number including any area code]". For example, a US phone number might appear as
         * <code>"+1.1234567890"</code>.
         * </p>
         * 
         * @param fax
         *        Fax number of the contact.</p>
         *        <p>
         *        Constraints: Phone number must be specified in the format
         *        "+[country dialing code].[number including any area code]". For example, a US phone number might
         *        appear as <code>"+1.1234567890"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fax(String fax);

        /**
         * <p>
         * A list of name-value pairs for parameters required by certain top-level domains.
         * </p>
         * 
         * @param extraParams
         *        A list of name-value pairs for parameters required by certain top-level domains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraParams(Collection<ExtraParam> extraParams);

        /**
         * <p>
         * A list of name-value pairs for parameters required by certain top-level domains.
         * </p>
         * 
         * @param extraParams
         *        A list of name-value pairs for parameters required by certain top-level domains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extraParams(ExtraParam... extraParams);
    }

    private static final class BuilderImpl implements Builder {
        private String firstName;

        private String lastName;

        private String contactType;

        private String organizationName;

        private String addressLine1;

        private String addressLine2;

        private String city;

        private String state;

        private String countryCode;

        private String zipCode;

        private String phoneNumber;

        private String email;

        private String fax;

        private List<ExtraParam> extraParams;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactDetail model) {
            setFirstName(model.firstName);
            setLastName(model.lastName);
            setContactType(model.contactType);
            setOrganizationName(model.organizationName);
            setAddressLine1(model.addressLine1);
            setAddressLine2(model.addressLine2);
            setCity(model.city);
            setState(model.state);
            setCountryCode(model.countryCode);
            setZipCode(model.zipCode);
            setPhoneNumber(model.phoneNumber);
            setEmail(model.email);
            setFax(model.fax);
            setExtraParams(model.extraParams);
        }

        public final String getFirstName() {
            return firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public final String getLastName() {
            return lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public final String getContactType() {
            return contactType;
        }

        @Override
        public final Builder contactType(String contactType) {
            this.contactType = contactType;
            return this;
        }

        @Override
        public final Builder contactType(ContactType contactType) {
            this.contactType(contactType.toString());
            return this;
        }

        public final void setContactType(String contactType) {
            this.contactType = contactType;
        }

        public final void setContactType(ContactType contactType) {
            this.contactType(contactType.toString());
        }

        public final String getOrganizationName() {
            return organizationName;
        }

        @Override
        public final Builder organizationName(String organizationName) {
            this.organizationName = organizationName;
            return this;
        }

        public final void setOrganizationName(String organizationName) {
            this.organizationName = organizationName;
        }

        public final String getAddressLine1() {
            return addressLine1;
        }

        @Override
        public final Builder addressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
            return this;
        }

        public final void setAddressLine1(String addressLine1) {
            this.addressLine1 = addressLine1;
        }

        public final String getAddressLine2() {
            return addressLine2;
        }

        @Override
        public final Builder addressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
            return this;
        }

        public final void setAddressLine2(String addressLine2) {
            this.addressLine2 = addressLine2;
        }

        public final String getCity() {
            return city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getCountryCode() {
            return countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        @Override
        public final Builder countryCode(CountryCode countryCode) {
            this.countryCode(countryCode.toString());
            return this;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        public final void setCountryCode(CountryCode countryCode) {
            this.countryCode(countryCode.toString());
        }

        public final String getZipCode() {
            return zipCode;
        }

        @Override
        public final Builder zipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public final void setZipCode(String zipCode) {
            this.zipCode = zipCode;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final String getEmail() {
            return email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getFax() {
            return fax;
        }

        @Override
        public final Builder fax(String fax) {
            this.fax = fax;
            return this;
        }

        public final void setFax(String fax) {
            this.fax = fax;
        }

        public final Collection<ExtraParam> getExtraParams() {
            return extraParams;
        }

        @Override
        public final Builder extraParams(Collection<ExtraParam> extraParams) {
            this.extraParams = ExtraParamListCopier.copy(extraParams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extraParams(ExtraParam... extraParams) {
            extraParams(Arrays.asList(extraParams));
            return this;
        }

        public final void setExtraParams(Collection<ExtraParam> extraParams) {
            this.extraParams = ExtraParamListCopier.copy(extraParams);
        }

        @SafeVarargs
        public final void setExtraParams(ExtraParam... extraParams) {
            extraParams(Arrays.asList(extraParams));
        }

        @Override
        public ContactDetail build() {
            return new ContactDetail(this);
        }
    }
}
