/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.route53domains.transform.DomainSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about one domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DomainSummary implements StructuredPojo, ToCopyableBuilder<DomainSummary.Builder, DomainSummary> {
    private final String domainName;

    private final Boolean autoRenew;

    private final Boolean transferLock;

    private final Instant expiry;

    private DomainSummary(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.autoRenew = builder.autoRenew;
        this.transferLock = builder.transferLock;
        this.expiry = builder.expiry;
    }

    /**
     * <p>
     * The name of the domain that the summary information applies to.
     * </p>
     * 
     * @return The name of the domain that the summary information applies to.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Indicates whether the domain is automatically renewed upon expiration.
     * </p>
     * 
     * @return Indicates whether the domain is automatically renewed upon expiration.
     */
    public Boolean autoRenew() {
        return autoRenew;
    }

    /**
     * <p>
     * Indicates whether a domain is locked from unauthorized transfer to another party.
     * </p>
     * 
     * @return Indicates whether a domain is locked from unauthorized transfer to another party.
     */
    public Boolean transferLock() {
        return transferLock;
    }

    /**
     * <p>
     * Expiration date of the domain in Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return Expiration date of the domain in Coordinated Universal Time (UTC).
     */
    public Instant expiry() {
        return expiry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domainName() == null) ? 0 : domainName().hashCode());
        hashCode = 31 * hashCode + ((autoRenew() == null) ? 0 : autoRenew().hashCode());
        hashCode = 31 * hashCode + ((transferLock() == null) ? 0 : transferLock().hashCode());
        hashCode = 31 * hashCode + ((expiry() == null) ? 0 : expiry().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSummary)) {
            return false;
        }
        DomainSummary other = (DomainSummary) obj;
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.autoRenew() == null ^ this.autoRenew() == null) {
            return false;
        }
        if (other.autoRenew() != null && !other.autoRenew().equals(this.autoRenew())) {
            return false;
        }
        if (other.transferLock() == null ^ this.transferLock() == null) {
            return false;
        }
        if (other.transferLock() != null && !other.transferLock().equals(this.transferLock())) {
            return false;
        }
        if (other.expiry() == null ^ this.expiry() == null) {
            return false;
        }
        if (other.expiry() != null && !other.expiry().equals(this.expiry())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (autoRenew() != null) {
            sb.append("AutoRenew: ").append(autoRenew()).append(",");
        }
        if (transferLock() != null) {
            sb.append("TransferLock: ").append(transferLock()).append(",");
        }
        if (expiry() != null) {
            sb.append("Expiry: ").append(expiry()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DomainSummary> {
        /**
         * <p>
         * The name of the domain that the summary information applies to.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that the summary information applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Indicates whether the domain is automatically renewed upon expiration.
         * </p>
         * 
         * @param autoRenew
         *        Indicates whether the domain is automatically renewed upon expiration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRenew(Boolean autoRenew);

        /**
         * <p>
         * Indicates whether a domain is locked from unauthorized transfer to another party.
         * </p>
         * 
         * @param transferLock
         *        Indicates whether a domain is locked from unauthorized transfer to another party.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transferLock(Boolean transferLock);

        /**
         * <p>
         * Expiration date of the domain in Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param expiry
         *        Expiration date of the domain in Coordinated Universal Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiry(Instant expiry);
    }

    private static final class BuilderImpl implements Builder {
        private String domainName;

        private Boolean autoRenew;

        private Boolean transferLock;

        private Instant expiry;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainSummary model) {
            setDomainName(model.domainName);
            setAutoRenew(model.autoRenew);
            setTransferLock(model.transferLock);
            setExpiry(model.expiry);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Boolean getAutoRenew() {
            return autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        public final Boolean getTransferLock() {
            return transferLock;
        }

        @Override
        public final Builder transferLock(Boolean transferLock) {
            this.transferLock = transferLock;
            return this;
        }

        public final void setTransferLock(Boolean transferLock) {
            this.transferLock = transferLock;
        }

        public final Instant getExpiry() {
            return expiry;
        }

        @Override
        public final Builder expiry(Instant expiry) {
            this.expiry = expiry;
            return this;
        }

        public final void setExpiry(Instant expiry) {
            this.expiry = expiry;
        }

        @Override
        public DomainSummary build() {
            return new DomainSummary(this);
        }
    }
}
