/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetContactReachabilityStatusResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetContactReachabilityStatusResponse.Builder, GetContactReachabilityStatusResponse> {
    private final String domainName;

    private final String status;

    private GetContactReachabilityStatusResponse(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The domain name for which you requested the reachability status.
     * </p>
     * 
     * @return The domain name for which you requested the reachability status.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Whether the registrant contact has responded. Values include the following:
     * </p>
     * <dl>
     * <dt>PENDING</dt>
     * <dd>
     * <p>
     * We sent the confirmation email and haven't received a response yet.
     * </p>
     * </dd>
     * <dt>DONE</dt>
     * <dd>
     * <p>
     * We sent the email and got confirmation from the registrant contact.
     * </p>
     * </dd>
     * <dt>EXPIRED</dt>
     * <dd>
     * <p>
     * The time limit expired before the registrant contact responded.
     * </p>
     * </dd>
     * </dl>
     * 
     * @return Whether the registrant contact has responded. Values include the following:</p>
     *         <dl>
     *         <dt>PENDING</dt>
     *         <dd>
     *         <p>
     *         We sent the confirmation email and haven't received a response yet.
     *         </p>
     *         </dd>
     *         <dt>DONE</dt>
     *         <dd>
     *         <p>
     *         We sent the email and got confirmation from the registrant contact.
     *         </p>
     *         </dd>
     *         <dt>EXPIRED</dt>
     *         <dd>
     *         <p>
     *         The time limit expired before the registrant contact responded.
     *         </p>
     *         </dd>
     * @see ReachabilityStatus
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domainName() == null) ? 0 : domainName().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContactReachabilityStatusResponse)) {
            return false;
        }
        GetContactReachabilityStatusResponse other = (GetContactReachabilityStatusResponse) obj;
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetContactReachabilityStatusResponse> {
        /**
         * <p>
         * The domain name for which you requested the reachability status.
         * </p>
         * 
         * @param domainName
         *        The domain name for which you requested the reachability status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Whether the registrant contact has responded. Values include the following:
         * </p>
         * <dl>
         * <dt>PENDING</dt>
         * <dd>
         * <p>
         * We sent the confirmation email and haven't received a response yet.
         * </p>
         * </dd>
         * <dt>DONE</dt>
         * <dd>
         * <p>
         * We sent the email and got confirmation from the registrant contact.
         * </p>
         * </dd>
         * <dt>EXPIRED</dt>
         * <dd>
         * <p>
         * The time limit expired before the registrant contact responded.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        Whether the registrant contact has responded. Values include the following:</p>
         *        <dl>
         *        <dt>PENDING</dt>
         *        <dd>
         *        <p>
         *        We sent the confirmation email and haven't received a response yet.
         *        </p>
         *        </dd>
         *        <dt>DONE</dt>
         *        <dd>
         *        <p>
         *        We sent the email and got confirmation from the registrant contact.
         *        </p>
         *        </dd>
         *        <dt>EXPIRED</dt>
         *        <dd>
         *        <p>
         *        The time limit expired before the registrant contact responded.
         *        </p>
         *        </dd>
         * @see ReachabilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReachabilityStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Whether the registrant contact has responded. Values include the following:
         * </p>
         * <dl>
         * <dt>PENDING</dt>
         * <dd>
         * <p>
         * We sent the confirmation email and haven't received a response yet.
         * </p>
         * </dd>
         * <dt>DONE</dt>
         * <dd>
         * <p>
         * We sent the email and got confirmation from the registrant contact.
         * </p>
         * </dd>
         * <dt>EXPIRED</dt>
         * <dd>
         * <p>
         * The time limit expired before the registrant contact responded.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        Whether the registrant contact has responded. Values include the following:</p>
         *        <dl>
         *        <dt>PENDING</dt>
         *        <dd>
         *        <p>
         *        We sent the confirmation email and haven't received a response yet.
         *        </p>
         *        </dd>
         *        <dt>DONE</dt>
         *        <dd>
         *        <p>
         *        We sent the email and got confirmation from the registrant contact.
         *        </p>
         *        </dd>
         *        <dt>EXPIRED</dt>
         *        <dd>
         *        <p>
         *        The time limit expired before the registrant contact responded.
         *        </p>
         *        </dd>
         * @see ReachabilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReachabilityStatus
         */
        Builder status(ReachabilityStatus status);
    }

    private static final class BuilderImpl implements Builder {
        private String domainName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContactReachabilityStatusResponse model) {
            setDomainName(model.domainName);
            setStatus(model.status);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReachabilityStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(ReachabilityStatus status) {
            this.status(status.toString());
        }

        @Override
        public GetContactReachabilityStatusResponse build() {
            return new GetContactReachabilityStatusResponse(this);
        }
    }
}
