/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetDomainSuggestionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetDomainSuggestionsResponse.Builder, GetDomainSuggestionsResponse> {
    private final List<DomainSuggestion> suggestionsList;

    private GetDomainSuggestionsResponse(BuilderImpl builder) {
        this.suggestionsList = builder.suggestionsList;
    }

    /**
     * <p>
     * A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the
     * request, the list contains only domains that are available for registration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the
     *         request, the list contains only domains that are available for registration.
     */
    public List<DomainSuggestion> suggestionsList() {
        return suggestionsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((suggestionsList() == null) ? 0 : suggestionsList().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainSuggestionsResponse)) {
            return false;
        }
        GetDomainSuggestionsResponse other = (GetDomainSuggestionsResponse) obj;
        if (other.suggestionsList() == null ^ this.suggestionsList() == null) {
            return false;
        }
        if (other.suggestionsList() != null && !other.suggestionsList().equals(this.suggestionsList())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (suggestionsList() != null) {
            sb.append("SuggestionsList: ").append(suggestionsList()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetDomainSuggestionsResponse> {
        /**
         * <p>
         * A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the
         * request, the list contains only domains that are available for registration.
         * </p>
         * 
         * @param suggestionsList
         *        A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in
         *        the request, the list contains only domains that are available for registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestionsList(Collection<DomainSuggestion> suggestionsList);

        /**
         * <p>
         * A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in the
         * request, the list contains only domains that are available for registration.
         * </p>
         * 
         * @param suggestionsList
         *        A list of possible domain names. If you specified <code>true</code> for <code>OnlyAvailable</code> in
         *        the request, the list contains only domains that are available for registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestionsList(DomainSuggestion... suggestionsList);
    }

    private static final class BuilderImpl implements Builder {
        private List<DomainSuggestion> suggestionsList;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainSuggestionsResponse model) {
            setSuggestionsList(model.suggestionsList);
        }

        public final Collection<DomainSuggestion> getSuggestionsList() {
            return suggestionsList;
        }

        @Override
        public final Builder suggestionsList(Collection<DomainSuggestion> suggestionsList) {
            this.suggestionsList = DomainSuggestionsListCopier.copy(suggestionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestionsList(DomainSuggestion... suggestionsList) {
            suggestionsList(Arrays.asList(suggestionsList));
            return this;
        }

        public final void setSuggestionsList(Collection<DomainSuggestion> suggestionsList) {
            this.suggestionsList = DomainSuggestionsListCopier.copy(suggestionsList);
        }

        @SafeVarargs
        public final void setSuggestionsList(DomainSuggestion... suggestionsList) {
            suggestionsList(Arrays.asList(suggestionsList));
        }

        @Override
        public GetDomainSuggestionsResponse build() {
            return new GetDomainSuggestionsResponse(this);
        }
    }
}
