/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The GetOperationDetail response includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetOperationDetailResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetOperationDetailResponse.Builder, GetOperationDetailResponse> {
    private final String operationId;

    private final String status;

    private final String message;

    private final String domainName;

    private final String type;

    private final Instant submittedDate;

    private GetOperationDetailResponse(BuilderImpl builder) {
        this.operationId = builder.operationId;
        this.status = builder.status;
        this.message = builder.message;
        this.domainName = builder.domainName;
        this.type = builder.type;
        this.submittedDate = builder.submittedDate;
    }

    /**
     * <p>
     * The identifier for the operation.
     * </p>
     * 
     * @return The identifier for the operation.
     */
    public String operationId() {
        return operationId;
    }

    /**
     * <p>
     * The current status of the requested operation in the system.
     * </p>
     * 
     * @return The current status of the requested operation in the system.
     * @see OperationStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * Detailed information on the status including possible errors.
     * </p>
     * 
     * @return Detailed information on the status including possible errors.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The name of a domain.
     * </p>
     * 
     * @return The name of a domain.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The type of operation that was requested.
     * </p>
     * 
     * @return The type of operation that was requested.
     * @see OperationType
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The date when the request was submitted.
     * </p>
     * 
     * @return The date when the request was submitted.
     */
    public Instant submittedDate() {
        return submittedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((operationId() == null) ? 0 : operationId().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        hashCode = 31 * hashCode + ((domainName() == null) ? 0 : domainName().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((submittedDate() == null) ? 0 : submittedDate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOperationDetailResponse)) {
            return false;
        }
        GetOperationDetailResponse other = (GetOperationDetailResponse) obj;
        if (other.operationId() == null ^ this.operationId() == null) {
            return false;
        }
        if (other.operationId() != null && !other.operationId().equals(this.operationId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.submittedDate() == null ^ this.submittedDate() == null) {
            return false;
        }
        if (other.submittedDate() != null && !other.submittedDate().equals(this.submittedDate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (operationId() != null) {
            sb.append("OperationId: ").append(operationId()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (submittedDate() != null) {
            sb.append("SubmittedDate: ").append(submittedDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetOperationDetailResponse> {
        /**
         * <p>
         * The identifier for the operation.
         * </p>
         * 
         * @param operationId
         *        The identifier for the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);

        /**
         * <p>
         * The current status of the requested operation in the system.
         * </p>
         * 
         * @param status
         *        The current status of the requested operation in the system.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the requested operation in the system.
         * </p>
         * 
         * @param status
         *        The current status of the requested operation in the system.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(OperationStatus status);

        /**
         * <p>
         * Detailed information on the status including possible errors.
         * </p>
         * 
         * @param message
         *        Detailed information on the status including possible errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The name of a domain.
         * </p>
         * 
         * @param domainName
         *        The name of a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The type of operation that was requested.
         * </p>
         * 
         * @param type
         *        The type of operation that was requested.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of operation that was requested.
         * </p>
         * 
         * @param type
         *        The type of operation that was requested.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(OperationType type);

        /**
         * <p>
         * The date when the request was submitted.
         * </p>
         * 
         * @param submittedDate
         *        The date when the request was submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedDate(Instant submittedDate);
    }

    private static final class BuilderImpl implements Builder {
        private String operationId;

        private String status;

        private String message;

        private String domainName;

        private String type;

        private Instant submittedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOperationDetailResponse model) {
            setOperationId(model.operationId);
            setStatus(model.status);
            setMessage(model.message);
            setDomainName(model.domainName);
            setType(model.type);
            setSubmittedDate(model.submittedDate);
        }

        public final String getOperationId() {
            return operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(OperationStatus status) {
            this.status(status.toString());
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OperationType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(OperationType type) {
            this.type(type.toString());
        }

        public final Instant getSubmittedDate() {
            return submittedDate;
        }

        @Override
        public final Builder submittedDate(Instant submittedDate) {
            this.submittedDate = submittedDate;
            return this;
        }

        public final void setSubmittedDate(Instant submittedDate) {
            this.submittedDate = submittedDate;
        }

        @Override
        public GetOperationDetailResponse build() {
            return new GetOperationDetailResponse(this);
        }
    }
}
