/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The UpdateDomainContact request includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDomainContactRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateDomainContactRequest.Builder, UpdateDomainContactRequest> {
    private final String domainName;

    private final ContactDetail adminContact;

    private final ContactDetail registrantContact;

    private final ContactDetail techContact;

    private UpdateDomainContactRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.adminContact = builder.adminContact;
        this.registrantContact = builder.registrantContact;
        this.techContact = builder.techContact;
    }

    /**
     * <p>
     * The name of the domain that you want to update contact information for.
     * </p>
     * 
     * @return The name of the domain that you want to update contact information for.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Provides detailed contact information.
     * </p>
     * 
     * @return Provides detailed contact information.
     */
    public ContactDetail adminContact() {
        return adminContact;
    }

    /**
     * <p>
     * Provides detailed contact information.
     * </p>
     * 
     * @return Provides detailed contact information.
     */
    public ContactDetail registrantContact() {
        return registrantContact;
    }

    /**
     * <p>
     * Provides detailed contact information.
     * </p>
     * 
     * @return Provides detailed contact information.
     */
    public ContactDetail techContact() {
        return techContact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domainName() == null) ? 0 : domainName().hashCode());
        hashCode = 31 * hashCode + ((adminContact() == null) ? 0 : adminContact().hashCode());
        hashCode = 31 * hashCode + ((registrantContact() == null) ? 0 : registrantContact().hashCode());
        hashCode = 31 * hashCode + ((techContact() == null) ? 0 : techContact().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainContactRequest)) {
            return false;
        }
        UpdateDomainContactRequest other = (UpdateDomainContactRequest) obj;
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.adminContact() == null ^ this.adminContact() == null) {
            return false;
        }
        if (other.adminContact() != null && !other.adminContact().equals(this.adminContact())) {
            return false;
        }
        if (other.registrantContact() == null ^ this.registrantContact() == null) {
            return false;
        }
        if (other.registrantContact() != null && !other.registrantContact().equals(this.registrantContact())) {
            return false;
        }
        if (other.techContact() == null ^ this.techContact() == null) {
            return false;
        }
        if (other.techContact() != null && !other.techContact().equals(this.techContact())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (adminContact() != null) {
            sb.append("AdminContact: ").append(adminContact()).append(",");
        }
        if (registrantContact() != null) {
            sb.append("RegistrantContact: ").append(registrantContact()).append(",");
        }
        if (techContact() != null) {
            sb.append("TechContact: ").append(techContact()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateDomainContactRequest> {
        /**
         * <p>
         * The name of the domain that you want to update contact information for.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that you want to update contact information for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Provides detailed contact information.
         * </p>
         * 
         * @param adminContact
         *        Provides detailed contact information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminContact(ContactDetail adminContact);

        /**
         * <p>
         * Provides detailed contact information.
         * </p>
         * 
         * @param registrantContact
         *        Provides detailed contact information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrantContact(ContactDetail registrantContact);

        /**
         * <p>
         * Provides detailed contact information.
         * </p>
         * 
         * @param techContact
         *        Provides detailed contact information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder techContact(ContactDetail techContact);
    }

    private static final class BuilderImpl implements Builder {
        private String domainName;

        private ContactDetail adminContact;

        private ContactDetail registrantContact;

        private ContactDetail techContact;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainContactRequest model) {
            setDomainName(model.domainName);
            setAdminContact(model.adminContact);
            setRegistrantContact(model.registrantContact);
            setTechContact(model.techContact);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final ContactDetail getAdminContact() {
            return adminContact;
        }

        @Override
        public final Builder adminContact(ContactDetail adminContact) {
            this.adminContact = adminContact;
            return this;
        }

        public final void setAdminContact(ContactDetail adminContact) {
            this.adminContact = adminContact;
        }

        public final ContactDetail getRegistrantContact() {
            return registrantContact;
        }

        @Override
        public final Builder registrantContact(ContactDetail registrantContact) {
            this.registrantContact = registrantContact;
            return this;
        }

        public final void setRegistrantContact(ContactDetail registrantContact) {
            this.registrantContact = registrantContact;
        }

        public final ContactDetail getTechContact() {
            return techContact;
        }

        @Override
        public final Builder techContact(ContactDetail techContact) {
            this.techContact = techContact;
            return this;
        }

        public final void setTechContact(ContactDetail techContact) {
            this.techContact = techContact;
        }

        @Override
        public UpdateDomainContactRequest build() {
            return new UpdateDomainContactRequest(this);
        }
    }
}
