/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Replaces the current set of name servers for the domain with the specified set of name servers. If you use Amazon
 * Route 53 as your DNS service, specify the four name servers in the delegation set for the hosted zone for the domain.
 * </p>
 * <p>
 * If successful, this operation returns an operation ID that you can use to track the progress and completion of the
 * action. If the request is not completed successfully, the domain registrant will be notified by email.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDomainNameserversRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateDomainNameserversRequest.Builder, UpdateDomainNameserversRequest> {
    private final String domainName;

    private final String fiAuthKey;

    private final List<Nameserver> nameservers;

    private UpdateDomainNameserversRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.fiAuthKey = builder.fiAuthKey;
        this.nameservers = builder.nameservers;
    }

    /**
     * <p>
     * The name of the domain that you want to change name servers for.
     * </p>
     * 
     * @return The name of the domain that you want to change name servers for.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The authorization key for .fi domains
     * </p>
     * 
     * @return The authorization key for .fi domains
     */
    public String fiAuthKey() {
        return fiAuthKey;
    }

    /**
     * <p>
     * A list of new name servers for the domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of new name servers for the domain.
     */
    public List<Nameserver> nameservers() {
        return nameservers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((domainName() == null) ? 0 : domainName().hashCode());
        hashCode = 31 * hashCode + ((fiAuthKey() == null) ? 0 : fiAuthKey().hashCode());
        hashCode = 31 * hashCode + ((nameservers() == null) ? 0 : nameservers().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainNameserversRequest)) {
            return false;
        }
        UpdateDomainNameserversRequest other = (UpdateDomainNameserversRequest) obj;
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.fiAuthKey() == null ^ this.fiAuthKey() == null) {
            return false;
        }
        if (other.fiAuthKey() != null && !other.fiAuthKey().equals(this.fiAuthKey())) {
            return false;
        }
        if (other.nameservers() == null ^ this.nameservers() == null) {
            return false;
        }
        if (other.nameservers() != null && !other.nameservers().equals(this.nameservers())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (domainName() != null) {
            sb.append("DomainName: ").append(domainName()).append(",");
        }
        if (fiAuthKey() != null) {
            sb.append("FIAuthKey: ").append(fiAuthKey()).append(",");
        }
        if (nameservers() != null) {
            sb.append("Nameservers: ").append(nameservers()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateDomainNameserversRequest> {
        /**
         * <p>
         * The name of the domain that you want to change name servers for.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that you want to change name servers for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The authorization key for .fi domains
         * </p>
         * 
         * @param fiAuthKey
         *        The authorization key for .fi domains
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fiAuthKey(String fiAuthKey);

        /**
         * <p>
         * A list of new name servers for the domain.
         * </p>
         * 
         * @param nameservers
         *        A list of new name servers for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameservers(Collection<Nameserver> nameservers);

        /**
         * <p>
         * A list of new name servers for the domain.
         * </p>
         * 
         * @param nameservers
         *        A list of new name servers for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameservers(Nameserver... nameservers);
    }

    private static final class BuilderImpl implements Builder {
        private String domainName;

        private String fiAuthKey;

        private List<Nameserver> nameservers;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainNameserversRequest model) {
            setDomainName(model.domainName);
            setFIAuthKey(model.fiAuthKey);
            setNameservers(model.nameservers);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getFIAuthKey() {
            return fiAuthKey;
        }

        @Override
        public final Builder fiAuthKey(String fiAuthKey) {
            this.fiAuthKey = fiAuthKey;
            return this;
        }

        public final void setFIAuthKey(String fiAuthKey) {
            this.fiAuthKey = fiAuthKey;
        }

        public final Collection<Nameserver> getNameservers() {
            return nameservers;
        }

        @Override
        public final Builder nameservers(Collection<Nameserver> nameservers) {
            this.nameservers = NameserverListCopier.copy(nameservers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameservers(Nameserver... nameservers) {
            nameservers(Arrays.asList(nameservers));
            return this;
        }

        public final void setNameservers(Collection<Nameserver> nameservers) {
            this.nameservers = NameserverListCopier.copy(nameservers);
        }

        @SafeVarargs
        public final void setNameservers(Nameserver... nameservers) {
            nameservers(Arrays.asList(nameservers));
        }

        @Override
        public UpdateDomainNameserversRequest build() {
            return new UpdateDomainNameserversRequest(this);
        }
    }
}
