/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ViewBilling request includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ViewBillingRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ViewBillingRequest.Builder, ViewBillingRequest> {
    private final Instant start;

    private final Instant end;

    private final String marker;

    private final Integer maxItems;

    private ViewBillingRequest(BuilderImpl builder) {
        this.start = builder.start;
        this.end = builder.end;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The beginning date and time for the time period for which you want a list of billing records. Specify the date in
     * Unix time format.
     * </p>
     * 
     * @return The beginning date and time for the time period for which you want a list of billing records. Specify the
     *         date in Unix time format.
     */
    public Instant start() {
        return start;
    }

    /**
     * <p>
     * The end date and time for the time period for which you want a list of billing records. Specify the date in Unix
     * time format.
     * </p>
     * 
     * @return The end date and time for the time period for which you want a list of billing records. Specify the date
     *         in Unix time format.
     */
    public Instant end() {
        return end;
    }

    /**
     * <p>
     * For an initial request for a list of billing records, omit this element. If the number of billing records that
     * are associated with the current AWS account during the specified period is greater than the value that you
     * specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional billing records. Get
     * the value of <code>NextPageMarker</code> from the previous response, and submit another request that includes the
     * value of <code>NextPageMarker</code> in the <code>Marker</code> element.
     * </p>
     * <p>
     * Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the previous
     * response.
     * </p>
     * 
     * @return For an initial request for a list of billing records, omit this element. If the number of billing records
     *         that are associated with the current AWS account during the specified period is greater than the value
     *         that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional
     *         billing records. Get the value of <code>NextPageMarker</code> from the previous response, and submit
     *         another request that includes the value of <code>NextPageMarker</code> in the <code>Marker</code>
     *         element. </p>
     *         <p>
     *         Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the
     *         previous response.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * The number of billing records to be returned.
     * </p>
     * <p>
     * Default: 20
     * </p>
     * 
     * @return The number of billing records to be returned.</p>
     *         <p>
     *         Default: 20
     */
    public Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((start() == null) ? 0 : start().hashCode());
        hashCode = 31 * hashCode + ((end() == null) ? 0 : end().hashCode());
        hashCode = 31 * hashCode + ((marker() == null) ? 0 : marker().hashCode());
        hashCode = 31 * hashCode + ((maxItems() == null) ? 0 : maxItems().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewBillingRequest)) {
            return false;
        }
        ViewBillingRequest other = (ViewBillingRequest) obj;
        if (other.start() == null ^ this.start() == null) {
            return false;
        }
        if (other.start() != null && !other.start().equals(this.start())) {
            return false;
        }
        if (other.end() == null ^ this.end() == null) {
            return false;
        }
        if (other.end() != null && !other.end().equals(this.end())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (start() != null) {
            sb.append("Start: ").append(start()).append(",");
        }
        if (end() != null) {
            sb.append("End: ").append(end()).append(",");
        }
        if (marker() != null) {
            sb.append("Marker: ").append(marker()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ViewBillingRequest> {
        /**
         * <p>
         * The beginning date and time for the time period for which you want a list of billing records. Specify the
         * date in Unix time format.
         * </p>
         * 
         * @param start
         *        The beginning date and time for the time period for which you want a list of billing records. Specify
         *        the date in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Instant start);

        /**
         * <p>
         * The end date and time for the time period for which you want a list of billing records. Specify the date in
         * Unix time format.
         * </p>
         * 
         * @param end
         *        The end date and time for the time period for which you want a list of billing records. Specify the
         *        date in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Instant end);

        /**
         * <p>
         * For an initial request for a list of billing records, omit this element. If the number of billing records
         * that are associated with the current AWS account during the specified period is greater than the value that
         * you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return additional billing
         * records. Get the value of <code>NextPageMarker</code> from the previous response, and submit another request
         * that includes the value of <code>NextPageMarker</code> in the <code>Marker</code> element.
         * </p>
         * <p>
         * Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the previous
         * response.
         * </p>
         * 
         * @param marker
         *        For an initial request for a list of billing records, omit this element. If the number of billing
         *        records that are associated with the current AWS account during the specified period is greater than
         *        the value that you specified for <code>MaxItems</code>, you can use <code>Marker</code> to return
         *        additional billing records. Get the value of <code>NextPageMarker</code> from the previous response,
         *        and submit another request that includes the value of <code>NextPageMarker</code> in the
         *        <code>Marker</code> element. </p>
         *        <p>
         *        Constraints: The marker must match the value of <code>NextPageMarker</code> that was returned in the
         *        previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The number of billing records to be returned.
         * </p>
         * <p>
         * Default: 20
         * </p>
         * 
         * @param maxItems
         *        The number of billing records to be returned.</p>
         *        <p>
         *        Default: 20
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);
    }

    private static final class BuilderImpl implements Builder {
        private Instant start;

        private Instant end;

        private String marker;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewBillingRequest model) {
            setStart(model.start);
            setEnd(model.end);
            setMarker(model.marker);
            setMaxItems(model.maxItems);
        }

        public final Instant getStart() {
            return start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        public final Instant getEnd() {
            return end;
        }

        @Override
        public final Builder end(Instant end) {
            this.end = end;
            return this;
        }

        public final void setEnd(Instant end) {
            this.end = end;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ViewBillingRequest build() {
            return new ViewBillingRequest(this);
        }
    }
}
