/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.route53.model.AliasTarget;
import software.amazon.awssdk.services.route53.model.Change;
import software.amazon.awssdk.services.route53.model.ChangeBatch;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.GeoLocation;
import software.amazon.awssdk.services.route53.model.ResourceRecord;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.XmlWriter;

public class ChangeResourceRecordSetsRequestMarshaller
implements Marshaller<Request<ChangeResourceRecordSetsRequest>, ChangeResourceRecordSetsRequest> {
    public Request<ChangeResourceRecordSetsRequest> marshall(ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest) {
        if (changeResourceRecordSetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)changeResourceRecordSetsRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/hostedzone/{Id}/rrset/";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Id", changeResourceRecordSetsRequest.hostedZoneId());
        request.setResourcePath(uriResourcePath);
        try {
            ChangeBatch changeBatch;
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
            xmlWriter.startElement("ChangeResourceRecordSetsRequest");
            if (changeResourceRecordSetsRequest != null && (changeBatch = changeResourceRecordSetsRequest.changeBatch()) != null) {
                List<Change> changeBatchChangesList;
                xmlWriter.startElement("ChangeBatch");
                if (changeBatch.comment() != null) {
                    xmlWriter.startElement("Comment").value(changeBatch.comment()).endElement();
                }
                if ((changeBatchChangesList = changeBatch.changes()) != null) {
                    xmlWriter.startElement("Changes");
                    for (Change changeBatchChangesListValue : changeBatchChangesList) {
                        ResourceRecordSet resourceRecordSet;
                        xmlWriter.startElement("Change");
                        if (changeBatchChangesListValue.action() != null) {
                            xmlWriter.startElement("Action").value(changeBatchChangesListValue.action()).endElement();
                        }
                        if ((resourceRecordSet = changeBatchChangesListValue.resourceRecordSet()) != null) {
                            AliasTarget aliasTarget;
                            List<ResourceRecord> resourceRecordSetResourceRecordsList;
                            GeoLocation geoLocation;
                            xmlWriter.startElement("ResourceRecordSet");
                            if (resourceRecordSet.name() != null) {
                                xmlWriter.startElement("Name").value(resourceRecordSet.name()).endElement();
                            }
                            if (resourceRecordSet.type() != null) {
                                xmlWriter.startElement("Type").value(resourceRecordSet.type()).endElement();
                            }
                            if (resourceRecordSet.setIdentifier() != null) {
                                xmlWriter.startElement("SetIdentifier").value(resourceRecordSet.setIdentifier()).endElement();
                            }
                            if (resourceRecordSet.weight() != null) {
                                xmlWriter.startElement("Weight").value((Object)resourceRecordSet.weight()).endElement();
                            }
                            if (resourceRecordSet.region() != null) {
                                xmlWriter.startElement("Region").value(resourceRecordSet.region()).endElement();
                            }
                            if ((geoLocation = resourceRecordSet.geoLocation()) != null) {
                                xmlWriter.startElement("GeoLocation");
                                if (geoLocation.continentCode() != null) {
                                    xmlWriter.startElement("ContinentCode").value(geoLocation.continentCode()).endElement();
                                }
                                if (geoLocation.countryCode() != null) {
                                    xmlWriter.startElement("CountryCode").value(geoLocation.countryCode()).endElement();
                                }
                                if (geoLocation.subdivisionCode() != null) {
                                    xmlWriter.startElement("SubdivisionCode").value(geoLocation.subdivisionCode()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (resourceRecordSet.failover() != null) {
                                xmlWriter.startElement("Failover").value(resourceRecordSet.failover()).endElement();
                            }
                            if (resourceRecordSet.multiValueAnswer() != null) {
                                xmlWriter.startElement("MultiValueAnswer").value((Object)resourceRecordSet.multiValueAnswer()).endElement();
                            }
                            if (resourceRecordSet.ttl() != null) {
                                xmlWriter.startElement("TTL").value((Object)resourceRecordSet.ttl()).endElement();
                            }
                            if ((resourceRecordSetResourceRecordsList = resourceRecordSet.resourceRecords()) != null) {
                                xmlWriter.startElement("ResourceRecords");
                                for (ResourceRecord resourceRecordSetResourceRecordsListValue : resourceRecordSetResourceRecordsList) {
                                    xmlWriter.startElement("ResourceRecord");
                                    if (resourceRecordSetResourceRecordsListValue.value() != null) {
                                        xmlWriter.startElement("Value").value(resourceRecordSetResourceRecordsListValue.value()).endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((aliasTarget = resourceRecordSet.aliasTarget()) != null) {
                                xmlWriter.startElement("AliasTarget");
                                if (aliasTarget.hostedZoneId() != null) {
                                    xmlWriter.startElement("HostedZoneId").value(aliasTarget.hostedZoneId()).endElement();
                                }
                                if (aliasTarget.dnsName() != null) {
                                    xmlWriter.startElement("DNSName").value(aliasTarget.dnsName()).endElement();
                                }
                                if (aliasTarget.evaluateTargetHealth() != null) {
                                    xmlWriter.startElement("EvaluateTargetHealth").value((Object)aliasTarget.evaluateTargetHealth()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if (resourceRecordSet.healthCheckId() != null) {
                                xmlWriter.startElement("HealthCheckId").value(resourceRecordSet.healthCheckId()).endElement();
                            }
                            if (resourceRecordSet.trafficPolicyInstanceId() != null) {
                                xmlWriter.startElement("TrafficPolicyInstanceId").value(resourceRecordSet.trafficPolicyInstanceId()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

