/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.route53.model.ChangeTagsForResourceRequest;
import software.amazon.awssdk.services.route53.model.Tag;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.XmlWriter;

public class ChangeTagsForResourceRequestMarshaller
implements Marshaller<Request<ChangeTagsForResourceRequest>, ChangeTagsForResourceRequest> {
    public Request<ChangeTagsForResourceRequest> marshall(ChangeTagsForResourceRequest changeTagsForResourceRequest) {
        if (changeTagsForResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)changeTagsForResourceRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/tags/{ResourceType}/{ResourceId}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "ResourceType", changeTagsForResourceRequest.resourceType());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "ResourceId", changeTagsForResourceRequest.resourceId());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
            xmlWriter.startElement("ChangeTagsForResourceRequest");
            if (changeTagsForResourceRequest != null) {
                List<String> changeTagsForResourceRequestRemoveTagKeysList;
                List<Tag> changeTagsForResourceRequestAddTagsList = changeTagsForResourceRequest.addTags();
                if (changeTagsForResourceRequestAddTagsList != null) {
                    xmlWriter.startElement("AddTags");
                    for (Tag changeTagsForResourceRequestAddTagsListValue : changeTagsForResourceRequestAddTagsList) {
                        xmlWriter.startElement("Tag");
                        if (changeTagsForResourceRequestAddTagsListValue.key() != null) {
                            xmlWriter.startElement("Key").value(changeTagsForResourceRequestAddTagsListValue.key()).endElement();
                        }
                        if (changeTagsForResourceRequestAddTagsListValue.value() != null) {
                            xmlWriter.startElement("Value").value(changeTagsForResourceRequestAddTagsListValue.value()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((changeTagsForResourceRequestRemoveTagKeysList = changeTagsForResourceRequest.removeTagKeys()) != null) {
                    xmlWriter.startElement("RemoveTagKeys");
                    for (String changeTagsForResourceRequestRemoveTagKeysListValue : changeTagsForResourceRequestRemoveTagKeysList) {
                        xmlWriter.startElement("Key");
                        xmlWriter.value(changeTagsForResourceRequestRemoveTagKeysListValue);
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

