/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.HealthCheckConfig;
import software.amazon.awssdk.services.route53.transform.AlarmIdentifierUnmarshaller;

public class HealthCheckConfigUnmarshaller
implements Unmarshaller<HealthCheckConfig, StaxUnmarshallerContext> {
    private static HealthCheckConfigUnmarshaller INSTANCE;

    public HealthCheckConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        HealthCheckConfig.Builder healthCheckConfig;
        block21: {
            healthCheckConfig = HealthCheckConfig.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> childHealthChecks = null;
            ArrayList<String> regions = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    healthCheckConfig.childHealthChecks(childHealthChecks);
                    healthCheckConfig.regions(regions);
                    break block21;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("IPAddress", targetDepth)) {
                        healthCheckConfig.ipAddress(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Port", targetDepth)) {
                        healthCheckConfig.port(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Type", targetDepth)) {
                        healthCheckConfig.type(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ResourcePath", targetDepth)) {
                        healthCheckConfig.resourcePath(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("FullyQualifiedDomainName", targetDepth)) {
                        healthCheckConfig.fullyQualifiedDomainName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SearchString", targetDepth)) {
                        healthCheckConfig.searchString(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("RequestInterval", targetDepth)) {
                        healthCheckConfig.requestInterval(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("FailureThreshold", targetDepth)) {
                        healthCheckConfig.failureThreshold(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MeasureLatency", targetDepth)) {
                        healthCheckConfig.measureLatency(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Inverted", targetDepth)) {
                        healthCheckConfig.inverted(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("HealthThreshold", targetDepth)) {
                        healthCheckConfig.healthThreshold(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ChildHealthChecks", targetDepth)) {
                        childHealthChecks = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("ChildHealthChecks/ChildHealthCheck", targetDepth)) {
                        childHealthChecks.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EnableSNI", targetDepth)) {
                        healthCheckConfig.enableSNI(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Regions", targetDepth)) {
                        regions = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("Regions/Region", targetDepth)) {
                        regions.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AlarmIdentifier", targetDepth)) {
                        healthCheckConfig.alarmIdentifier(AlarmIdentifierUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("InsufficientDataHealthStatus", targetDepth)) continue;
                    healthCheckConfig.insufficientDataHealthStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            healthCheckConfig.childHealthChecks(childHealthChecks);
            healthCheckConfig.regions(regions);
        }
        return (HealthCheckConfig)healthCheckConfig.build();
    }

    public static HealthCheckConfigUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HealthCheckConfigUnmarshaller();
        }
        return INSTANCE;
    }
}

