/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This exception contains a list of messages that might contain one or more error messages. Each error message
 * indicates one error in the change batch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InvalidChangeBatchException extends Route53Exception implements
        ToCopyableBuilder<InvalidChangeBatchException.Builder, InvalidChangeBatchException> {
    private final List<String> messages;

    private InvalidChangeBatchException(BuilderImpl builder) {
        super(builder.message);
        this.messages = builder.messages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * Descriptive message for the error response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Descriptive message for the error response.
     */
    public List<String> messages() {
        return messages;
    }

    public interface Builder extends CopyableBuilder<Builder, InvalidChangeBatchException> {
        /**
         * <p>
         * Descriptive message for the error response.
         * </p>
         * 
         * @param messages
         *        Descriptive message for the error response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<String> messages);

        /**
         * <p>
         * Descriptive message for the error response.
         * </p>
         * 
         * @param messages
         *        Descriptive message for the error response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(String... messages);

        Builder message(String message);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> messages;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidChangeBatchException model) {
            setMessages(model.messages);
            this.message = model.getMessage();
        }

        public final Collection<String> getMessages() {
            return messages;
        }

        @Override
        public final Builder messages(Collection<String> messages) {
            this.messages = ErrorMessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(String... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        public final void setMessages(Collection<String> messages) {
            this.messages = ErrorMessagesCopier.copy(messages);
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public InvalidChangeBatchException build() {
            return new InvalidChangeBatchException(this);
        }
    }
}
