/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import static software.amazon.awssdk.util.StringUtils.UTF8;

import java.io.StringWriter;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;

import software.amazon.awssdk.util.StringInputStream;

import software.amazon.awssdk.util.XmlWriter;

/**
 * CreateHostedZoneRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateHostedZoneRequestMarshaller implements Marshaller<Request<CreateHostedZoneRequest>, CreateHostedZoneRequest> {

    public Request<CreateHostedZoneRequest> marshall(CreateHostedZoneRequest createHostedZoneRequest) {

        if (createHostedZoneRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateHostedZoneRequest> request = new DefaultRequest<CreateHostedZoneRequest>(createHostedZoneRequest,
                "Route53Client");

        request.setHttpMethod(HttpMethodName.POST);

        String uriResourcePath = "/2013-04-01/hostedzone";

        request.setResourcePath(uriResourcePath);

        try {
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter(stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");

            xmlWriter.startElement("CreateHostedZoneRequest");

            if (createHostedZoneRequest.name() != null) {
                xmlWriter.startElement("Name").value(createHostedZoneRequest.name()).endElement();
            }

            VPC vpc = createHostedZoneRequest.vpc();
            if (vpc != null) {
                xmlWriter.startElement("VPC");

                if (vpc.vpcRegion() != null) {
                    xmlWriter.startElement("VPCRegion").value(vpc.vpcRegion()).endElement();
                }

                if (vpc.vpcId() != null) {
                    xmlWriter.startElement("VPCId").value(vpc.vpcId()).endElement();
                }
                xmlWriter.endElement();
            }

            if (createHostedZoneRequest.callerReference() != null) {
                xmlWriter.startElement("CallerReference").value(createHostedZoneRequest.callerReference()).endElement();
            }

            HostedZoneConfig hostedZoneConfig = createHostedZoneRequest.hostedZoneConfig();
            if (hostedZoneConfig != null) {
                xmlWriter.startElement("HostedZoneConfig");

                if (hostedZoneConfig.comment() != null) {
                    xmlWriter.startElement("Comment").value(hostedZoneConfig.comment()).endElement();
                }

                if (hostedZoneConfig.privateZone() != null) {
                    xmlWriter.startElement("PrivateZone").value(hostedZoneConfig.privateZone()).endElement();
                }
                xmlWriter.endElement();
            }

            if (createHostedZoneRequest.delegationSetId() != null) {
                xmlWriter.startElement("DelegationSetId").value(createHostedZoneRequest.delegationSetId()).endElement();
            }
            xmlWriter.endElement();

            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }

        return request;
    }

}