/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListResourceRecordSetsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListResourceRecordSetsResponseUnmarshaller implements
        Unmarshaller<ListResourceRecordSetsResponse, StaxUnmarshallerContext> {

    public ListResourceRecordSetsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListResourceRecordSetsResponse.Builder listResourceRecordSetsResponse = ListResourceRecordSetsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<ResourceRecordSet> resourceRecordSets = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listResourceRecordSetsResponse.resourceRecordSets(resourceRecordSets);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("ResourceRecordSets", targetDepth)) {
                    resourceRecordSets = new ArrayList<ResourceRecordSet>();
                    continue;
                }

                if (context.testExpression("ResourceRecordSets/ResourceRecordSet", targetDepth)) {
                    resourceRecordSets.add(ResourceRecordSetUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("IsTruncated", targetDepth)) {
                    listResourceRecordSetsResponse.isTruncated(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextRecordName", targetDepth)) {
                    listResourceRecordSetsResponse.nextRecordName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextRecordType", targetDepth)) {
                    listResourceRecordSetsResponse.nextRecordType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextRecordIdentifier", targetDepth)) {
                    listResourceRecordSetsResponse.nextRecordIdentifier(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MaxItems", targetDepth)) {
                    listResourceRecordSetsResponse.maxItems(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listResourceRecordSetsResponse.resourceRecordSets(resourceRecordSets);
                    break;
                }
            }
        }
        return listResourceRecordSetsResponse.build();
    }

    private static final ListResourceRecordSetsResponseUnmarshaller INSTANCE = new ListResourceRecordSetsResponseUnmarshaller();

    public static ListResourceRecordSetsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
