/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.route53.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListReusableDelegationSetsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListReusableDelegationSetsResponseUnmarshaller implements
        Unmarshaller<ListReusableDelegationSetsResponse, StaxUnmarshallerContext> {

    public ListReusableDelegationSetsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListReusableDelegationSetsResponse.Builder listReusableDelegationSetsResponse = ListReusableDelegationSetsResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<DelegationSet> delegationSets = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listReusableDelegationSetsResponse.delegationSets(delegationSets);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("DelegationSets", targetDepth)) {
                    delegationSets = new ArrayList<DelegationSet>();
                    continue;
                }

                if (context.testExpression("DelegationSets/DelegationSet", targetDepth)) {
                    delegationSets.add(DelegationSetUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Marker", targetDepth)) {
                    listReusableDelegationSetsResponse.marker(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("IsTruncated", targetDepth)) {
                    listReusableDelegationSetsResponse.isTruncated(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextMarker", targetDepth)) {
                    listReusableDelegationSetsResponse.nextMarker(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MaxItems", targetDepth)) {
                    listReusableDelegationSetsResponse.maxItems(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listReusableDelegationSetsResponse.delegationSets(delegationSets);
                    break;
                }
            }
        }
        return listReusableDelegationSetsResponse.build();
    }

    private static final ListReusableDelegationSetsResponseUnmarshaller INSTANCE = new ListReusableDelegationSetsResponseUnmarshaller();

    public static ListReusableDelegationSetsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
