/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ViewBilling response includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ViewBillingResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ViewBillingResponse.Builder, ViewBillingResponse> {
    private final String nextPageMarker;

    private final List<BillingRecord> billingRecords;

    private ViewBillingResponse(BuilderImpl builder) {
        this.nextPageMarker = builder.nextPageMarker;
        this.billingRecords = builder.billingRecords;
    }

    /**
     * <p>
     * If there are more billing records than you specified for <code>MaxItems</code> in the request, submit another
     * request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
     * </p>
     * 
     * @return If there are more billing records than you specified for <code>MaxItems</code> in the request, submit
     *         another request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
     */
    public String nextPageMarker() {
        return nextPageMarker;
    }

    /**
     * <p>
     * A summary of billing records.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A summary of billing records.
     */
    public List<BillingRecord> billingRecords() {
        return billingRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((nextPageMarker() == null) ? 0 : nextPageMarker().hashCode());
        hashCode = 31 * hashCode + ((billingRecords() == null) ? 0 : billingRecords().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewBillingResponse)) {
            return false;
        }
        ViewBillingResponse other = (ViewBillingResponse) obj;
        if (other.nextPageMarker() == null ^ this.nextPageMarker() == null) {
            return false;
        }
        if (other.nextPageMarker() != null && !other.nextPageMarker().equals(this.nextPageMarker())) {
            return false;
        }
        if (other.billingRecords() == null ^ this.billingRecords() == null) {
            return false;
        }
        if (other.billingRecords() != null && !other.billingRecords().equals(this.billingRecords())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (nextPageMarker() != null) {
            sb.append("NextPageMarker: ").append(nextPageMarker()).append(",");
        }
        if (billingRecords() != null) {
            sb.append("BillingRecords: ").append(billingRecords()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ViewBillingResponse> {
        /**
         * <p>
         * If there are more billing records than you specified for <code>MaxItems</code> in the request, submit another
         * request and include the value of <code>NextPageMarker</code> in the value of <code>Marker</code>.
         * </p>
         * 
         * @param nextPageMarker
         *        If there are more billing records than you specified for <code>MaxItems</code> in the request, submit
         *        another request and include the value of <code>NextPageMarker</code> in the value of
         *        <code>Marker</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageMarker(String nextPageMarker);

        /**
         * <p>
         * A summary of billing records.
         * </p>
         * 
         * @param billingRecords
         *        A summary of billing records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingRecords(Collection<BillingRecord> billingRecords);

        /**
         * <p>
         * A summary of billing records.
         * </p>
         * 
         * @param billingRecords
         *        A summary of billing records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingRecords(BillingRecord... billingRecords);
    }

    private static final class BuilderImpl implements Builder {
        private String nextPageMarker;

        private List<BillingRecord> billingRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewBillingResponse model) {
            setNextPageMarker(model.nextPageMarker);
            setBillingRecords(model.billingRecords);
        }

        public final String getNextPageMarker() {
            return nextPageMarker;
        }

        @Override
        public final Builder nextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
            return this;
        }

        public final void setNextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
        }

        public final Collection<BillingRecord> getBillingRecords() {
            return billingRecords;
        }

        @Override
        public final Builder billingRecords(Collection<BillingRecord> billingRecords) {
            this.billingRecords = BillingRecordsCopier.copy(billingRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder billingRecords(BillingRecord... billingRecords) {
            billingRecords(Arrays.asList(billingRecords));
            return this;
        }

        public final void setBillingRecords(Collection<BillingRecord> billingRecords) {
            this.billingRecords = BillingRecordsCopier.copy(billingRecords);
        }

        @Override
        public ViewBillingResponse build() {
            return new ViewBillingResponse(this);
        }
    }
}
