/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListHostedZonesByNameRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListHostedZonesByNameRequest> {
    private final String dnsName;
    private final String hostedZoneId;
    private final String maxItems;

    private ListHostedZonesByNameRequest(BuilderImpl builder) {
        this.dnsName = builder.dnsName;
        this.hostedZoneId = builder.hostedZoneId;
        this.maxItems = builder.maxItems;
    }

    public String dnsName() {
        return this.dnsName;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dnsName() == null ? 0 : this.dnsName().hashCode());
        hashCode = 31 * hashCode + (this.hostedZoneId() == null ? 0 : this.hostedZoneId().hashCode());
        hashCode = 31 * hashCode + (this.maxItems() == null ? 0 : this.maxItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesByNameRequest)) {
            return false;
        }
        ListHostedZonesByNameRequest other = (ListHostedZonesByNameRequest)((Object)obj);
        if (other.dnsName() == null ^ this.dnsName() == null) {
            return false;
        }
        if (other.dnsName() != null && !other.dnsName().equals(this.dnsName())) {
            return false;
        }
        if (other.hostedZoneId() == null ^ this.hostedZoneId() == null) {
            return false;
        }
        if (other.hostedZoneId() != null && !other.hostedZoneId().equals(this.hostedZoneId())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        return other.maxItems() == null || other.maxItems().equals(this.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dnsName() != null) {
            sb.append("DNSName: ").append(this.dnsName()).append(",");
        }
        if (this.hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(this.hostedZoneId()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dnsName;
        private String hostedZoneId;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZonesByNameRequest model) {
            this.setDNSName(model.dnsName);
            this.setHostedZoneId(model.hostedZoneId);
            this.setMaxItems(model.maxItems);
        }

        public final String getDNSName() {
            return this.dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDNSName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        public ListHostedZonesByNameRequest build() {
            return new ListHostedZonesByNameRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListHostedZonesByNameRequest> {
        public Builder dnsName(String var1);

        public Builder hostedZoneId(String var1);

        public Builder maxItems(String var1);
    }
}

