/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum RRType {
    SOA("SOA"),
    A("A"),
    TXT("TXT"),
    NS("NS"),
    CNAME("CNAME"),
    MX("MX"),
    NAPTR("NAPTR"),
    PTR("PTR"),
    SRV("SRV"),
    SPF("SPF"),
    AAAA("AAAA");

    private final String value;

    private RRType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static RRType fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(RRType.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

