/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.route53.model.AlarmIdentifier;
import software.amazon.awssdk.services.route53.model.UpdateHealthCheckRequest;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.XmlWriter;

public class UpdateHealthCheckRequestMarshaller
implements Marshaller<Request<UpdateHealthCheckRequest>, UpdateHealthCheckRequest> {
    public Request<UpdateHealthCheckRequest> marshall(UpdateHealthCheckRequest updateHealthCheckRequest) {
        if (updateHealthCheckRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateHealthCheckRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/healthcheck/{HealthCheckId}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "HealthCheckId", updateHealthCheckRequest.healthCheckId());
        request.setResourcePath(uriResourcePath);
        try {
            AlarmIdentifier alarmIdentifier;
            List<String> updateHealthCheckRequestRegionsList;
            List<String> updateHealthCheckRequestChildHealthChecksList;
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
            xmlWriter.startElement("UpdateHealthCheckRequest");
            if (updateHealthCheckRequest.healthCheckVersion() != null) {
                xmlWriter.startElement("HealthCheckVersion").value((Object)updateHealthCheckRequest.healthCheckVersion()).endElement();
            }
            if (updateHealthCheckRequest.ipAddress() != null) {
                xmlWriter.startElement("IPAddress").value(updateHealthCheckRequest.ipAddress()).endElement();
            }
            if (updateHealthCheckRequest.port() != null) {
                xmlWriter.startElement("Port").value((Object)updateHealthCheckRequest.port()).endElement();
            }
            if (updateHealthCheckRequest.resourcePath() != null) {
                xmlWriter.startElement("ResourcePath").value(updateHealthCheckRequest.resourcePath()).endElement();
            }
            if (updateHealthCheckRequest.fullyQualifiedDomainName() != null) {
                xmlWriter.startElement("FullyQualifiedDomainName").value(updateHealthCheckRequest.fullyQualifiedDomainName()).endElement();
            }
            if (updateHealthCheckRequest.searchString() != null) {
                xmlWriter.startElement("SearchString").value(updateHealthCheckRequest.searchString()).endElement();
            }
            if (updateHealthCheckRequest.failureThreshold() != null) {
                xmlWriter.startElement("FailureThreshold").value((Object)updateHealthCheckRequest.failureThreshold()).endElement();
            }
            if (updateHealthCheckRequest.inverted() != null) {
                xmlWriter.startElement("Inverted").value((Object)updateHealthCheckRequest.inverted()).endElement();
            }
            if (updateHealthCheckRequest.healthThreshold() != null) {
                xmlWriter.startElement("HealthThreshold").value((Object)updateHealthCheckRequest.healthThreshold()).endElement();
            }
            if ((updateHealthCheckRequestChildHealthChecksList = updateHealthCheckRequest.childHealthChecks()) != null) {
                xmlWriter.startElement("ChildHealthChecks");
                for (String string : updateHealthCheckRequestChildHealthChecksList) {
                    xmlWriter.startElement("ChildHealthCheck");
                    xmlWriter.value(string);
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (updateHealthCheckRequest.enableSNI() != null) {
                xmlWriter.startElement("EnableSNI").value((Object)updateHealthCheckRequest.enableSNI()).endElement();
            }
            if ((updateHealthCheckRequestRegionsList = updateHealthCheckRequest.regions()) != null) {
                xmlWriter.startElement("Regions");
                for (String updateHealthCheckRequestRegionsListValue : updateHealthCheckRequestRegionsList) {
                    xmlWriter.startElement("Region");
                    xmlWriter.value(updateHealthCheckRequestRegionsListValue);
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if ((alarmIdentifier = updateHealthCheckRequest.alarmIdentifier()) != null) {
                xmlWriter.startElement("AlarmIdentifier");
                if (alarmIdentifier.region() != null) {
                    xmlWriter.startElement("Region").value(alarmIdentifier.region()).endElement();
                }
                if (alarmIdentifier.name() != null) {
                    xmlWriter.startElement("Name").value(alarmIdentifier.name()).endElement();
                }
                xmlWriter.endElement();
            }
            if (updateHealthCheckRequest.insufficientDataHealthStatus() != null) {
                xmlWriter.startElement("InsufficientDataHealthStatus").value(updateHealthCheckRequest.insufficientDataHealthStatus()).endElement();
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

