/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.route53domains.model.Tag;
import software.amazon.awssdk.services.route53domains.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateTagsForDomainRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateTagsForDomainRequest> {
    private final String domainName;
    private final List<Tag> tagsToUpdate;

    private UpdateTagsForDomainRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.tagsToUpdate = builder.tagsToUpdate;
    }

    public String domainName() {
        return this.domainName;
    }

    public List<Tag> tagsToUpdate() {
        return this.tagsToUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.tagsToUpdate() == null ? 0 : this.tagsToUpdate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTagsForDomainRequest)) {
            return false;
        }
        UpdateTagsForDomainRequest other = (UpdateTagsForDomainRequest)((Object)obj);
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.tagsToUpdate() == null ^ this.tagsToUpdate() == null) {
            return false;
        }
        return other.tagsToUpdate() == null || other.tagsToUpdate().equals(this.tagsToUpdate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.tagsToUpdate() != null) {
            sb.append("TagsToUpdate: ").append(this.tagsToUpdate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String domainName;
        private List<Tag> tagsToUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTagsForDomainRequest model) {
            this.setDomainName(model.domainName);
            this.setTagsToUpdate(model.tagsToUpdate);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<Tag> getTagsToUpdate() {
            return this.tagsToUpdate;
        }

        @Override
        public final Builder tagsToUpdate(Collection<Tag> tagsToUpdate) {
            this.tagsToUpdate = TagListCopier.copy(tagsToUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToUpdate(Tag ... tagsToUpdate) {
            this.tagsToUpdate(Arrays.asList(tagsToUpdate));
            return this;
        }

        public final void setTagsToUpdate(Collection<Tag> tagsToUpdate) {
            this.tagsToUpdate = TagListCopier.copy(tagsToUpdate);
        }

        public UpdateTagsForDomainRequest build() {
            return new UpdateTagsForDomainRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateTagsForDomainRequest> {
        public Builder domainName(String var1);

        public Builder tagsToUpdate(Collection<Tag> var1);

        public Builder tagsToUpdate(Tag ... var1);
    }
}

