/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about the CloudWatch alarm that Amazon Route 53 is monitoring for this
 * health check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CloudWatchAlarmConfiguration implements
        ToCopyableBuilder<CloudWatchAlarmConfiguration.Builder, CloudWatchAlarmConfiguration> {
    private final Integer evaluationPeriods;

    private final Double threshold;

    private final String comparisonOperator;

    private final Integer period;

    private final String metricName;

    private final String namespace;

    private final String statistic;

    private final List<Dimension> dimensions;

    private CloudWatchAlarmConfiguration(BuilderImpl builder) {
        this.evaluationPeriods = builder.evaluationPeriods;
        this.threshold = builder.threshold;
        this.comparisonOperator = builder.comparisonOperator;
        this.period = builder.period;
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
        this.statistic = builder.statistic;
        this.dimensions = builder.dimensions;
    }

    /**
     * <p>
     * For the metric that the CloudWatch alarm is associated with, the number of periods that the metric is compared to
     * the threshold.
     * </p>
     * 
     * @return For the metric that the CloudWatch alarm is associated with, the number of periods that the metric is
     *         compared to the threshold.
     */
    public Integer evaluationPeriods() {
        return evaluationPeriods;
    }

    /**
     * <p>
     * For the metric that the CloudWatch alarm is associated with, the value the metric is compared with.
     * </p>
     * 
     * @return For the metric that the CloudWatch alarm is associated with, the value the metric is compared with.
     */
    public Double threshold() {
        return threshold;
    }

    /**
     * <p>
     * For the metric that the CloudWatch alarm is associated with, the arithmetic operation that is used for the
     * comparison.
     * </p>
     * 
     * @return For the metric that the CloudWatch alarm is associated with, the arithmetic operation that is used for
     *         the comparison.
     * @see ComparisonOperator
     */
    public String comparisonOperator() {
        return comparisonOperator;
    }

    /**
     * <p>
     * For the metric that the CloudWatch alarm is associated with, the duration of one evaluation period in seconds.
     * </p>
     * 
     * @return For the metric that the CloudWatch alarm is associated with, the duration of one evaluation period in
     *         seconds.
     */
    public Integer period() {
        return period;
    }

    /**
     * <p>
     * The name of the CloudWatch metric that the alarm is associated with.
     * </p>
     * 
     * @return The name of the CloudWatch metric that the alarm is associated with.
     */
    public String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The namespace of the metric that the alarm is associated with. For more information, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html">Amazon
     * CloudWatch Namespaces, Dimensions, and Metrics Reference</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * 
     * @return The namespace of the metric that the alarm is associated with. For more information, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html">Amazon
     *         CloudWatch Namespaces, Dimensions, and Metrics Reference</a> in the <i>Amazon CloudWatch User Guide</i>.
     */
    public String namespace() {
        return namespace;
    }

    /**
     * <p>
     * For the metric that the CloudWatch alarm is associated with, the statistic that is applied to the metric.
     * </p>
     * 
     * @return For the metric that the CloudWatch alarm is associated with, the statistic that is applied to the metric.
     * @see Statistic
     */
    public String statistic() {
        return statistic;
    }

    /**
     * <p>
     * For the metric that the CloudWatch alarm is associated with, a complex type that contains information about the
     * dimensions for the metric. For information, see <a
     * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html">Amazon
     * CloudWatch Namespaces, Dimensions, and Metrics Reference</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return For the metric that the CloudWatch alarm is associated with, a complex type that contains information
     *         about the dimensions for the metric. For information, see <a
     *         href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html">Amazon
     *         CloudWatch Namespaces, Dimensions, and Metrics Reference</a> in the <i>Amazon CloudWatch User Guide</i>.
     */
    public List<Dimension> dimensions() {
        return dimensions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((evaluationPeriods() == null) ? 0 : evaluationPeriods().hashCode());
        hashCode = 31 * hashCode + ((threshold() == null) ? 0 : threshold().hashCode());
        hashCode = 31 * hashCode + ((comparisonOperator() == null) ? 0 : comparisonOperator().hashCode());
        hashCode = 31 * hashCode + ((period() == null) ? 0 : period().hashCode());
        hashCode = 31 * hashCode + ((metricName() == null) ? 0 : metricName().hashCode());
        hashCode = 31 * hashCode + ((namespace() == null) ? 0 : namespace().hashCode());
        hashCode = 31 * hashCode + ((statistic() == null) ? 0 : statistic().hashCode());
        hashCode = 31 * hashCode + ((dimensions() == null) ? 0 : dimensions().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchAlarmConfiguration)) {
            return false;
        }
        CloudWatchAlarmConfiguration other = (CloudWatchAlarmConfiguration) obj;
        if (other.evaluationPeriods() == null ^ this.evaluationPeriods() == null) {
            return false;
        }
        if (other.evaluationPeriods() != null && !other.evaluationPeriods().equals(this.evaluationPeriods())) {
            return false;
        }
        if (other.threshold() == null ^ this.threshold() == null) {
            return false;
        }
        if (other.threshold() != null && !other.threshold().equals(this.threshold())) {
            return false;
        }
        if (other.comparisonOperator() == null ^ this.comparisonOperator() == null) {
            return false;
        }
        if (other.comparisonOperator() != null && !other.comparisonOperator().equals(this.comparisonOperator())) {
            return false;
        }
        if (other.period() == null ^ this.period() == null) {
            return false;
        }
        if (other.period() != null && !other.period().equals(this.period())) {
            return false;
        }
        if (other.metricName() == null ^ this.metricName() == null) {
            return false;
        }
        if (other.metricName() != null && !other.metricName().equals(this.metricName())) {
            return false;
        }
        if (other.namespace() == null ^ this.namespace() == null) {
            return false;
        }
        if (other.namespace() != null && !other.namespace().equals(this.namespace())) {
            return false;
        }
        if (other.statistic() == null ^ this.statistic() == null) {
            return false;
        }
        if (other.statistic() != null && !other.statistic().equals(this.statistic())) {
            return false;
        }
        if (other.dimensions() == null ^ this.dimensions() == null) {
            return false;
        }
        if (other.dimensions() != null && !other.dimensions().equals(this.dimensions())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (evaluationPeriods() != null) {
            sb.append("EvaluationPeriods: ").append(evaluationPeriods()).append(",");
        }
        if (threshold() != null) {
            sb.append("Threshold: ").append(threshold()).append(",");
        }
        if (comparisonOperator() != null) {
            sb.append("ComparisonOperator: ").append(comparisonOperator()).append(",");
        }
        if (period() != null) {
            sb.append("Period: ").append(period()).append(",");
        }
        if (metricName() != null) {
            sb.append("MetricName: ").append(metricName()).append(",");
        }
        if (namespace() != null) {
            sb.append("Namespace: ").append(namespace()).append(",");
        }
        if (statistic() != null) {
            sb.append("Statistic: ").append(statistic()).append(",");
        }
        if (dimensions() != null) {
            sb.append("Dimensions: ").append(dimensions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CloudWatchAlarmConfiguration> {
        /**
         * <p>
         * For the metric that the CloudWatch alarm is associated with, the number of periods that the metric is
         * compared to the threshold.
         * </p>
         * 
         * @param evaluationPeriods
         *        For the metric that the CloudWatch alarm is associated with, the number of periods that the metric is
         *        compared to the threshold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationPeriods(Integer evaluationPeriods);

        /**
         * <p>
         * For the metric that the CloudWatch alarm is associated with, the value the metric is compared with.
         * </p>
         * 
         * @param threshold
         *        For the metric that the CloudWatch alarm is associated with, the value the metric is compared with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Double threshold);

        /**
         * <p>
         * For the metric that the CloudWatch alarm is associated with, the arithmetic operation that is used for the
         * comparison.
         * </p>
         * 
         * @param comparisonOperator
         *        For the metric that the CloudWatch alarm is associated with, the arithmetic operation that is used for
         *        the comparison.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(String comparisonOperator);

        /**
         * <p>
         * For the metric that the CloudWatch alarm is associated with, the arithmetic operation that is used for the
         * comparison.
         * </p>
         * 
         * @param comparisonOperator
         *        For the metric that the CloudWatch alarm is associated with, the arithmetic operation that is used for
         *        the comparison.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(ComparisonOperator comparisonOperator);

        /**
         * <p>
         * For the metric that the CloudWatch alarm is associated with, the duration of one evaluation period in
         * seconds.
         * </p>
         * 
         * @param period
         *        For the metric that the CloudWatch alarm is associated with, the duration of one evaluation period in
         *        seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(Integer period);

        /**
         * <p>
         * The name of the CloudWatch metric that the alarm is associated with.
         * </p>
         * 
         * @param metricName
         *        The name of the CloudWatch metric that the alarm is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The namespace of the metric that the alarm is associated with. For more information, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html">Amazon
         * CloudWatch Namespaces, Dimensions, and Metrics Reference</a> in the <i>Amazon CloudWatch User Guide</i>.
         * </p>
         * 
         * @param namespace
         *        The namespace of the metric that the alarm is associated with. For more information, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html"
         *        >Amazon CloudWatch Namespaces, Dimensions, and Metrics Reference</a> in the <i>Amazon CloudWatch User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * For the metric that the CloudWatch alarm is associated with, the statistic that is applied to the metric.
         * </p>
         * 
         * @param statistic
         *        For the metric that the CloudWatch alarm is associated with, the statistic that is applied to the
         *        metric.
         * @see Statistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Statistic
         */
        Builder statistic(String statistic);

        /**
         * <p>
         * For the metric that the CloudWatch alarm is associated with, the statistic that is applied to the metric.
         * </p>
         * 
         * @param statistic
         *        For the metric that the CloudWatch alarm is associated with, the statistic that is applied to the
         *        metric.
         * @see Statistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Statistic
         */
        Builder statistic(Statistic statistic);

        /**
         * <p>
         * For the metric that the CloudWatch alarm is associated with, a complex type that contains information about
         * the dimensions for the metric. For information, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html">Amazon
         * CloudWatch Namespaces, Dimensions, and Metrics Reference</a> in the <i>Amazon CloudWatch User Guide</i>.
         * </p>
         * 
         * @param dimensions
         *        For the metric that the CloudWatch alarm is associated with, a complex type that contains information
         *        about the dimensions for the metric. For information, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html"
         *        >Amazon CloudWatch Namespaces, Dimensions, and Metrics Reference</a> in the <i>Amazon CloudWatch User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<Dimension> dimensions);

        /**
         * <p>
         * For the metric that the CloudWatch alarm is associated with, a complex type that contains information about
         * the dimensions for the metric. For information, see <a
         * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html">Amazon
         * CloudWatch Namespaces, Dimensions, and Metrics Reference</a> in the <i>Amazon CloudWatch User Guide</i>.
         * </p>
         * 
         * @param dimensions
         *        For the metric that the CloudWatch alarm is associated with, a complex type that contains information
         *        about the dimensions for the metric. For information, see <a
         *        href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html"
         *        >Amazon CloudWatch Namespaces, Dimensions, and Metrics Reference</a> in the <i>Amazon CloudWatch User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Dimension... dimensions);
    }

    private static final class BuilderImpl implements Builder {
        private Integer evaluationPeriods;

        private Double threshold;

        private String comparisonOperator;

        private Integer period;

        private String metricName;

        private String namespace;

        private String statistic;

        private List<Dimension> dimensions;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchAlarmConfiguration model) {
            setEvaluationPeriods(model.evaluationPeriods);
            setThreshold(model.threshold);
            setComparisonOperator(model.comparisonOperator);
            setPeriod(model.period);
            setMetricName(model.metricName);
            setNamespace(model.namespace);
            setStatistic(model.statistic);
            setDimensions(model.dimensions);
        }

        public final Integer getEvaluationPeriods() {
            return evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        public final Double getThreshold() {
            return threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public final String getComparisonOperator() {
            return comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Integer getPeriod() {
            return period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getStatistic() {
            return statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(Statistic statistic) {
            this.statistic(statistic.toString());
            return this;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        public final Collection<Dimension> getDimensions() {
            return dimensions;
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionListCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        public final void setDimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionListCopier.copy(dimensions);
        }

        @Override
        public CloudWatchAlarmConfiguration build() {
            return new CloudWatchAlarmConfiguration(this);
        }
    }
}
