/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type containing the response information for the hosted zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateHostedZoneResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateHostedZoneResponse.Builder, CreateHostedZoneResponse> {
    private final HostedZone hostedZone;

    private final ChangeInfo changeInfo;

    private final DelegationSet delegationSet;

    private final VPC vpc;

    private final String location;

    private CreateHostedZoneResponse(BuilderImpl builder) {
        this.hostedZone = builder.hostedZone;
        this.changeInfo = builder.changeInfo;
        this.delegationSet = builder.delegationSet;
        this.vpc = builder.vpc;
        this.location = builder.location;
    }

    /**
     * <p>
     * A complex type that contains general information about the hosted zone.
     * </p>
     * 
     * @return A complex type that contains general information about the hosted zone.
     */
    public HostedZone hostedZone() {
        return hostedZone;
    }

    /**
     * <p>
     * A complex type that contains information about the <code>CreateHostedZone</code> request.
     * </p>
     * 
     * @return A complex type that contains information about the <code>CreateHostedZone</code> request.
     */
    public ChangeInfo changeInfo() {
        return changeInfo;
    }

    /**
     * <p>
     * A complex type that describes the name servers for this hosted zone.
     * </p>
     * 
     * @return A complex type that describes the name servers for this hosted zone.
     */
    public DelegationSet delegationSet() {
        return delegationSet;
    }

    /**
     * <p>
     * A complex type that contains information about an Amazon VPC that you associated with this hosted zone.
     * </p>
     * 
     * @return A complex type that contains information about an Amazon VPC that you associated with this hosted zone.
     */
    public VPC vpc() {
        return vpc;
    }

    /**
     * <p>
     * The unique URL representing the new hosted zone.
     * </p>
     * 
     * @return The unique URL representing the new hosted zone.
     */
    public String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((hostedZone() == null) ? 0 : hostedZone().hashCode());
        hashCode = 31 * hashCode + ((changeInfo() == null) ? 0 : changeInfo().hashCode());
        hashCode = 31 * hashCode + ((delegationSet() == null) ? 0 : delegationSet().hashCode());
        hashCode = 31 * hashCode + ((vpc() == null) ? 0 : vpc().hashCode());
        hashCode = 31 * hashCode + ((location() == null) ? 0 : location().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHostedZoneResponse)) {
            return false;
        }
        CreateHostedZoneResponse other = (CreateHostedZoneResponse) obj;
        if (other.hostedZone() == null ^ this.hostedZone() == null) {
            return false;
        }
        if (other.hostedZone() != null && !other.hostedZone().equals(this.hostedZone())) {
            return false;
        }
        if (other.changeInfo() == null ^ this.changeInfo() == null) {
            return false;
        }
        if (other.changeInfo() != null && !other.changeInfo().equals(this.changeInfo())) {
            return false;
        }
        if (other.delegationSet() == null ^ this.delegationSet() == null) {
            return false;
        }
        if (other.delegationSet() != null && !other.delegationSet().equals(this.delegationSet())) {
            return false;
        }
        if (other.vpc() == null ^ this.vpc() == null) {
            return false;
        }
        if (other.vpc() != null && !other.vpc().equals(this.vpc())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (hostedZone() != null) {
            sb.append("HostedZone: ").append(hostedZone()).append(",");
        }
        if (changeInfo() != null) {
            sb.append("ChangeInfo: ").append(changeInfo()).append(",");
        }
        if (delegationSet() != null) {
            sb.append("DelegationSet: ").append(delegationSet()).append(",");
        }
        if (vpc() != null) {
            sb.append("VPC: ").append(vpc()).append(",");
        }
        if (location() != null) {
            sb.append("Location: ").append(location()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateHostedZoneResponse> {
        /**
         * <p>
         * A complex type that contains general information about the hosted zone.
         * </p>
         * 
         * @param hostedZone
         *        A complex type that contains general information about the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZone(HostedZone hostedZone);

        /**
         * <p>
         * A complex type that contains information about the <code>CreateHostedZone</code> request.
         * </p>
         * 
         * @param changeInfo
         *        A complex type that contains information about the <code>CreateHostedZone</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeInfo(ChangeInfo changeInfo);

        /**
         * <p>
         * A complex type that describes the name servers for this hosted zone.
         * </p>
         * 
         * @param delegationSet
         *        A complex type that describes the name servers for this hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationSet(DelegationSet delegationSet);

        /**
         * <p>
         * A complex type that contains information about an Amazon VPC that you associated with this hosted zone.
         * </p>
         * 
         * @param vpc
         *        A complex type that contains information about an Amazon VPC that you associated with this hosted
         *        zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(VPC vpc);

        /**
         * <p>
         * The unique URL representing the new hosted zone.
         * </p>
         * 
         * @param location
         *        The unique URL representing the new hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    private static final class BuilderImpl implements Builder {
        private HostedZone hostedZone;

        private ChangeInfo changeInfo;

        private DelegationSet delegationSet;

        private VPC vpc;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHostedZoneResponse model) {
            setHostedZone(model.hostedZone);
            setChangeInfo(model.changeInfo);
            setDelegationSet(model.delegationSet);
            setVPC(model.vpc);
            setLocation(model.location);
        }

        public final HostedZone getHostedZone() {
            return hostedZone;
        }

        @Override
        public final Builder hostedZone(HostedZone hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        public final void setHostedZone(HostedZone hostedZone) {
            this.hostedZone = hostedZone;
        }

        public final ChangeInfo getChangeInfo() {
            return changeInfo;
        }

        @Override
        public final Builder changeInfo(ChangeInfo changeInfo) {
            this.changeInfo = changeInfo;
            return this;
        }

        public final void setChangeInfo(ChangeInfo changeInfo) {
            this.changeInfo = changeInfo;
        }

        public final DelegationSet getDelegationSet() {
            return delegationSet;
        }

        @Override
        public final Builder delegationSet(DelegationSet delegationSet) {
            this.delegationSet = delegationSet;
            return this;
        }

        public final void setDelegationSet(DelegationSet delegationSet) {
            this.delegationSet = delegationSet;
        }

        public final VPC getVPC() {
            return vpc;
        }

        @Override
        public final Builder vpc(VPC vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVPC(VPC vpc) {
            this.vpc = vpc;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public CreateHostedZoneResponse build() {
            return new CreateHostedZoneResponse(this);
        }
    }
}
