/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contain the response to a <code>GetHostedZone</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetHostedZoneResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetHostedZoneResponse.Builder, GetHostedZoneResponse> {
    private final HostedZone hostedZone;

    private final DelegationSet delegationSet;

    private final List<VPC> vpCs;

    private GetHostedZoneResponse(BuilderImpl builder) {
        this.hostedZone = builder.hostedZone;
        this.delegationSet = builder.delegationSet;
        this.vpCs = builder.vpCs;
    }

    /**
     * <p>
     * A complex type that contains general information about the specified hosted zone.
     * </p>
     * 
     * @return A complex type that contains general information about the specified hosted zone.
     */
    public HostedZone hostedZone() {
        return hostedZone;
    }

    /**
     * <p>
     * A complex type that lists the Amazon Route 53 name servers for the specified hosted zone.
     * </p>
     * 
     * @return A complex type that lists the Amazon Route 53 name servers for the specified hosted zone.
     */
    public DelegationSet delegationSet() {
        return delegationSet;
    }

    /**
     * <p>
     * A complex type that contains information about the VPCs that are associated with the specified hosted zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains information about the VPCs that are associated with the specified hosted
     *         zone.
     */
    public List<VPC> vpCs() {
        return vpCs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((hostedZone() == null) ? 0 : hostedZone().hashCode());
        hashCode = 31 * hashCode + ((delegationSet() == null) ? 0 : delegationSet().hashCode());
        hashCode = 31 * hashCode + ((vpCs() == null) ? 0 : vpCs().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostedZoneResponse)) {
            return false;
        }
        GetHostedZoneResponse other = (GetHostedZoneResponse) obj;
        if (other.hostedZone() == null ^ this.hostedZone() == null) {
            return false;
        }
        if (other.hostedZone() != null && !other.hostedZone().equals(this.hostedZone())) {
            return false;
        }
        if (other.delegationSet() == null ^ this.delegationSet() == null) {
            return false;
        }
        if (other.delegationSet() != null && !other.delegationSet().equals(this.delegationSet())) {
            return false;
        }
        if (other.vpCs() == null ^ this.vpCs() == null) {
            return false;
        }
        if (other.vpCs() != null && !other.vpCs().equals(this.vpCs())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (hostedZone() != null) {
            sb.append("HostedZone: ").append(hostedZone()).append(",");
        }
        if (delegationSet() != null) {
            sb.append("DelegationSet: ").append(delegationSet()).append(",");
        }
        if (vpCs() != null) {
            sb.append("VPCs: ").append(vpCs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetHostedZoneResponse> {
        /**
         * <p>
         * A complex type that contains general information about the specified hosted zone.
         * </p>
         * 
         * @param hostedZone
         *        A complex type that contains general information about the specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZone(HostedZone hostedZone);

        /**
         * <p>
         * A complex type that lists the Amazon Route 53 name servers for the specified hosted zone.
         * </p>
         * 
         * @param delegationSet
         *        A complex type that lists the Amazon Route 53 name servers for the specified hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delegationSet(DelegationSet delegationSet);

        /**
         * <p>
         * A complex type that contains information about the VPCs that are associated with the specified hosted zone.
         * </p>
         * 
         * @param vpCs
         *        A complex type that contains information about the VPCs that are associated with the specified hosted
         *        zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpCs(Collection<VPC> vpCs);

        /**
         * <p>
         * A complex type that contains information about the VPCs that are associated with the specified hosted zone.
         * </p>
         * 
         * @param vpCs
         *        A complex type that contains information about the VPCs that are associated with the specified hosted
         *        zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpCs(VPC... vpCs);
    }

    private static final class BuilderImpl implements Builder {
        private HostedZone hostedZone;

        private DelegationSet delegationSet;

        private List<VPC> vpCs;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostedZoneResponse model) {
            setHostedZone(model.hostedZone);
            setDelegationSet(model.delegationSet);
            setVPCs(model.vpCs);
        }

        public final HostedZone getHostedZone() {
            return hostedZone;
        }

        @Override
        public final Builder hostedZone(HostedZone hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        public final void setHostedZone(HostedZone hostedZone) {
            this.hostedZone = hostedZone;
        }

        public final DelegationSet getDelegationSet() {
            return delegationSet;
        }

        @Override
        public final Builder delegationSet(DelegationSet delegationSet) {
            this.delegationSet = delegationSet;
            return this;
        }

        public final void setDelegationSet(DelegationSet delegationSet) {
            this.delegationSet = delegationSet;
        }

        public final Collection<VPC> getVPCs() {
            return vpCs;
        }

        @Override
        public final Builder vpCs(Collection<VPC> vpCs) {
            this.vpCs = VPCsCopier.copy(vpCs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpCs(VPC... vpCs) {
            vpCs(Arrays.asList(vpCs));
            return this;
        }

        public final void setVPCs(Collection<VPC> vpCs) {
            this.vpCs = VPCsCopier.copy(vpCs);
        }

        @Override
        public GetHostedZoneResponse build() {
            return new GetHostedZoneResponse(this);
        }
    }
}
