/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListHostedZonesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListHostedZonesResponse.Builder, ListHostedZonesResponse> {
    private final List<HostedZone> hostedZones;

    private final String marker;

    private final Boolean isTruncated;

    private final String nextMarker;

    private final String maxItems;

    private ListHostedZonesResponse(BuilderImpl builder) {
        this.hostedZones = builder.hostedZones;
        this.marker = builder.marker;
        this.isTruncated = builder.isTruncated;
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * A complex type that contains general information about the hosted zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains general information about the hosted zone.
     */
    public List<HostedZone> hostedZones() {
        return hostedZones;
    }

    /**
     * <p>
     * For the second and subsequent calls to <code>ListHostedZones</code>, <code>Marker</code> is the value that you
     * specified for the <code>marker</code> parameter in the request that produced the current response.
     * </p>
     * 
     * @return For the second and subsequent calls to <code>ListHostedZones</code>, <code>Marker</code> is the value
     *         that you specified for the <code>marker</code> parameter in the request that produced the current
     *         response.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * A flag indicating whether there are more hosted zones to be listed. If the response was truncated, you can get
     * more hosted zones by submitting another <code>ListHostedZones</code> request and specifying the value of
     * <code>NextMarker</code> in the <code>marker</code> parameter.
     * </p>
     * 
     * @return A flag indicating whether there are more hosted zones to be listed. If the response was truncated, you
     *         can get more hosted zones by submitting another <code>ListHostedZones</code> request and specifying the
     *         value of <code>NextMarker</code> in the <code>marker</code> parameter.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the first
     * hosted zone in the next group of hosted zones. Submit another <code>ListHostedZones</code> request, and specify
     * the value of <code>NextMarker</code> from the response in the <code>marker</code> parameter.
     * </p>
     * <p>
     * This element is present only if <code>IsTruncated</code> is <code>true</code>.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the
     *         first hosted zone in the next group of hosted zones. Submit another <code>ListHostedZones</code> request,
     *         and specify the value of <code>NextMarker</code> from the response in the <code>marker</code>
     *         parameter.</p>
     *         <p>
     *         This element is present only if <code>IsTruncated</code> is <code>true</code>.
     */
    public String nextMarker() {
        return nextMarker;
    }

    /**
     * <p>
     * The value that you specified for the <code>maxitems</code> parameter in the call to <code>ListHostedZones</code>
     * that produced the current response.
     * </p>
     * 
     * @return The value that you specified for the <code>maxitems</code> parameter in the call to
     *         <code>ListHostedZones</code> that produced the current response.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((hostedZones() == null) ? 0 : hostedZones().hashCode());
        hashCode = 31 * hashCode + ((marker() == null) ? 0 : marker().hashCode());
        hashCode = 31 * hashCode + ((isTruncated() == null) ? 0 : isTruncated().hashCode());
        hashCode = 31 * hashCode + ((nextMarker() == null) ? 0 : nextMarker().hashCode());
        hashCode = 31 * hashCode + ((maxItems() == null) ? 0 : maxItems().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesResponse)) {
            return false;
        }
        ListHostedZonesResponse other = (ListHostedZonesResponse) obj;
        if (other.hostedZones() == null ^ this.hostedZones() == null) {
            return false;
        }
        if (other.hostedZones() != null && !other.hostedZones().equals(this.hostedZones())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (hostedZones() != null) {
            sb.append("HostedZones: ").append(hostedZones()).append(",");
        }
        if (marker() != null) {
            sb.append("Marker: ").append(marker()).append(",");
        }
        if (isTruncated() != null) {
            sb.append("IsTruncated: ").append(isTruncated()).append(",");
        }
        if (nextMarker() != null) {
            sb.append("NextMarker: ").append(nextMarker()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListHostedZonesResponse> {
        /**
         * <p>
         * A complex type that contains general information about the hosted zone.
         * </p>
         * 
         * @param hostedZones
         *        A complex type that contains general information about the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZones(Collection<HostedZone> hostedZones);

        /**
         * <p>
         * A complex type that contains general information about the hosted zone.
         * </p>
         * 
         * @param hostedZones
         *        A complex type that contains general information about the hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZones(HostedZone... hostedZones);

        /**
         * <p>
         * For the second and subsequent calls to <code>ListHostedZones</code>, <code>Marker</code> is the value that
         * you specified for the <code>marker</code> parameter in the request that produced the current response.
         * </p>
         * 
         * @param marker
         *        For the second and subsequent calls to <code>ListHostedZones</code>, <code>Marker</code> is the value
         *        that you specified for the <code>marker</code> parameter in the request that produced the current
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A flag indicating whether there are more hosted zones to be listed. If the response was truncated, you can
         * get more hosted zones by submitting another <code>ListHostedZones</code> request and specifying the value of
         * <code>NextMarker</code> in the <code>marker</code> parameter.
         * </p>
         * 
         * @param isTruncated
         *        A flag indicating whether there are more hosted zones to be listed. If the response was truncated, you
         *        can get more hosted zones by submitting another <code>ListHostedZones</code> request and specifying
         *        the value of <code>NextMarker</code> in the <code>marker</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the first
         * hosted zone in the next group of hosted zones. Submit another <code>ListHostedZones</code> request, and
         * specify the value of <code>NextMarker</code> from the response in the <code>marker</code> parameter.
         * </p>
         * <p>
         * This element is present only if <code>IsTruncated</code> is <code>true</code>.
         * </p>
         * 
         * @param nextMarker
         *        If <code>IsTruncated</code> is <code>true</code>, the value of <code>NextMarker</code> identifies the
         *        first hosted zone in the next group of hosted zones. Submit another <code>ListHostedZones</code>
         *        request, and specify the value of <code>NextMarker</code> from the response in the <code>marker</code>
         *        parameter.</p>
         *        <p>
         *        This element is present only if <code>IsTruncated</code> is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * The value that you specified for the <code>maxitems</code> parameter in the call to
         * <code>ListHostedZones</code> that produced the current response.
         * </p>
         * 
         * @param maxItems
         *        The value that you specified for the <code>maxitems</code> parameter in the call to
         *        <code>ListHostedZones</code> that produced the current response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    private static final class BuilderImpl implements Builder {
        private List<HostedZone> hostedZones;

        private String marker;

        private Boolean isTruncated;

        private String nextMarker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZonesResponse model) {
            setHostedZones(model.hostedZones);
            setMarker(model.marker);
            setIsTruncated(model.isTruncated);
            setNextMarker(model.nextMarker);
            setMaxItems(model.maxItems);
        }

        public final Collection<HostedZone> getHostedZones() {
            return hostedZones;
        }

        @Override
        public final Builder hostedZones(Collection<HostedZone> hostedZones) {
            this.hostedZones = HostedZonesCopier.copy(hostedZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostedZones(HostedZone... hostedZones) {
            hostedZones(Arrays.asList(hostedZones));
            return this;
        }

        public final void setHostedZones(Collection<HostedZone> hostedZones) {
            this.hostedZones = HostedZonesCopier.copy(hostedZones);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListHostedZonesResponse build() {
            return new ListHostedZonesResponse(this);
        }
    }
}
