/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the information about the request to list your traffic policy instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTrafficPolicyInstancesByPolicyRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListTrafficPolicyInstancesByPolicyRequest.Builder, ListTrafficPolicyInstancesByPolicyRequest> {
    private final String trafficPolicyId;

    private final Integer trafficPolicyVersion;

    private final String hostedZoneIdMarker;

    private final String trafficPolicyInstanceNameMarker;

    private final String trafficPolicyInstanceTypeMarker;

    private final String maxItems;

    private ListTrafficPolicyInstancesByPolicyRequest(BuilderImpl builder) {
        this.trafficPolicyId = builder.trafficPolicyId;
        this.trafficPolicyVersion = builder.trafficPolicyVersion;
        this.hostedZoneIdMarker = builder.hostedZoneIdMarker;
        this.trafficPolicyInstanceNameMarker = builder.trafficPolicyInstanceNameMarker;
        this.trafficPolicyInstanceTypeMarker = builder.trafficPolicyInstanceTypeMarker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The ID of the traffic policy for which you want to list traffic policy instances.
     * </p>
     * 
     * @return The ID of the traffic policy for which you want to list traffic policy instances.
     */
    public String trafficPolicyId() {
        return trafficPolicyId;
    }

    /**
     * <p>
     * The version of the traffic policy for which you want to list traffic policy instances. The version must be
     * associated with the traffic policy that is specified by <code>TrafficPolicyId</code>.
     * </p>
     * 
     * @return The version of the traffic policy for which you want to list traffic policy instances. The version must
     *         be associated with the traffic policy that is specified by <code>TrafficPolicyId</code>.
     */
    public Integer trafficPolicyVersion() {
        return trafficPolicyVersion;
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic
     * policy instances. To get more traffic policy instances, submit another
     * <code>ListTrafficPolicyInstancesByPolicy</code> request.
     * </p>
     * <p>
     * For the value of <code>hostedzoneid</code>, specify the value of <code>HostedZoneIdMarker</code> from the
     * previous response, which is the hosted zone ID of the first traffic policy instance that Amazon Route 53 will
     * return if you submit another request.
     * </p>
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
     * traffic policy instances to get.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
     *         traffic policy instances. To get more traffic policy instances, submit another
     *         <code>ListTrafficPolicyInstancesByPolicy</code> request. </p>
     *         <p>
     *         For the value of <code>hostedzoneid</code>, specify the value of <code>HostedZoneIdMarker</code> from the
     *         previous response, which is the hosted zone ID of the first traffic policy instance that Amazon Route 53
     *         will return if you submit another request.
     *         </p>
     *         <p>
     *         If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
     *         more traffic policy instances to get.
     */
    public String hostedZoneIdMarker() {
        return hostedZoneIdMarker;
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic
     * policy instances. To get more traffic policy instances, submit another
     * <code>ListTrafficPolicyInstancesByPolicy</code> request.
     * </p>
     * <p>
     * For the value of <code>trafficpolicyinstancename</code>, specify the value of
     * <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first traffic
     * policy instance that Amazon Route 53 will return if you submit another request.
     * </p>
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
     * traffic policy instances to get.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
     *         traffic policy instances. To get more traffic policy instances, submit another
     *         <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
     *         <p>
     *         For the value of <code>trafficpolicyinstancename</code>, specify the value of
     *         <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first
     *         traffic policy instance that Amazon Route 53 will return if you submit another request.
     *         </p>
     *         <p>
     *         If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
     *         more traffic policy instances to get.
     */
    public String trafficPolicyInstanceNameMarker() {
        return trafficPolicyInstanceNameMarker;
    }

    /**
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more traffic
     * policy instances. To get more traffic policy instances, submit another
     * <code>ListTrafficPolicyInstancesByPolicy</code> request.
     * </p>
     * <p>
     * For the value of <code>trafficpolicyinstancetype</code>, specify the value of
     * <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the name of the first traffic
     * policy instance that Amazon Route 53 will return if you submit another request.
     * </p>
     * <p>
     * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
     * traffic policy instances to get.
     * </p>
     * 
     * @return If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
     *         traffic policy instances. To get more traffic policy instances, submit another
     *         <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
     *         <p>
     *         For the value of <code>trafficpolicyinstancetype</code>, specify the value of
     *         <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the name of the first
     *         traffic policy instance that Amazon Route 53 will return if you submit another request.
     *         </p>
     *         <p>
     *         If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
     *         more traffic policy instances to get.
     * @see RRType
     */
    public String trafficPolicyInstanceTypeMarker() {
        return trafficPolicyInstanceTypeMarker;
    }

    /**
     * <p>
     * The maximum number of traffic policy instances to be included in the response body for this request. If you have
     * more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code> element in
     * the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>,
     * <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the
     * first traffic policy instance that Amazon Route 53 will return if you submit another request.
     * </p>
     * 
     * @return The maximum number of traffic policy instances to be included in the response body for this request. If
     *         you have more than <code>MaxItems</code> traffic policy instances, the value of the
     *         <code>IsTruncated</code> element in the response is <code>true</code>, and the values of
     *         <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
     *         <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance that Amazon
     *         Route 53 will return if you submit another request.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((trafficPolicyId() == null) ? 0 : trafficPolicyId().hashCode());
        hashCode = 31 * hashCode + ((trafficPolicyVersion() == null) ? 0 : trafficPolicyVersion().hashCode());
        hashCode = 31 * hashCode + ((hostedZoneIdMarker() == null) ? 0 : hostedZoneIdMarker().hashCode());
        hashCode = 31 * hashCode
                + ((trafficPolicyInstanceNameMarker() == null) ? 0 : trafficPolicyInstanceNameMarker().hashCode());
        hashCode = 31 * hashCode
                + ((trafficPolicyInstanceTypeMarker() == null) ? 0 : trafficPolicyInstanceTypeMarker().hashCode());
        hashCode = 31 * hashCode + ((maxItems() == null) ? 0 : maxItems().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPolicyInstancesByPolicyRequest)) {
            return false;
        }
        ListTrafficPolicyInstancesByPolicyRequest other = (ListTrafficPolicyInstancesByPolicyRequest) obj;
        if (other.trafficPolicyId() == null ^ this.trafficPolicyId() == null) {
            return false;
        }
        if (other.trafficPolicyId() != null && !other.trafficPolicyId().equals(this.trafficPolicyId())) {
            return false;
        }
        if (other.trafficPolicyVersion() == null ^ this.trafficPolicyVersion() == null) {
            return false;
        }
        if (other.trafficPolicyVersion() != null && !other.trafficPolicyVersion().equals(this.trafficPolicyVersion())) {
            return false;
        }
        if (other.hostedZoneIdMarker() == null ^ this.hostedZoneIdMarker() == null) {
            return false;
        }
        if (other.hostedZoneIdMarker() != null && !other.hostedZoneIdMarker().equals(this.hostedZoneIdMarker())) {
            return false;
        }
        if (other.trafficPolicyInstanceNameMarker() == null ^ this.trafficPolicyInstanceNameMarker() == null) {
            return false;
        }
        if (other.trafficPolicyInstanceNameMarker() != null
                && !other.trafficPolicyInstanceNameMarker().equals(this.trafficPolicyInstanceNameMarker())) {
            return false;
        }
        if (other.trafficPolicyInstanceTypeMarker() == null ^ this.trafficPolicyInstanceTypeMarker() == null) {
            return false;
        }
        if (other.trafficPolicyInstanceTypeMarker() != null
                && !other.trafficPolicyInstanceTypeMarker().equals(this.trafficPolicyInstanceTypeMarker())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (trafficPolicyId() != null) {
            sb.append("TrafficPolicyId: ").append(trafficPolicyId()).append(",");
        }
        if (trafficPolicyVersion() != null) {
            sb.append("TrafficPolicyVersion: ").append(trafficPolicyVersion()).append(",");
        }
        if (hostedZoneIdMarker() != null) {
            sb.append("HostedZoneIdMarker: ").append(hostedZoneIdMarker()).append(",");
        }
        if (trafficPolicyInstanceNameMarker() != null) {
            sb.append("TrafficPolicyInstanceNameMarker: ").append(trafficPolicyInstanceNameMarker()).append(",");
        }
        if (trafficPolicyInstanceTypeMarker() != null) {
            sb.append("TrafficPolicyInstanceTypeMarker: ").append(trafficPolicyInstanceTypeMarker()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListTrafficPolicyInstancesByPolicyRequest> {
        /**
         * <p>
         * The ID of the traffic policy for which you want to list traffic policy instances.
         * </p>
         * 
         * @param trafficPolicyId
         *        The ID of the traffic policy for which you want to list traffic policy instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyId(String trafficPolicyId);

        /**
         * <p>
         * The version of the traffic policy for which you want to list traffic policy instances. The version must be
         * associated with the traffic policy that is specified by <code>TrafficPolicyId</code>.
         * </p>
         * 
         * @param trafficPolicyVersion
         *        The version of the traffic policy for which you want to list traffic policy instances. The version
         *        must be associated with the traffic policy that is specified by <code>TrafficPolicyId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyVersion(Integer trafficPolicyVersion);

        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         * traffic policy instances. To get more traffic policy instances, submit another
         * <code>ListTrafficPolicyInstancesByPolicy</code> request.
         * </p>
         * <p>
         * For the value of <code>hostedzoneid</code>, specify the value of <code>HostedZoneIdMarker</code> from the
         * previous response, which is the hosted zone ID of the first traffic policy instance that Amazon Route 53 will
         * return if you submit another request.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * traffic policy instances to get.
         * </p>
         * 
         * @param hostedZoneIdMarker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        traffic policy instances. To get more traffic policy instances, submit another
         *        <code>ListTrafficPolicyInstancesByPolicy</code> request. </p>
         *        <p>
         *        For the value of <code>hostedzoneid</code>, specify the value of <code>HostedZoneIdMarker</code> from
         *        the previous response, which is the hosted zone ID of the first traffic policy instance that Amazon
         *        Route 53 will return if you submit another request.
         *        </p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more traffic policy instances to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneIdMarker(String hostedZoneIdMarker);

        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         * traffic policy instances. To get more traffic policy instances, submit another
         * <code>ListTrafficPolicyInstancesByPolicy</code> request.
         * </p>
         * <p>
         * For the value of <code>trafficpolicyinstancename</code>, specify the value of
         * <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the first
         * traffic policy instance that Amazon Route 53 will return if you submit another request.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * traffic policy instances to get.
         * </p>
         * 
         * @param trafficPolicyInstanceNameMarker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        traffic policy instances. To get more traffic policy instances, submit another
         *        <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
         *        <p>
         *        For the value of <code>trafficpolicyinstancename</code>, specify the value of
         *        <code>TrafficPolicyInstanceNameMarker</code> from the previous response, which is the name of the
         *        first traffic policy instance that Amazon Route 53 will return if you submit another request.
         *        </p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more traffic policy instances to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker);

        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         * traffic policy instances. To get more traffic policy instances, submit another
         * <code>ListTrafficPolicyInstancesByPolicy</code> request.
         * </p>
         * <p>
         * For the value of <code>trafficpolicyinstancetype</code>, specify the value of
         * <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the name of the first
         * traffic policy instance that Amazon Route 53 will return if you submit another request.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * traffic policy instances to get.
         * </p>
         * 
         * @param trafficPolicyInstanceTypeMarker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        traffic policy instances. To get more traffic policy instances, submit another
         *        <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
         *        <p>
         *        For the value of <code>trafficpolicyinstancetype</code>, specify the value of
         *        <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the name of the
         *        first traffic policy instance that Amazon Route 53 will return if you submit another request.
         *        </p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more traffic policy instances to get.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder trafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker);

        /**
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         * traffic policy instances. To get more traffic policy instances, submit another
         * <code>ListTrafficPolicyInstancesByPolicy</code> request.
         * </p>
         * <p>
         * For the value of <code>trafficpolicyinstancetype</code>, specify the value of
         * <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the name of the first
         * traffic policy instance that Amazon Route 53 will return if you submit another request.
         * </p>
         * <p>
         * If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no more
         * traffic policy instances to get.
         * </p>
         * 
         * @param trafficPolicyInstanceTypeMarker
         *        If the value of <code>IsTruncated</code> in the previous response was <code>true</code>, you have more
         *        traffic policy instances. To get more traffic policy instances, submit another
         *        <code>ListTrafficPolicyInstancesByPolicy</code> request.</p>
         *        <p>
         *        For the value of <code>trafficpolicyinstancetype</code>, specify the value of
         *        <code>TrafficPolicyInstanceTypeMarker</code> from the previous response, which is the name of the
         *        first traffic policy instance that Amazon Route 53 will return if you submit another request.
         *        </p>
         *        <p>
         *        If the value of <code>IsTruncated</code> in the previous response was <code>false</code>, there are no
         *        more traffic policy instances to get.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder trafficPolicyInstanceTypeMarker(RRType trafficPolicyInstanceTypeMarker);

        /**
         * <p>
         * The maximum number of traffic policy instances to be included in the response body for this request. If you
         * have more than <code>MaxItems</code> traffic policy instances, the value of the <code>IsTruncated</code>
         * element in the response is <code>true</code>, and the values of <code>HostedZoneIdMarker</code>,
         * <code>TrafficPolicyInstanceNameMarker</code>, and <code>TrafficPolicyInstanceTypeMarker</code> represent the
         * first traffic policy instance that Amazon Route 53 will return if you submit another request.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of traffic policy instances to be included in the response body for this request.
         *        If you have more than <code>MaxItems</code> traffic policy instances, the value of the
         *        <code>IsTruncated</code> element in the response is <code>true</code>, and the values of
         *        <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
         *        <code>TrafficPolicyInstanceTypeMarker</code> represent the first traffic policy instance that Amazon
         *        Route 53 will return if you submit another request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    private static final class BuilderImpl implements Builder {
        private String trafficPolicyId;

        private Integer trafficPolicyVersion;

        private String hostedZoneIdMarker;

        private String trafficPolicyInstanceNameMarker;

        private String trafficPolicyInstanceTypeMarker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPolicyInstancesByPolicyRequest model) {
            setTrafficPolicyId(model.trafficPolicyId);
            setTrafficPolicyVersion(model.trafficPolicyVersion);
            setHostedZoneIdMarker(model.hostedZoneIdMarker);
            setTrafficPolicyInstanceNameMarker(model.trafficPolicyInstanceNameMarker);
            setTrafficPolicyInstanceTypeMarker(model.trafficPolicyInstanceTypeMarker);
            setMaxItems(model.maxItems);
        }

        public final String getTrafficPolicyId() {
            return trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        public final Integer getTrafficPolicyVersion() {
            return trafficPolicyVersion;
        }

        @Override
        public final Builder trafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
            return this;
        }

        public final void setTrafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
        }

        public final String getHostedZoneIdMarker() {
            return hostedZoneIdMarker;
        }

        @Override
        public final Builder hostedZoneIdMarker(String hostedZoneIdMarker) {
            this.hostedZoneIdMarker = hostedZoneIdMarker;
            return this;
        }

        public final void setHostedZoneIdMarker(String hostedZoneIdMarker) {
            this.hostedZoneIdMarker = hostedZoneIdMarker;
        }

        public final String getTrafficPolicyInstanceNameMarker() {
            return trafficPolicyInstanceNameMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
            return this;
        }

        public final void setTrafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
        }

        public final String getTrafficPolicyInstanceTypeMarker() {
            return trafficPolicyInstanceTypeMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
            return this;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(RRType trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker(trafficPolicyInstanceTypeMarker.toString());
            return this;
        }

        public final void setTrafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListTrafficPolicyInstancesByPolicyRequest build() {
            return new ListTrafficPolicyInstancesByPolicyRequest(this);
        }
    }
}
