/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the information about the request to list your traffic policies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListTrafficPolicyVersionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListTrafficPolicyVersionsRequest.Builder, ListTrafficPolicyVersionsRequest> {
    private final String id;

    private final String trafficPolicyVersionMarker;

    private final String maxItems;

    private ListTrafficPolicyVersionsRequest(BuilderImpl builder) {
        this.id = builder.id;
        this.trafficPolicyVersionMarker = builder.trafficPolicyVersionMarker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * Specify the value of <code>Id</code> of the traffic policy for which you want to list all versions.
     * </p>
     * 
     * @return Specify the value of <code>Id</code> of the traffic policy for which you want to list all versions.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * For your first request to <code>ListTrafficPolicyVersions</code>, don't include the
     * <code>TrafficPolicyVersionMarker</code> parameter.
     * </p>
     * <p>
     * If you have more traffic policy versions than the value of <code>MaxItems</code>,
     * <code>ListTrafficPolicyVersions</code> returns only the first group of <code>MaxItems</code> versions. To get
     * more traffic policy versions, submit another <code>ListTrafficPolicyVersions</code> request. For the value of
     * <code>TrafficPolicyVersionMarker</code>, specify the value of <code>TrafficPolicyVersionMarker</code> in the
     * previous response.
     * </p>
     * 
     * @return For your first request to <code>ListTrafficPolicyVersions</code>, don't include the
     *         <code>TrafficPolicyVersionMarker</code> parameter.</p>
     *         <p>
     *         If you have more traffic policy versions than the value of <code>MaxItems</code>,
     *         <code>ListTrafficPolicyVersions</code> returns only the first group of <code>MaxItems</code> versions. To
     *         get more traffic policy versions, submit another <code>ListTrafficPolicyVersions</code> request. For the
     *         value of <code>TrafficPolicyVersionMarker</code>, specify the value of
     *         <code>TrafficPolicyVersionMarker</code> in the previous response.
     */
    public String trafficPolicyVersionMarker() {
        return trafficPolicyVersionMarker;
    }

    /**
     * <p>
     * The maximum number of traffic policy versions that you want Amazon Route 53 to include in the response body for
     * this request. If the specified traffic policy has more than <code>MaxItems</code> versions, the value of
     * <code>IsTruncated</code> in the response is <code>true</code>, and the value of the
     * <code>TrafficPolicyVersionMarker</code> element is the ID of the first version that Amazon Route 53 will return
     * if you submit another request.
     * </p>
     * 
     * @return The maximum number of traffic policy versions that you want Amazon Route 53 to include in the response
     *         body for this request. If the specified traffic policy has more than <code>MaxItems</code> versions, the
     *         value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of the
     *         <code>TrafficPolicyVersionMarker</code> element is the ID of the first version that Amazon Route 53 will
     *         return if you submit another request.
     */
    public String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((trafficPolicyVersionMarker() == null) ? 0 : trafficPolicyVersionMarker().hashCode());
        hashCode = 31 * hashCode + ((maxItems() == null) ? 0 : maxItems().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPolicyVersionsRequest)) {
            return false;
        }
        ListTrafficPolicyVersionsRequest other = (ListTrafficPolicyVersionsRequest) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.trafficPolicyVersionMarker() == null ^ this.trafficPolicyVersionMarker() == null) {
            return false;
        }
        if (other.trafficPolicyVersionMarker() != null
                && !other.trafficPolicyVersionMarker().equals(this.trafficPolicyVersionMarker())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (trafficPolicyVersionMarker() != null) {
            sb.append("TrafficPolicyVersionMarker: ").append(trafficPolicyVersionMarker()).append(",");
        }
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListTrafficPolicyVersionsRequest> {
        /**
         * <p>
         * Specify the value of <code>Id</code> of the traffic policy for which you want to list all versions.
         * </p>
         * 
         * @param id
         *        Specify the value of <code>Id</code> of the traffic policy for which you want to list all versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * For your first request to <code>ListTrafficPolicyVersions</code>, don't include the
         * <code>TrafficPolicyVersionMarker</code> parameter.
         * </p>
         * <p>
         * If you have more traffic policy versions than the value of <code>MaxItems</code>,
         * <code>ListTrafficPolicyVersions</code> returns only the first group of <code>MaxItems</code> versions. To get
         * more traffic policy versions, submit another <code>ListTrafficPolicyVersions</code> request. For the value of
         * <code>TrafficPolicyVersionMarker</code>, specify the value of <code>TrafficPolicyVersionMarker</code> in the
         * previous response.
         * </p>
         * 
         * @param trafficPolicyVersionMarker
         *        For your first request to <code>ListTrafficPolicyVersions</code>, don't include the
         *        <code>TrafficPolicyVersionMarker</code> parameter.</p>
         *        <p>
         *        If you have more traffic policy versions than the value of <code>MaxItems</code>,
         *        <code>ListTrafficPolicyVersions</code> returns only the first group of <code>MaxItems</code> versions.
         *        To get more traffic policy versions, submit another <code>ListTrafficPolicyVersions</code> request.
         *        For the value of <code>TrafficPolicyVersionMarker</code>, specify the value of
         *        <code>TrafficPolicyVersionMarker</code> in the previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyVersionMarker(String trafficPolicyVersionMarker);

        /**
         * <p>
         * The maximum number of traffic policy versions that you want Amazon Route 53 to include in the response body
         * for this request. If the specified traffic policy has more than <code>MaxItems</code> versions, the value of
         * <code>IsTruncated</code> in the response is <code>true</code>, and the value of the
         * <code>TrafficPolicyVersionMarker</code> element is the ID of the first version that Amazon Route 53 will
         * return if you submit another request.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of traffic policy versions that you want Amazon Route 53 to include in the response
         *        body for this request. If the specified traffic policy has more than <code>MaxItems</code> versions,
         *        the value of <code>IsTruncated</code> in the response is <code>true</code>, and the value of the
         *        <code>TrafficPolicyVersionMarker</code> element is the ID of the first version that Amazon Route 53
         *        will return if you submit another request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String trafficPolicyVersionMarker;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPolicyVersionsRequest model) {
            setId(model.id);
            setTrafficPolicyVersionMarker(model.trafficPolicyVersionMarker);
            setMaxItems(model.maxItems);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getTrafficPolicyVersionMarker() {
            return trafficPolicyVersionMarker;
        }

        @Override
        public final Builder trafficPolicyVersionMarker(String trafficPolicyVersionMarker) {
            this.trafficPolicyVersionMarker = trafficPolicyVersionMarker;
            return this;
        }

        public final void setTrafficPolicyVersionMarker(String trafficPolicyVersionMarker) {
            this.trafficPolicyVersionMarker = trafficPolicyVersionMarker;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListTrafficPolicyVersionsRequest build() {
            return new ListTrafficPolicyVersionsRequest(this);
        }
    }
}
